/**
 * Created by Compas on 12.09.14.
 */
    var MAX_ALLOWED_CAPTAINS = 3,
        MAX_ALLOWED_DIVERSIONS = 3,
        MAX_ALLOWED_CABIN_CREW = 8;

    /**
     * Create date time picker fields
     * @return void
     */
    var _loading = $("#loading"),
        _start_date = $("#from"),
        _end_date = $("#to"),
        _save_flight_crew = $(".save-flight-crew"),
        _btn_send_cancel_notifications = $(".btn-send-cancel-notifications"),
        $select2 = $(document).find(".select2");

    /*
    I don't know //
    $select2.find("option:first").remove();

    $select2.select2({
        placeholder: "Select flight crew item",
        allowClear: true
    });
    */

    /**
     * Add person button click handler
     * @return {Boolean}
     */
    console.log($(document).find(".add-crew").length);

    $(document).on("click", ".add-crew", function () {
        var _this = $(this), _this_parent = _this.parent(), label, _prev = _this_parent.prev().clone(),  maxAllowed = parseInt(_this.attr('data-maxAllowed')),
            field_name = _this.attr("data-field"), crew_type = _this.attr('data-crew_type'),
            item_number = parseInt(_prev.attr("data-item-number"));

        _prev.find("select")
            .val("");

        if (item_number == maxAllowed) {
            //_this.attr("disabled", true);
            //showMessage("Not more available", "Information", MESSAGE_INFO, $("#message_container"));
            return false;
        }

        item_number++;
        _prev.attr("data-item-number", item_number);
        _prev.find("label").html(crew_type +" #"+ item_number);
        _prev.find("select")
            .val("")
            .attr("id", field_name + item_number);

        var html = $("<div></div>")
            //.append('<br />')
            .append(_prev).html();
        $(html).insertBefore(_this_parent);
        var id_name = field_name + item_number;
        _this.parents('table').find($('select#'+id_name)).val("");

        return true;
    })
    .on("click", ".remove-crew", function () {
        var _this = $(this), _prev = _this.parent().prev().not("br"), minAllowed = parseInt(_this.attr('data-minAllowed')),
            crew_type = _this.attr('data-crew_type'), item_number = parseInt(_prev.attr("data-item-number"));

        if (!item_number || item_number == minAllowed) {

            _prev.find("select")
                .val("");

            return false;
        }

        _prev.remove();

        return true;
    });


    /**
     * Send cancel notification button click handler
     * @return void
     */
    _btn_send_cancel_notifications.on("click", function () {
        var _this = $(this), _parent = _this.parent(),
            flight_id = _parent.parent().attr("id").replace("flight-", ""),
            _captains = _parent.find("#captains_cancelled"),
            _first_officers = _parent.find("#first_officers_cancelled"),
            _cabin_crew = _parent.find("#cabin_crew_cancelled"),
            _message_block = $("#message-block"),
            request;

        if (!_captains.val() && !_first_officers.val() && !_cabin_crew.val()) {
            return false;
        }

        _loading.show();
        _this.attr("disabled", true);
        request = $.ajax({
            url: baseUrl + "/crew-schedule/ajax-send-cancel-notification",
            type: "POST",
            dataType: "json",
            data: {
                flight_id: flight_id,
                captains: _captains.val(),
                first_officers: _first_officers.val(),
                cabin_crew: _cabin_crew.val()
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, "Success!", MESSAGE_SUCCESS, _message_block);
                _captains.val("");
                _first_officers.val("");
                _cabin_crew.val("");
            } else {
                showMessage(data.message, "Error", MESSAGE_DANGER, _message_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, _message_block);
        });
        request.always(function () {
            _this.attr("disabled", false);
            _loading.hide();
        });
    });

    function multiselect_deselectAll($el) {
        $('option', $el).each(function(element) {
            $el.multiselect('deselect', $(this).val());
        });
    }

    /**
     * Save flight crew button click handler
     */
    $(document).on("click", ".save-flight-crew", function () {

        var _this = $(this), request,
            table = _this.parents("table"),
            message_block = $("#message-block"),
            flight_id = table.attr("id").replace("flight-", ""),
            child_id = table.attr("data-child-id").replace("data-flight-id", ""),
            result_array = {
                "flight_id": flight_id,
                "child_id": child_id
            }, flight_crew;

        _loading.show();
        _this.attr("disabled", true);
        flight_crew = get_flight_crew(table);

        result_array.captains = flight_crew.captains;
        result_array.first_officers = flight_crew.first_officers;
        result_array.cabin_crew = flight_crew.cabin_crew;

        request = $.ajax({
            headers: {
                'x-csrf-token': $(this).parents('form').find('input[name=_token]').val()
            },
            type: "POST",
            url: baseUrl + "/crew-schedule/ajax-save-crew",
            dataType: "json",
            data: result_array
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, "Success", MESSAGE_SUCCESS, message_block);
            } else {
                showMessage(data.message, "Error!", MESSAGE_DANGER, message_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
        request.always(function () {
            _this.attr("disabled", false);
            _loading.hide();
        });
    });

    /**
     * Send flight crew email button click handler
     * @return void
     */
    $(document).on("click", ".send-email-to-flight-crew", function () {
        var _this = $(this), request,
            table = _this.parents("table"), crewType = _this.parent().prev().find('select[name=crewType]').val(),
            message_block = $("#message-block"),
            flight_id = table.attr("id").replace("flight-", ""),
            child_id = table.attr("data-child-id").replace("data-flight-id", ""),
            token = _this.parents('form').find('input[name=_token]').val(),
            result_array = {
                "flight_id": flight_id,
                "child_id": child_id
            }, flight_crew;

        _loading.show();
        _this.attr("disabled", true);
        flight_crew = get_flight_crew(table);
        result_array.captains = flight_crew.captains;
        result_array.first_officers = flight_crew.first_officers;
        result_array.cabin_crew = flight_crew.cabin_crew;
        result_array.crewType = crewType;

        console.log(flight_crew)
        request = $.ajax({
            headers: {
                'x-csrf-token': token
            },
            type: "POST",
            url: baseUrl + "/crew-schedule/ajax-send-flight-crew-email",
            dataType: "json",
            data: result_array
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, "Success", MESSAGE_SUCCESS, message_block);
            } else {
                showMessage(data.message, "Error!", MESSAGE_DANGER, message_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
        request.always(function () {
            _this.attr("disabled", false);
            _loading.hide();
        });
    });


    $('#crewType').change(function () {
        var _this = $(this), individualCrewType = $('.individualCrewType');
        individualCrewType.val(_this.val());
    });

    /**
     * Send all flight emails click handler
     * @return void
     */
    $(document).on("click", "#btn-send-all-flights-email", function () {
        var _this = $(this), request, eachTable,
            crewType = _this.parent().find('select[name=crewType]').val(),
            message_block = $("#message-block"),
            result_array = [], flight_crew,
            all_tables = $("#flights-form").find("table"),
            from = $("#from").val(),
            to = $("#to").val();

        _loading.show();
        _this.attr("disabled", true);

        if (all_tables.length) {
            for (var i = 0, l = all_tables.length; i < l; i++) {
                eachTable = $(all_tables[i]);
                flight_crew = get_flight_crew(eachTable);
                result_array.push({
                    "flight_id": eachTable.attr("id").replace("flight-", ""),
                    "child_id":  eachTable.attr("data-child-id")
                });

            }
        } else {
            showMessage("Not found any flight, please check your data", "Error", MESSAGE_DANGER, message_block);
            return false;
        }

        console.log(result_array)

        request = $.ajax({
            headers: {
                'x-csrf-token': $(this).parents('form').find('input[name=_token]').val()
            },
            type: "POST",
            url: baseUrl + "/crew-schedule/ajax-send-all-flights-schedule-email",
            dataType: "json",
            data: {
                crewType : crewType,
                flights : result_array,
                from : from,
                to : to
            }
        });

        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, "Success", MESSAGE_SUCCESS, message_block);
            } else {
                showMessage(data.message, "Error!", MESSAGE_DANGER, message_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
        request.always(function () {
            _this.attr("disabled", false);
            _loading.hide();
        });
    });

    /**
     * Get flight crew array
     * @param target
     * @returns {{captains: Array, first_officers: Array, cabin_crew: Array}}
     */
    function get_flight_crew(parent) {
        var i, l, id, is_sup, is_dhc, is_standby, position_order, item,
            captains = parent.find("td.captains select"), user_id,
            first_officers = parent.find("td.first_officers select"),
            cabin_crew = parent.find("td.cabin_crew select"),
            cabin_crew_dhc_standby = parent.find("td.cabin_crew_dhc_standby select"),
            result_array = {
                "captains": [],
                "first_officers": [],
                "cabin_crew": []
            };

        if (captains.length) {
            for (i = 0 , l = captains.length; i < l; i++) {
                item = $(captains[i]);
                user_id = item.val();

                if (item.is(":disabled") || user_id == '') {
                    continue;
                }
                id = item.attr("id");
                if (id.indexOf("captain_dhc") !== -1) {
                    is_dhc = 1;
                    is_standby = 0;
                    position_order = parseInt(id.replace("captain_dhc", "") - 1) ;
                }
                else if (id.indexOf("captain_standby") !== -1) {
                    is_dhc = 0;
                    is_standby = 1;
                    position_order = parseInt(id.replace("captain_standby", "") - 1);
                }
                else {
                    is_standby = 0;
                    is_dhc = 0;
                    position_order = parseInt(id.replace("captain", "")) - 1;
                }

                result_array.captains.push({
                    "user_id"           : user_id,
                    "is_dhc"            : is_dhc,
                    "is_standby"        : is_standby,
                    "position_order"    : position_order
                });
            }
        }

        if (first_officers.length) {
            for (i = 0, l = first_officers.length; i < l; i++) {
                item = $(first_officers[i]);
                user_id = item.val();

                if (item.is(":disabled") || user_id == '') {
                    continue;
                }
                id = item.attr("id");
                if (id.indexOf("first_officer_dhc") !== -1) {
                    is_dhc = 1;
                    is_standby = 0;
                    position_order = parseInt(id.replace("first_officer_dhc", "") - 1);
                }
                else if (id.indexOf("first_officer_standby") !== -1) {
                    is_dhc = 0;
                    is_standby = 1;
                    position_order = parseInt(id.replace("first_officer_standby", "") - 1);
                }
                else {
                    is_dhc = 0;
                    is_standby = 0;
                    position_order = parseInt(id.replace("first_officer", "")) - 1;
                }
                result_array.first_officers.push({
                    "user_id"           : item.val(),
                    "is_dhc"            : is_dhc,
                    "is_standby"        : is_standby,
                    "position_order"    : position_order
                });
            }
        }

        if (cabin_crew.length) {
            for (i = 0, l = cabin_crew.length; i < l; i++) {
                item = $(cabin_crew[i]);
                user_id = item.val();

                if (item.is(":disabled") || user_id == '') {
                    continue;
                }
                id = item.attr("id");
                position_order = parseInt(id.replace("cabin_crew", "")) - 1;
                result_array.cabin_crew.push({
                    "user_id"       : item.val(),
                    "is_sup"        : 0,
                    "is_dhc"        : 0,
                    "is_standby"    : 0,
                    "position_order": position_order
                });
            }
        }
        if (cabin_crew_dhc_standby.length) {
            for (i = 0, l = cabin_crew_dhc_standby.length; i < l; i++) {

                item = $(cabin_crew_dhc_standby[i]);
                user_id = item.val();

                if (item.is(":disabled") || user_id == '') {
                    continue;
                }

                id = item.attr("id");
                if (id.indexOf("cabin_crew_sup") !== -1) {
                    is_sup = 1;
                    is_dhc = 0;
                    is_standby = 0;
                    position_order = parseInt(id.replace("cabin_crew_sup", "") - 1);
                }
                else if (id.indexOf("cabin_crew_dhc") !== -1) {
                    is_sup = 0;
                    is_dhc = 1;
                    is_standby = 0;
                    position_order = parseInt(id.replace("cabin_crew_dhc", "") - 1);
                }
                else{
                    is_sup = 0;
                    is_dhc = 0;
                    is_standby = 1;
                    position_order = parseInt(id.replace("cabin_crew_standby", "") - 1);
                }

                result_array.cabin_crew.push({
                    "user_id"       : item.val(),
                    "is_sup"        : is_sup,
                    "is_dhc"        : is_dhc,
                    "is_standby"    : is_standby,
                    "position_order": position_order
                });
            }
        }
        return result_array;
    }

