
$(document).on('change', 'select[name=category]', function () {
    select_category_change($(this));
});


$(document).on('change', '#incomeLevels', function () {
    select_income_level_change($(this), 'incomelevel');
});

$(document).on('change', '#regions', function () {
    select_income_level_change($(this), 'region');
});


function select_income_level_change(_this, type){
    var selected_ids = _this.val(), form = _this.parents('form'), countries = form.find('select[name="countries[]"]'), new_country_list,
        countries_parent = countries.parents('.list-header').first(),
        region_parent = form.find('#regions').parents('.list-header').first();

    if (selected_ids) {
        if (countries.length) {
            countries_parent.remove();
        }
        if (selected_ids) {
            $.get(baseUrl + '/template/ajax-countries-by-income-level-or-region-id', {
                'type'              : type,
                'selected_ids'      : selected_ids,
                'additional_class'  : 'form-group'
            })
                .done(function (data) {
                    if (typeof data.success !== 'undefined' && data.success == false) {
                        var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                        form.append(div);

                    }
                    else {
                        region_parent.after(data);
                        new_country_list = form.find('select[name="countries[]"]');
                        new_country_list.attr('required', 'required');
                        Apply_Multiselect(new_country_list.parent());
                    }
                });
        }
    }
}


/**
 * Department Change Event Listener
 * @param _this
 */
function select_category_change(_this) {
    var category_id = _this.val(), indicators = $('select[name=indicator_id]'), form = _this.parents('form'),
        parent = indicators.parents('div.list-header').first(), form_submit = form.find('input[type=submit]').parents('.list-header');

    if (indicators.length){
        parent.remove();
    }

    if (category_id) {

        $.get(baseUrl + '/template/ajax-indicators-by-category-id', {
            'category_id'     : category_id,
            'additional_class'  : 'form-group'
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    form_submit.before(data);
                    form.find('select[name=indicator_id]').attr('required', 'required');
                }
            });
    }
}