/**
 * Created by Compas on 21.08.14.
 */

//$(function () {

    var message_block = $("#message_block"), table_date = $('table.data'), maintenance = $("#maintenance");

    $('#toggle_maintenance_block').click(function () {
        maintenance.toggle(400, function () {
            var $this = $(this);
            $("#add_maintenance").val(($this.is(":visible")) ? "1" : "0");
        });
    });

    if ($errorInput && $errorInput != '' && $errorInput == 'danger'){
        maintenance.toggle();
    }


    table_date.on('click', 'a.edit', function () {
        var parent_td = $(this).parents('td'), parent_tr = parent_td.parent('tr'),
            records = parent_tr.find('td.editable'), value, inputBox, _this, date_format;

        console.log(records)

        records.each(function () {
            date_format = 0;
            _this = $(this);
            value = _this.text();
            console.log(_this.html())
            inputBox = $('<input />').val(value);
            if (_this.attr('data-date_format')){
                date_format = _this.attr('data-date_format');
                inputBox.attr('class', 'date_format');
            }
            $(this).html(inputBox);

            if (date_format)
                Add_Date_Format(date_format, 'timepicker');
        });

        $(this).attr('class', 'btn btn-warning btn-sm save').text('Save');

    }).on('click', 'a.save', function () {

        var $this = $(this), parent_td = $(this).parents('td'), parent_tr = parent_td.parent('tr'), date_format, request, item = {},
            parent_div = parent_tr.parents('table.data').parent('div'), aircraftId = parent_div.attr('data-aircraftId'),
            records = parent_tr.find('td.editable > input'), value, inputBox, _this, _parent, _attr, _id, _model, data = {};

        records.each(function () {
            _this = $(this);
            _parent = _this.parent('td');
            _attr = _parent.attr('data-item');

            _id =  _parent.attr('data-id');
            _model = _parent.attr('data-model');


            if (typeof data[_model] === 'undefined')
                data[_model] = {};
            if (typeof data[_model][_id] === 'undefined')
                data[_model][_id] = {};
            if (typeof data[_model]['columns'] === 'undefined')
                data[_model]['columns'] = [];
            if (typeof data[_model][_id][_attr] === 'undefined')
                data[_model][_id][_attr] = {};

            data[_model][_id][_attr]['value'] = _this.val();
            data[_model]['columns'].push(_attr);
            if (_parent.attr('data-date_format')){
                data[_model][_id][_attr]['date_format'] = _parent.attr('data-date_format');
            }
        });



        loading_span.show();
        request = $.ajax({
            headers: {
                'x-csrf-token': $(".content-section").find('form').find('input[name=_token]').val()
            },
            url : baseUrl + '/change-record/ajax-save-record-universal',
            type: 'POST',
            dataType: "json",
            data: {
                parentId : aircraftId,
                data : data
            }
        });

        request.done(function (data) {
            if (data.success !== 'undefined'){
                if (data.success) {
                    records.each(function () {
                        _this = $(this);
                        _parent = _this.parent('td');
                        _parent.html(_this.val());
                    });
                    console.log('HERE')
                    $this.attr('class', 'btn btn-primary btn-sm edit').text('Edit');
                }
                getMessageDiv(data.type, parent_div, data.text);
            }
        });

        request.fail(function () {
            getMessageDiv("Error", parent_div, error_message);
        });

        request.always(function () {
            loading_span.hide();
        });


    });

    /**
     * Create date time picker fields
     * @return void
     */
    $('.datepicker').datetimepicker({
        format: 'Y-m-d H:i:s',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1
    });

    $("#first_flight").datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        timepicker: false,
        dayOfWeekStart: 1
    });

    /**
     * Remove maintenance
     * @return bool
     */
    $("#remove_maintenance").on("click", function() {
        var _this = $(this), aircraft_id = $("#aircraft_id").val(),
            request;

        if (!aircraft_id) {
            showMessage("Not found aircraft ID", "Validation Error:", MESSAGE_DANGER, message_block);
            return false;
        }

        _this.attr("disabled", true);
        request = $.ajax({
            url: baseUrl + "/aircraft/ajax-delete-maintenance",
            type: "GET",
            dataType: "json",
            data: {
                aircraft_id: aircraft_id
            }
        });
        request.done(function(data) {
            if (typeof data.success !== "undefined") {
                $("#toggle_maintenance_block").show().trigger("click");
                $("#note, #location_code, #departure_time, #arrival_time").val("");
                _this.hide();
            }
        });
        request.fail(function(jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
        request.always(function() {
            _this.attr("disabled", false);
        });
    });

//});