/**
 * Created by Compas on 21.08.14.
 */

$(function () {

    var message_block = $("#message_block");

    $('#toggle_maintenance_block').click(function () {
        $("#maintenance").toggle(400, function () {
            var $this = $(this);
            $("#add_maintenance").val(($this.is(":visible")) ? "1" : "0");
        });
    });

    /**
     * Create date time picker fields
     * @return void
     */
    $('.datepicker').datetimepicker({
        format: 'Y-m-d H:i:s',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1
    });

    $("#first_flight").datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        timepicker: false,
        dayOfWeekStart: 1
    });

    /**
     * Remove maintenance
     * @return bool
     */
    $("#remove_maintenance").on("click", function() {
        var _this = $(this), aircraft_id = $("#aircraft_id").val(),
            request;

        if (!aircraft_id) {
            showMessage("Not found aircraft ID", "Validation Error:", MESSAGE_DANGER, message_block);
            return false;
        }

        _this.attr("disabled", true);
        request = $.ajax({
            headers: {
                'x-csrf-token': _this.parents('form').find('input[name=_token]').val()
            },
            url: baseUrl + "/aircraft/ajax-delete-maintenance",
            type: "GET",
            dataType: "json",
            data: {
                aircraft_id: aircraft_id
            }
        });
        request.done(function(data) {
            if (typeof data.success !== "undefined") {
                $("#toggle_maintenance_block").show().trigger("click");
                $("#note, #location_code, #departure_time, #arrival_time").val("");
                _this.hide();
            }
        });
        request.fail(function(jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
        request.always(function() {
            _this.attr("disabled", false);
        });
    });

    /**
     * Edit button click handler
     * @return void
     */
    $(".edit-param").click(function () {
        var _this = $(this), parent = _this.parents("td"), prev = parent.prev(), value = $.trim(prev.html()),
            param_name = _this.attr("data-param");
        if (value == "—") {
            value = "";
        }
        prev.empty();
        prev.append($("<input type='text' class='form-control input-sm' style='width:200px' name='" + param_name + "' value='" + value + "' />"));
        _this.hide();
        _this.next().show();
        _this.next().next().show();
    });

    /**
     * Cancel button click handler
     * @return void
     */
    $(".cancel-param").click(function () {
        var _this = $(this), parent = _this.parents("td"), prev = parent.prev(),
            param_value = _this.attr("data-value");

        if (param_value == "") {
            param_value = "&mdash;";
        }
        prev.html(param_value);
        _this.hide();
        _this.prev().hide();
        _this.prev().prev().show();
    });

    /**
     * Save param button click handler
     * @return void
     */
    $(".save-param").click(function () {
        var _this = $(this), parent = _this.parents("td"), prev = parent.prev(), value = prev.find("input").val(),
            param_name = _this.attr("data-param"), request, message_block = $("#message-parameters");

        _this.attr("disabled", true);
        request = $.ajax({
            url: baseUrl + "/fleet-management/ajax-parameter",
            type: "GET",
            dataType: "json",
            data: {
                aircraft_id : _this.parents("table").attr("data-aircraft_id"),
                parameter   : param_name,
                value       : value
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, data.title, MESSAGE_SUCCESS, message_block);
                prev.html(value);
                _this.attr("data-value", value).hide();
                _this.prev().attr("data-value", value).show();
                _this.next().attr("data-value", value).hide();
            } else {
                showMessage(data.message, data.title, MESSAGE_WARNING, message_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
        request.always(function () {
            _this.attr("disabled", false);
        });
    });
});