/**
 * Created by Compas on 08.09.14.
 */

var SelectSync;
SelectSync = (function () {

    var selectedOptions,
        elements;

    /**
     * SelectSync class constructor method
     * @constructor
     */
    function SelectSync() {
        var _this = this;

        this.elements = arguments[0];
        this.selectedOptions = {};

        if (this.elements instanceof Array) {
            for (var i = 0, l = this.elements.length; i < l; i++) {
                var _el = $(this.elements[i]);
                _el.attr("data-index-attr", i);

                if (_el.val()) {
                    this.selectedOptions[i] = _el.val();
                }

                $(document).on("change", this.elements[i], function (e) {
                    _this.bindChangeEvent(e);
                });
            }
        }

        this.getCurrentIndex = function (el) {
            var id = el.attr("id"), currentIndex;

            for (var i = 0, l = this.elements.length; i < l; i++) {
                if (this.elements[i] == ("#" + id)) {
                    currentIndex = i;
                }
            }
            return currentIndex;
        };
        this.init();
    }

    /**
     * Initialize function
     */
    SelectSync.prototype.init = function () {
        if (this.elements.length) {
            _.each(this.elements, function (el, index) {
                var _el = $(el);
                var id = el.replace("#", "");
                if (_el.val()) {
                    this.selectedOptions[id] = _el.val();

                    // todo need to remove this selected value from all other select boxes
                }
            });
        }
    };

    /**
     * Bind onChange event for select box
     * @param e
     */
    SelectSync.prototype.bindChangeEvent = function (e) {
        var _el = $(e.currentTarget), id = _el.attr("id"), _this = this,
            currentIndex = this.getCurrentIndex(_el);

        //console.log(_el.val());
        this.selectedOptions[id] = _el.val();
        console.log(this.selectedOptions, Math.random());

        for (var i = 0, l = this.elements.length; i < l; i++) {
            var _el_item = $(this.elements[i]),
                options = _el_item.find("option"),
                id_item = this.elements[i].replace("#", "");
            //console.log(id_item);
            for (var j = 0, k = options.length; j < k ; j++) {
                var option_item = $(options[j]);
                if (option_item.attr("value") == "") {
                    continue;
                }
                for (var h in this.selectedOptions) {

                    //console.log(h);

                    if (this.selectedOptions.hasOwnProperty(h)) {
                        if (h == id_item || this.selectedOptions[h] == "") {
                            continue;
                        }
                        if (option_item.val() == this.selectedOptions[h]) {
                            option_item.attr("disabled", true);
                        } else {
                            option_item.attr("disabled", false);
                        }
                    }
                }
            }
        }
    };

    SelectSync.prototype.refresh = function() {
        for (var i = 0, l = this.elements.length; i < l; i++) {
            var _el_item = $(this.elements[i]), options = _el_item.find("option");
            for (var j = 0, k = options.length; j < k ; j++) {
                if ($(options[j]).attr("value") == "") {
                    continue;
                }
                for (var h in this.selectedOptions) {
                    if (this.selectedOptions.hasOwnProperty(h)) {
                        if (h == i) {
                            continue;
                        }
                        if ($(options[j]).val() == this.selectedOptions[h]) {
                            $(options[j]).attr("disabled", true);
                        }
                    }
                }
            }
        }
    };


    /**
     * Set up field
     * @param field
     * @param i
     * @param option_html
     * @returns {*}
     */
    SelectSync.prototype.set_up_field = function (field, i, option_html) {

        //field.html(option_html);
        field[0].new_index = i;

        var _this = this;
        $(document).on("change", "select", function (e) {
            console.log(1);
            _this.field_change(e);
        });
        /*
         return field.change(__bind(function (evt) {
         return this.field_change(evt);
         }, this));
         */
    };

    /**
     * Field change event
     * @param evt
     * @returns {Array}
     */
    SelectSync.prototype.field_change = function (evt) {
        var field, new_index, val, _i, _len, _ref, _results;
        new_index = evt.target.new_index;
        val = $(evt.target).val();
        if (this.selected[new_index] !== val) {
            this.selected[new_index] = val;
            _ref = this.fields;
            _results = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                field = _ref[_i];
                _results.push(this.rebuild_field_values(field));
            }
            return _results;
        }
    };

    /**
     * Rebuild field values
     * @param field
     * @returns {*|jQuery}
     */
    SelectSync.prototype.rebuild_field_values = function (field) {
        var index, option, val, _i, _len, _ref;
        if (field.length) {
            index = field[0].new_index;
            _ref = $(field).find("option");
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                option = _ref[_i];
                val = option.value;
                if (val) {
                    option.disabled = $.inArray(val, this.selected) >= 0 && val !== this.selected[index];
                }
            }
        }
        return $(field);
    };
    return SelectSync;
})();