/**
 * Created by WebSomonair on 12.12.2014.
 */


function Morris_Graph(type, data_input, labels, xkey, ykeys, name, div, legend, units, min_y, max_y){
    var chart;
    switch (type) {
        case 'Line' :
            chart = Morris.Line({
                element: div,
                data: data_input,
                smooth: true,
                lineColors: ['#20ab46', '#0aabe3', '#f4752b'],
                hideHover: 'false',
                xkey: xkey,
                xLabelFormat: function (x) {
                    return moment(x).format('MMM DD').toString();
                },
                xLabelAngle: 45,
                dateFormat: function (x) {
                    return moment(x).format('MMM DD, YYYY').toString();
                },
                ykeys: ykeys,
                postUnits: (typeof units !== 'undefined') ? units : '',
                ymin: (typeof min_y !== 'undefined') ? min_y : 'auto',
                ymax: (typeof min_y !== 'undefined') ? max_y : 'auto',
                goalStrokeWidth: '1px',
                labels: labels
            });
        break;

        case 'Bar' :
             chart = Morris.Bar({
                element: div,
                data: data_input,
                smooth: true,
                barColors: ['#20ab46', '#0aabe3', '#f4752b'],
                hideHover: 'false',
                xkey: xkey,
                xLabelAngle: 45,
                ykeys: ykeys,
                postUnits: (typeof units !== 'undefined') ? units : '',
                ymin: (typeof min_y !== 'undefined') ? min_y : 'auto',
                ymax: (typeof min_y !== 'undefined') ? max_y : 'auto',
                goalStrokeWidth: '1px',
                labels: labels
            });
        break;

        case 'Area' :
             chart = Morris.Area({
                element: div,
                data: data_input,
                smooth: true,
                lineColors: ['#20ab46', '#0aabe3', '#f4752b'],
                ylineColors: ['#00bf03', '#0088f4', '#FF6F4D'],
                hideHover: 'false',
                xkey: xkey,
                xLabelFormat: function (x) {
                    return moment(x).format('MMM DD').toString();
                },
                xLabelAngle: 45,
                dateFormat: function (x) {
                    return moment(x).format('MMM DD, YYYY').toString();
                },
                ykeys: ykeys,
                postUnits: (typeof units !== 'undefined') ? units : '',
                ymin: (typeof min_y !== 'undefined') ? min_y : 'auto',
                ymax: (typeof min_y !== 'undefined') ? max_y : 'auto',
                goalStrokeWidth: '1px',
                labels: labels
            });
        break;
    }

    $(legend).append('<h3 class="graph_label">'+name+'</h3>');

    chart.options.labels.forEach(function(label, i){
        if (type == 'Bar')
            var legendItem = $('<span></span>').text(label).css('color', chart.options.barColors[i])
        else
            var legendItem = $('<span></span>').text(label).css('color', chart.options.lineColors[i])
        $(legend).append(legendItem)
    })
}
