/**
 * Created by dimmer on 24.08.2015.
 */

var messenger_tab = $('#messenger_tab'),
    messenger_users = $('#messenger_users'),
    messenger_chat = $('#messenger_chat'),
    messenger_chat_top = $('#messenger_chat_top'),
    messenger_chat_tab = $('#messenger_chat_tab'),
    messenger_chat_content = $('#messenger_chat_content'),
    messenger_chat_area = $('#messenger_chat_area'),
    messenger_users_online = $('#messenger_users_online'),
    messenger_status = $('#messenger_status'),
    btn_user_status = $('#btn_user_status'),
    btn_user_status_icon = $('#btn_user_status_icon'),
    messenger_config = $('#messenger_config'),
    messenger_list_users = $('#messenger_list_users'),
    btn_show_users = $('#btn_show_users'),
    send_message = $('#send_message'),
    search_users = $('#search_users'),
    btn_send_message = $('#btn_send_message'),
    instance = false,
    state = 0,
    maxLength = 1024,
    keyMin = 1,
    keyMax = 2,
    REFRESH_1SEC = 1000,
    REFRESH_2SEC = 2000,
    REFRESH_3SEC = 3 * 1000,
    REFRESH_10SEC = 10 * 1000,
    REFRESH_1MIN = 60 * 1000,
    REFRESH_10MIN = 10 * 60 * 1000,
    REFRESH_1HR = 60 * 60 * 1000,
    REFRESH_24HRS = 24 * 60 * 60 * 1000,
    STATUS_ONLINE = 'Online',
    STATUS_AWAY = 'Away',
    STATUS_DONT_DISTURB = 'Do Not Disturb',
    STATUS_INVISIBLE = 'Invisible',
    STATUS_OFFLINE = 'Offline',
    STATUS_ALL = 'All',
    GROUP_BY_DEPARTMENT = 'Group By Department',
    GROUP_BY_USERS = 'Group By Users',
    SHOW_PICTURES = 'Show Profile Picture',
    HIDE_PICTURES = 'Hide Profile Picture',
    info_box = $('<div class="alert alert-info"></div>');


function Chat() {

    this.refreshActiveMessageInterval = REFRESH_3SEC;
    this.refreshPassiveMessageInterval = REFRESH_10SEC;
    this.refreshOnlineUsersInterval = REFRESH_1MIN;

    this.ajaxLoadingPassiveMessages = false;
    this.ajaxLoadingNewMessages = false;
    this.ajaxLoadingUsers = false;


    this.lastUpdateDate = false;
    this.lastMessageDate = false;
    this.lastMessageId = false;
    this.firstMessageDate = false;
    this.firstMessageId = false;
    this.userId = false;
    this.userName = false;
    this.userActiveStatus = false;
    this.activeUserMinimized = false;
    this.activeUserClosed = false;
    this.messengerMinimized = true;
    this.authUserId = authUserId;
    this.authUserName = authUserName;
    this.activeStatus = authUserStatus;
    this.prepareMessageItem = prepareMessageItem;
    this.groupUsersList = GROUP_BY_DEPARTMENT;
    this.loadPictures = true;
    this.lastLoadedUsersList = [];

    this.send = sendChat;
    this.loadUsers = loadUsers;
    this.groupUsers = groupUsers;
    this.checkIfUserIsOffline = checkIfUserIsOffline;
    this.changeStatus = changeStatus;
    this.handleStatusChange = handleStatusChange;
    this.searchAndLoadUsers = searchAndLoadUsers;

    this.decodedMessage = decodeMessages;
    this.checkAndLoadMessages = checkAndLoadMessages;
    this.loadMessages = loadMessages;
    this.loadNewMessages = loadNewMessages;
    this.loadPassiveNewMessages = loadPassiveNewMessages;
    this.loadPreviousMessages = loadPreviousMessages;

    this.checkForMessageRefreshMode = checkForMessageRefreshMode;
    this.checkForNewMessages = checkForNewMessages;
    this.checkForPassiveNewMessages = checkForPassiveNewMessages;
    this.unsetActiveMessageDialog = unsetActiveMessageDialog;
    this.setUser = setUser;
    this.setChatTabContent = setChatTabContent;
    this.EncryptMessage = Encrypt;
    this.DecryptMessage = Decrypt;
    this.fetchMessages = fetchMessages;
    this.fetchOnlineUsers = fetchOnlineUsers;
    this.fetchNewMessagesCounter = fetchNewMessagesCounter;
    this.updateChat = updateChat;
}


// kick off chat
if (authUserId && authUserId != ""){
    var chat = new Chat();
}

$(function () {


    $('[data-toggle="tooltip"]').tooltip();

    // watch textarea for key presses
    send_message.keydown(function (event) {

        var key = event.which;

        //all keys including return.
        if (key >= 33) {
            var length = this.value.length;
            // don't allow new content if length is maxed out
            if (length >= maxLength) {
                event.preventDefault();
            }
        }
    });

    // watch textarea for release of key press
    send_message.keyup(function (e) {
        if (e.keyCode == 13) {
            // send
            handleSendMessage();
        }
    });

    search_users.keyup(function (e) {
        var _this = $(this), search = _this.val();

        if (chat.activeStatus != STATUS_OFFLINE) {
            if (e.keyCode == 13 || search.length > 0) {
                // search
                chat.searchAndLoadUsers(search);
            }

            if (search.length == 0) {
                chat.loadUsers();
            }
        }
    });

    messenger_chat_area.scroll(function () {
        //console.log(chat)
        if ($(this).scrollTop() <= 0) {
            if (chat.lastMessageDate && chat.lastMessageId)
                chat.loadPreviousMessages(PREPEND);
        }
    });

    btn_send_message.click(function () {
        handleSendMessage();
    });

    $(document).click(function(e) {
        if (typeof chat !== "undefined"){
            if($(e.target).is('#messenger *, #messenger_chat *')){
                e.preventDefault();
                return;
            }

            messengerUsersHide();
            messengerChatHide();
        }
    });

});


function handleSendMessage(){
    var message = send_message.val(), length = message.length;

    if (length <= maxLength + 1) {
        chat.send(message);
        console.log(length);
        send_message.val("");
    } else {
        send_message.val(message.substring(0, maxLength));
    }
    send_message.focus();
}

function messengerUsersHide(){
    messenger_users.slideUp("slow");
    chat.refreshPassiveMessageInterval = REFRESH_1MIN;
    chat.refreshOnlineUsersInterval = REFRESH_10MIN;
    chat.messengerMinimized = true;
}

function messengerChatHide(){
    messenger_chat_content.slideUp("slow");
    chat.activeUserMinimized = true;
}

messenger_status.on('click', 'li > a', function () {
    var _this = $(this), status = _this.text(), iconClass = _this.find('i').attr('class'), icon = btn_user_status_icon.find('span.status-icon');
    // Modify Current Status
    btn_user_status.text(status);
    // Modify Current Btn Class
    btn_user_status.attr('class', getUserChatStatusBtnClass(status));
    // Modify Messenger Tab Class
    messenger_tab.attr('class', getUserChatStatusTabClass(status));
    // Remove Prev Class
    icon.attr('class', iconClass + " status-icon");
    // Add Current Class
    icon.addClass(iconClass);

    messenger_tab.find('span.status-icon').attr('class', iconClass + " status-icon");


    chat.changeStatus(status);

});


function getUserChatStatusBtnClass($chatStatus){
    var $class;
    switch ($chatStatus){
        case STATUS_AWAY:
            $class = "btn btn-warning";
            break;
        case STATUS_DONT_DISTURB:
            $class = "btn btn-danger";
            break;
        case STATUS_INVISIBLE:
            $class = "btn btn-primary";
            break;
        case STATUS_OFFLINE:
            $class = "btn btn-danger";
            break;
        default:
        case STATUS_ONLINE:
            $class = "btn btn-success";
            break;
    }
    return $class;
}


function getUserChatStatusTabClass($chatStatus){
    var $class;
    switch ($chatStatus){
        case STATUS_AWAY:
            $class = "chat-btn-away";
            break;
        case STATUS_DONT_DISTURB:
            $class = "chat-btn-do_not_disturb";
            break;
        case STATUS_INVISIBLE:
            $class = "chat-btn-invisible";
            break;
        case STATUS_OFFLINE:
            $class = "chat-btn-offline";
            break;
        default:
        case STATUS_ONLINE:
            $class = "chat-btn-online";
            break;
    }
    return $class;
}

function getUserChatStatusIconClass($chatStatus){
    var $class;
    switch ($chatStatus){
        case STATUS_AWAY:
            $class = "glyphicon glyphicon-ban-circle chat-users-icon chat-users-away";
            break;
        case STATUS_DONT_DISTURB:
            $class = "glyphicon glyphicon-minus-sign chat-users-icon chat-users-do_not_disturb";
            break;
        case STATUS_INVISIBLE:
            $class = "glyphicon glyphicon-eye-open chat-users-icon chat-users-invisible";
            break;
        case STATUS_OFFLINE:
            $class = "glyphicon glyphicon-remove-circle chat-users-icon chat-users-offline";
            break;
        default:
        case STATUS_ONLINE:
            $class = "glyphicon glyphicon-ok-circle chat-users-icon chat-users-online";
            break;
    }
    return $class;
}

messenger_list_users.on('click', 'li > a', function () {
    var _this = $(this), allOptions = _this.parents('ul').children(), status = _this.attr('data-status');
    allOptions.removeClass('active');
    // Modify Current Status
    _this.parent().addClass('active');
    // Load Users WIth Current Status
    chat.loadUsers(status);

});

messenger_config.on('click', '#config_group_by_department', function () {
    var _this = $(this), option = _this.find('p'), parent_li = _this.parent(), status = _this.attr('data-status');

    if (chat.groupUsersList == GROUP_BY_DEPARTMENT){
        chat.groupUsersList = GROUP_BY_USERS;
        option.text(GROUP_BY_DEPARTMENT)
    }
    else {
        chat.groupUsersList = GROUP_BY_DEPARTMENT;
        option.text(GROUP_BY_USERS)
    }
    // Load Users, Group/NOT By Department
    chat.groupUsers();

});

messenger_config.on('click', '#config_load_pictures', function () {
    var _this = $(this), option = _this.find('p'), parent_li = _this.parent(), status = _this.attr('data-status');

    if (chat.loadPictures){
        option.text(SHOW_PICTURES)
    }
    else {
        option.text(HIDE_PICTURES)
    }

    chat.loadPictures = !chat.loadPictures;

    chat.fetchOnlineUsers(chat.lastLoadedUsersList);
});



$(document).on('click', '#messenger_tab', function () {
    if (messenger_users.is(":visible")) {
        messengerUsersHide();
    }
    else {
        messenger_users.slideDown("slow");
        // Check For New Messages
        chat.refreshPassiveMessageInterval = REFRESH_10SEC;
        //
        chat.refreshOnlineUsersInterval = REFRESH_1MIN;

        chat.updateChat();

        chat.messengerMinimized = false;

        // Mark As Seen
        messenger_tab.removeClass('animated-selected');
        messenger_tab.find('span.badge').text("");
    }
});

$(document).on('click', '#messenger_users_top', function () {
    messenger_users.slideUp("slow");
    chat.refreshPassiveMessageInterval = REFRESH_1MIN;
    chat.refreshOnlineUsersInterval = REFRESH_10MIN;
});

$(document).on('click', '#messenger_users_top .glyphicon-minus', function () {
    messenger_users.slideUp("slow");
    chat.refreshPassiveMessageInterval = REFRESH_1MIN;
    chat.refreshOnlineUsersInterval = REFRESH_10MIN;
});


$(document).on('click', '#messenger_chat_tab', function () {
    if (messenger_chat_content.is(":visible")) {
        messengerChatHide();
    }
    else {
        messenger_chat_content.slideDown("slow");
        messengerChatScrollUp();
        chat.activeUserMinimized = false;
        chat.activeUserClosed = false;
        highlightMessengerChatTab(true);
        send_message.focus();

        if (chat.userId && chat.userActiveStatus != STATUS_OFFLINE){
            chat.refreshActiveMessageInterval = REFRESH_3SEC;
        }
    }
});

$(document).on('click', '#messenger_chat_top .glyphicon-minus', function () {
    messenger_chat_content.slideUp("slow");
    chat.activeUserMinimized = true;

});

$(document).on('click', '#messenger_chat_top', function () {
    messenger_chat_content.slideUp("slow");
    chat.activeUserMinimized = true;
});


$(document).on('click', '#messenger_chat_top .glyphicon-remove, #messenger_chat_tab .glyphicon-remove', function () {
    messenger_chat.slideUp("slow");
    chat.activeUserClosed = true;
});



$(document).on('click', 'div.chat-users-list', function () {
    var _this = $(this), userId = _this.attr('data-user_id'), userStatus = _this.attr('data-user_status'), userName = _this.find('a.chat-users-list').text();

    messenger_users_online.find(" > .selected").removeClass('selected');

    _this.addClass('selected');

    if (messenger_chat.is(":visible")) {
        messenger_chat_content.show();
    }
    else {
        messenger_chat.show();
        messenger_chat_content.show();
    }
    highlightMessengerChatTab(true);

    chat.setUser(userId, userName, userStatus);

    chat.setChatTabContent();

    chat.activeUserMinimized = false;
    chat.activeUserClosed = false;

    messengerChatScrollUp();

    chat.checkAndLoadMessages();

    send_message.focus();

    chat.refreshActiveMessageInterval = REFRESH_3SEC;
});



function updateChat(){
    if (chat.activeStatus == STATUS_OFFLINE){
        handleStatusChange();
    }
    else {
        // Default Value For Refreshing Messages
        setTimeout(chat.checkForNewMessages, REFRESH_1SEC);
        setTimeout(chat.checkForPassiveNewMessages, REFRESH_1SEC);
        setTimeout(chat.loadUsers, REFRESH_1SEC);
    }
}

function checkForPassiveNewMessages(){
    chat.loadPassiveNewMessages(APPEND);
    // Set Timeout For The Next Call
    setTimeout( chat.checkForPassiveNewMessages, chat.refreshPassiveMessageInterval );
}

function checkForNewMessages(){
    if (chat.userActiveStatus == STATUS_OFFLINE){
        chat.refreshActiveMessageInterval = REFRESH_10MIN;
        chat.refreshPassiveMessageInterval = REFRESH_10MIN;
        chat.refreshOnlineUsersInterval = REFRESH_10MIN;
        setTimeout( chat.checkForNewMessages, chat.refreshActiveMessageInterval );
    }
    else {
        if (chat.userId){
            if(chat.activeUserMinimized || chat.activeUserClosed) {
                chat.refreshActiveMessageInterval = REFRESH_24HRS;
                chat.refreshPassiveMessageInterval = REFRESH_24HRS;
            }
            // Update Active User Dialog Window
            chat.loadNewMessages(chat.userId, APPEND, chat.firstMessageDate, chat.firstMessageId);
            // Set Timeout For The Next Call
            setTimeout(chat.checkForNewMessages, chat.refreshActiveMessageInterval);
        }
        else {
            setTimeout(chat.checkForNewMessages, chat.refreshActiveMessageInterval);
        }
    }
}

function unsetActiveMessageDialog(){
    this.lastUpdateDate = false;
    this.lastMessageDate = false;
    this.lastMessageId = false;
    this.firstMessageDate = false;
    this.firstMessageId = false;
    this.userId = false;
}

function setUser(userId, userName, userStatus){
    this.userId = userId;
    this.userName = userName;
    this.userActiveStatus = userStatus;
}

function setChatTabContent(){
    var icon = messenger_chat_tab.find('span.status-icon'),
        userName = messenger_chat_tab.find('p'),
        iconClass = getUserChatStatusIconClass(this.userActiveStatus);

    if (!userName.length){
        userName = $("<p></p>");
        messenger_chat_tab.append(userName);
    }
    userName.text(this.userName);

    messenger_chat_tab.attr('class', getUserChatStatusTabClass(this.userActiveStatus));
    if (!icon.length){
        icon = $('<span style="float: left; color: #ffffff;"></span>');
        messenger_chat_tab.prepend(icon);
    }
    // Remove Prev Class
    icon.attr('class', iconClass + " status-icon");

}

function checkAndLoadMessages(){
    var selector = "#message-container-user-" + this.userId, firstChild,
        element = messenger_chat_area.find(selector);

    messenger_chat_content.slideDown("slow");

    messenger_chat_area.find('.message-user-container').not($(selector)).hide();
    if (element.length){
        element.show();
        firstChild = element.find('.last-message').first();
        if (firstChild) {
            this.lastMessageDate = firstChild.attr('data-last_date') + ' ' + firstChild.attr('data-last_time');
            this.lastMessageId = firstChild.attr('data-last_id');
        }
        messengerChatScrollUp();

        // Change Counter To Read
        modifyNewMessageCounter(this.userId, 0);

        if (!element.children().length){
            information_box.show();
        }
        else {
            information_box.hide();
        }
    }
    else {
        this.loadMessages();
    }
}

function prepareMessageItem(message, sent){
    return  '<div class="message-list">' +
                      '<div class="message-list-header">' +
                          '<p class="header-text auth-header-text" style="float:left;">'+ chat.authUserName +'</p>'+
                          '<p class="header-text auth-header-time" style="float:right;">'+ sent +'</p>'+
                       '</div>'+
                        '<p class="auth-user-message">'+ message + '</p>'+
                  '</div>';
}


function fetchOnlineUsers(usersByDepartment){
    var list = "", iconClass, hide = '', picture;
    if (chat.activeStatus != STATUS_OFFLINE) {
        if (chat.groupUsersList == GROUP_BY_USERS) {
            hide = ' style="display:none" ';
        }
        console.log(usersByDepartment)

        $.each(usersByDepartment, function (deparment, usersList) {
            // Department Title
            list += "<div class='chat-departments-title' " + hide + "><a>" + deparment + "</a></div>";
            // Users List
            $.each(usersList, function (i, user) {
                if (chat.loadPictures) {
                    picture = user.thumb && user.thumb != "" ? baseUrl + '/storage/users//' + user.thumb : baseUrl + '/assets/img/default-user-picture-sm.png';
                }
                if (user.logged) {
                    iconClass = getUserChatStatusIconClass(user.status);
                    list += "<div class='chat-users-list' data-online = 1 data-user_status = '" + user.status + "' data-user_id ='" + user.id + "'>";

                    if (chat.loadPictures){
                        list += '<img style="float:left;" src="' + picture + '" class="user-picture"  />';
                    }

                    list += "<i data-toggle='tooltip' data-placement='left' title='" + user.status + "' class='" + iconClass + "'></i>" +
                        "<a class='chat-users-list'>" + user.full_name + "</a>";

                    if (user.counter && user.counter != '' && user.counter != 0){
                        list += '<span class="badge users-new-messages">'+ user.counter +'</span>';
                    }

                    list += "</div>";
                }
                else {
                    list += "<div class='chat-users-list' data-online = 0 data-user_status = '" + user.status + "' data-user_id ='" + user.id + "'>";

                    if (chat.loadPictures){
                        list += '<img style="float:left;" src="' + picture + '" class="user-picture"  />';
                    }

                    list += "<i class='glyphicon glyphicon-remove-circle chat-users-icon chat-users-offline'></i>" +
                        "<a class='chat-users-list'>" + user.full_name + "</a>";

                    if (user.counter && user.counter != '' && user.counter != 0){
                        list += '<span class="badge users-new-messages">'+ user.counter +'</span>';
                    }

                    list += "</div>";
                }
            });
        });
        messenger_users_online.html(list);
        // Make All Picture Width = 23px
        //var pictures = messenger_users_online.find('img.user-picture'), width;
        //pictures.each(function () {
        //    var _this = $(this), width = _this.width(), leftOver;
        //    if (width < 23){
        //        leftOver = 23 - width;
        //        _this.css('padding-right', leftOver + 'px');
        //    }
        //    else {
        //        _this.css('width', '23px');
        //    }
        //})

    }
}

function fetchMessages(messages, type){
    var container, alertInfo, decodedMessage;
    messenger_chat_area.find("span.ajax-loading").hide();

    // Default Type INSERT
    if (typeof type === 'undefined')
        type = INSERT;

    switch (type){
        case PREPEND:
            var count = $(messages).nextAll('.message-list').length + 1;
            container = messenger_chat_area.find("#message-container-user-" + chat.userId);
            if (!container.length){
                container = $("<div></div>").attr('id', "message-container-user-" + chat.userId).addClass('message-user-container');
            }
            if (messages && messages != '') {
                container.prepend(chat.decodedMessage(messages));
                messenger_chat_area.scrollTop(count * 60);
            }
            break;
        case APPEND:
            container = messenger_chat_area.find("#message-container-user-" + chat.userId);
            if (!container.length){
                container = $("<div></div>").attr('id', "message-container-user-" + chat.userId).addClass('message-user-container');
            }
            if (messages && messages != '') {
                container.append(chat.decodedMessage(messages));
                messengerChatScrollUp();
            }
            break;
        case INSERT:
        default :
            container = $("<div></div>").attr('id', "message-container-user-" + chat.userId).addClass('message-user-container');
            if (!messages || messages == ''){
                messenger_chat_area.append(information_box.text('No Messages Found'));
                information_box.show();
            }
            else {
                information_box.hide();
            }
            container.html(chat.decodedMessage(messages));

            messenger_chat_area.append(container);
            messengerChatScrollUp();
            break;
    }
}

function messengerChatScrollUp(){
    messenger_chat_area.scrollTop(messenger_chat_area.prop("scrollHeight"));
}

function decodeMessages(messages){
    var newMessage = $(messages);
    newMessage.each(function(){
        var _this = $(this), messageContainer, key;
        if (_this.hasClass('message-list')) {
            messageContainer = $(this).find('p.message-text');
            key = messageContainer.attr('data-key');
            messageContainer.text(chat.DecryptMessage($.trim(messageContainer.text()), parseInt(key)));
        }
    });

    return newMessage;
}



function highlightMessengerChatTab(unhightlight){
    if (typeof unhightlight !== 'undefined'){
        messenger_chat_tab.removeClass('animated-selected');
    }
    else {
        messenger_chat_tab.addClass('animated-selected');
    }
}

function fetchNewMessagesCounter(messages){
    var userElement, newMessagesCount = $('<span class="badge users-new-messages"></span>'), counter, totalCounter = 0, newCounter;
    $.each(messages, function (i, each) {
        userElement = messenger_users_online.find('div.chat-users-list[data-user_id=' + each.from_user_id + ']');
        if (userElement.length){
            counter = userElement.find('span.badge');
            newCounter = parseInt(each.counter);
            if (counter.length){
                counter.text(newCounter);
            }
            else {
                userElement.append(newMessagesCount.clone().text(newCounter));
            }
            if (chat.userId && chat.activeUserMinimized){
                highlightMessengerChatTab();
            }
            totalCounter += newCounter;
        }
    });

    if (chat.messengerMinimized && totalCounter > 0){
        messenger_tab.addClass('animated-selected');
        var messengerTabBadge = messenger_tab.find('span.badge');
        if (messengerTabBadge.length){
            messengerTabBadge.text(totalCounter);
        }
        else {
            messenger_tab.append($('<span class="badge users-new-messages"></span>').text(totalCounter));
        }
    }
    /* var newMessagesCount = $('<span class="badge users-new-messages">4</span>'),
     users = messenger_users_online.find('div.chat-users-list');
     if (!users.find('.badge').length) {
     users.append(newMessagesCount);
     }*/
}

function modifyNewMessageCounter(userId, counter) {
    var userElement, counterBadge, newMessagesCount = $('<span class="badge users-new-messages"></span>');
    if (typeof counter === 'undefined' || counter == 0)
        counter = '';
    userElement = messenger_users_online.find('div.chat-users-list[data-user_id=' + userId + ']');
    if (userElement.length) {
        counterBadge = userElement.find('span.badge');
        if (counterBadge.length) {
            counterBadge.text(counter);
        }
        else {
            userElement.append(newMessagesCount.clone().text(counter));
        }
    }
}

function loadPassiveNewMessages(type) {
    if (!chat.ajaxLoadingPassiveMessages) {
        chat.ajaxLoadingPassiveMessages = true;
        var request = $.ajax({
                headers: {
                    'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
                },
                type: "POST",
                url: baseUrl + "/messenger/load-passive-new-messages",
                data: {
                    lastUpdateDate: this.lastUpdateDate
                },
            }
        );

        request.success(function (data) {
            chat.lastUpdateDate = data.lastUpdateDate;
            chat.fetchNewMessagesCounter(data.messages);
        });

        request.always(function () {
            chat.ajaxLoadingPassiveMessages = false;
        });
    }
}

function loadNewMessages(userId, type, firstMessageDate, firstMessageId){
    if (!chat.ajaxLoadingNewMessages) {
        chat.ajaxLoadingNewMessages = true;
        var request = $.ajax({
                headers: {
                    'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
                },
                type: "POST",
                url: baseUrl + "/messenger/load-new-messages",
                data: {
                    userId: userId,
                    firstMessageDate: firstMessageDate,
                    firstMessageId: firstMessageId,
                }
            }
        );

        request.success(function (data) {
            var firstMessage = $(data).closest(".first-message");
            if (firstMessage.length && typeof firstMessage.attr('data-first_id') !== 'undefined') {
                //chat.lastMessageDate = lastMessage.attr('data-last_date') + ' ' + lastMessage.attr('data-last_time');
                //chat.lastMessageId = lastMessage.attr('data-last_id');
                chat.firstMessageDate = firstMessage.attr('data-first_date') + ' ' + firstMessage.attr('data-first_time');
                chat.firstMessageId = firstMessage.attr('data-first_id');
                chat.userActiveStatus = firstMessage.attr('data-user_active_status');
                // Fetch Message Content
                chat.fetchMessages(data, type);
            }
            // Nullify New Message Counter IF Exists
            if (!chat.activeUserMinimized && !chat.activeUserClosed) {
                modifyNewMessageCounter(userId, 0);
            }
            chat.checkForMessageRefreshMode(data);

            // Check If User if OFFLINE
            chat.checkIfUserIsOffline(data);
        });

        request.always(function () {
            chat.ajaxLoadingNewMessages = false;
        });
    }
}

function checkForMessageRefreshMode(data){
    /*if (typeof data.increaseRefreshTime !== 'undefined'){
        switch (this.refreshActiveMessageInterval){
            case REFRESH_3SEC:
                this.refreshActiveMessageInterval = REFRESH_10SEC;
                break;
            case REFRESH_10SEC:
                this.refreshActiveMessageInterval = REFRESH_10SEC * 2;
                break;
            case REFRESH_10SEC * 2:
                this.refreshActiveMessageInterval = REFRESH_10SEC * 3;
                break;
            case REFRESH_10SEC * 3:
                this.refreshActiveMessageInterval = REFRESH_10SEC * 4;
                break;
            case REFRESH_10SEC * 4:
                this.refreshActiveMessageInterval = REFRESH_10SEC * 5;
                break;
            case REFRESH_10SEC * 5:
                this.refreshActiveMessageInterval = REFRESH_1MIN;
                break;
        }
    }
    else {
        this.refreshActiveMessageInterval = REFRESH_3SEC;
    }*/
    this.refreshActiveMessageInterval = REFRESH_3SEC;
}


function checkIfUserIsOffline(data) {
    if (typeof data.userActiveStatus !== 'undefined'){
        chat.userActiveStatus = data.userActiveStatus;

        var container = messenger_chat_area.find("#message-container-user-" + chat.userId);
        if (!container.length){
            container = $("<div></div>").attr('id', "message-container-user-" + chat.userId).addClass('message-user-container');
        }
        container.attr('data-user_status', data.userActiveStatus);
    }
}


function loadMessages(type){
    var loading = messenger_chat_area.find("span.ajax-loading");
    if (!loading.length) {
        messenger_chat_area.append(ajax_loading);
    }
    ajax_loading.show();

    if (this.userId){ // && !instance) {
        instance = true;
        var request = $.ajax({
                headers: {
                    'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
                },
                type: "POST",
                url: baseUrl + "/messenger/load-messages",
                data: {
                    userId: this.userId
                }
            }
        );

        request.success(function (data) {
            var lastMessage =$(data).closest(".last-message"), firstMessage =$(data).closest(".first-message");
            if ((firstMessage.length && typeof firstMessage.attr('data-first_id') !== 'undefined') ||
                (lastMessage.length && typeof lastMessage.attr('data-last_id') !== 'undefined')) {
                chat.lastMessageDate = lastMessage.attr('data-last_date') + ' ' + lastMessage.attr('data-last_time');
                chat.lastMessageId = lastMessage.attr('data-last_id');

                chat.firstMessageDate = firstMessage.attr('data-first_date') + ' ' + firstMessage.attr('data-first_time');
                chat.firstMessageId = firstMessage.attr('data-first_id');
                // Fetch Messages
            }
            chat.fetchMessages(data, type);
            // Nullify New Message Counter IF Exists
            modifyNewMessageCounter(chat.userId, 0);
        });

        request.always(function () {
            ajax_loading.hide();
            instance = false;
        });
    }
}


function loadPreviousMessages(type) {
    if (this.userId){ // && !instance) {
        instance = true;
        var request = $.ajax({
                headers: {
                    'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
                },
                type: "POST",
                url: baseUrl + "/messenger/load-previous-messages",
                data: {
                    userId: this.userId,
                    lastMessageDate: this.lastMessageDate,
                    lastMessageId: this.lastMessageId
                },
            }
        );

        request.success(function (data) {
            var lastMessage = $(data).closest(".last-message");
            chat.lastMessageDate = lastMessage.attr('data-last_date') + ' ' + lastMessage.attr('data-last_time');
            chat.lastMessageId = lastMessage.attr('data-last_id');
            chat.fetchMessages(data, type);
        });

        request.always(function () {
            instance = false;
        });
    }
}

//gets the state of the chat
function loadUsers(status) {
    if (typeof status === 'undefined'){
        status = STATUS_ONLINE;
    }
    if (!chat.ajaxLoadingUsers) {
        chat.ajaxLoadingUsers = true;

        var request = $.ajax({
            headers: {
                'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
            },
            type: "POST",
            url: baseUrl + "/messenger/load-users",
            data: {
                status: status
            },
            dataType: "json"
        });

        request.success(function (data) {
            chat.lastLoadedUsersList = data.usersByDepartment;
            chat.fetchOnlineUsers(data.usersByDepartment);
        });

        request.always(function () {
            chat.ajaxLoadingUsers = false;
        });

        setTimeout(chat.loadUsers, chat.refreshOnlineUsersInterval);
    }
}

//gets the state of the chat
function groupUsers() {
    if (chat.groupUsersList == GROUP_BY_DEPARTMENT){
        messenger_users_online.children().filter('.chat-departments-title').show();
    }
    else {
        messenger_users_online.children().filter('.chat-departments-title').hide();
    }
}


//gets the state of the chat
function searchAndLoadUsers(search) {
    if (typeof search === 'undefined'){
        search = 0;
    }
    //if (!instance) {
    instance = true;
    var request = $.ajax({
        headers: {
            'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
        },
        type: "POST",
        url: baseUrl + "/messenger/search-and-load-users",
        data: {
            search: search,
        },
        dataType: "json",
    });

    request.success(function (data) {
        chat.fetchOnlineUsers(data.usersByDepartment);
    });

    request.always(function () {
        instance = false;
    });
    //}
}
//gets the state of the chat
function changeStatus(status) {
    if (typeof status === 'undefined'){
        status = STATUS_ONLINE;
    }
    //if (!instance) {
    instance = true;
    var request = $.ajax({
        headers: {
            'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
        },
        type: "POST",
        url: baseUrl + "/messenger/change-status",
        data: {
            status: status
        },
        dataType: "json",
    });

    request.success(function (data) {
        // Change Status
        chat.activeStatus = status;
        //
        chat.handleStatusChange();
    });

    request.always(function () {
        instance = false;
    });
    //}
}

function handleStatusChange(){
    switch (chat.activeStatus){
        case STATUS_OFFLINE:
            var notification = info_box.clone().addClass('messenger-info-box').text('Chat Is Off. Change Your Status To Other Than Offline To Turn On Chat.');
            messenger_chat.hide();
            messenger_users_online.html(notification);
            chat.refreshActiveMessageInterval = REFRESH_24HRS;
            chat.refreshPassiveMessageInterval = REFRESH_24HRS;
            chat.refreshOnlineUsersInterval = REFRESH_24HRS;
            break;
        default :
            chat.refreshActiveMessageInterval = REFRESH_3SEC;
            chat.refreshPassiveMessageInterval = REFRESH_10SEC;
            chat.refreshOnlineUsersInterval = REFRESH_1MIN;
            chat.updateChat();
            break;
    }
}


//send the message
function sendChat(message) {
    instance = true;
    var key = generateRandomInt(keyMin, keyMax);
    var request = $.ajax({
            headers: {
                'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
            },
            type: "POST",
            url: baseUrl + "/messenger/send-message",
            data: {
                userId: chat.userId,
                message: this.EncryptMessage(message, key),
                key: key
            },

            dataType: "json",
        }
    );

    request.success(function (data) {
        instance = false;
    });

    chat.checkForNewMessages();
    //chat.loadNewMessages(chat.userId, APPEND, chat.firstMessageDate, chat.firstMessageId);
}

function generateRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

function Encrypt(PlainText, Key) {
    var to_enc = PlainText.toString().replace(/^\n+/, "").replace
    (/\n+$/, "");  //Nozel: remove \n

    var xor_key=Key;
    var the_res="";//the result will be here
    for(i=0;i<to_enc.length;++i)
    {
        ////the_res += String.fromCharCode((xor_key ^ to_enc.charCodeAt(i)));
        //Nozel:  Xor Cipher .
        //But encoded characters are not always allowed in http headers

        if (to_enc.charCodeAt(i) <= 32) {
            //Keep c as it is
            the_res += String.fromCharCode((to_enc.charCodeAt(i))); //Nozel: Bypass
            //Invalid characters which are not supported in Http headers
        }
        else {
            the_res += String.fromCharCode
            ((to_enc.charCodeAt(i)) - Key); //Nozel: Normal substitution Cipher
        }
    }
    return(the_res);
}

function Decrypt(CipherText, Key) {
    var to_dec = CipherText;
    var xor_key = Key;
    var PlainText = "";
    for (i = 0; i < to_dec.length; i++) {

        ///// PlainText += String.fromCharCode((xor_key ^ to_dec.charCodeAt(i)));
        //Nozel:  Xor Cipher . But encoded characters are not always allowed in HTTP headers

        if (to_dec.charCodeAt(i) <= 32) {
            //Keep c as it is
            PlainText += String.fromCharCode((to_dec.charCodeAt(i)));
            //Nozel:   Bypass Invalid characters which are not supported in HTTP headers
        }
        else {
            PlainText += String.fromCharCode
            ((to_dec.charCodeAt(i)) + Key);  //Nozel:   Normal substitution Cipher
        }
    }
    return (PlainText);
}
