
var
    ALERT_CLOSE_DELAY = 5000,
    AUTO_CLOSING_SUCCESS_ALERTS = false,
    MESSAGE_SUCCESS = "success",
    MESSAGE_DANGER = "danger",
    MESSAGE_ERROR = "error",
    MESSAGE_WARNING = "warning",
    MESSAGE_INFO = "info",
    CHART_BAR = 'chart_bar',
    CHART_COLUMN = 'chart_column',
    CHART_LINE = 'chart_line',
    CHART_PIE = 'chart_pie',
    CHART_COMBO = 'chart_combo',
    CHART_GEO = 'chart_geo',
    SUBSTITUTE = 'substitute',
    CCM_CREW = "ccm",
    FCM_CREW = "fcm",
    PREPEND = 'prepend',
    APPEND = 'append',
    INSERT = 'insert',
    SEAT_FIRST_CLASS = 'First Class',
    SEAT_BUSINESS_CLASS = 'Business Class',
    SEAT_ECONOMY_PLUS_CLASS = 'Economy Plus Class',
    SEAT_ECONOMY_CLASS = 'Economy Class',
    REPORT_YEARLY = 'yearly',
    REPORT_QUARTERLY = 'quarterly',
    REPORT_MONTHLY = 'monthly',
    AIRCRAFT_B737_900 = "B737-900",
    AIRCRAFT_B737_800 = "B737-800",
    AIRCRAFT_B737_300 = "B737-300",

    dateFrom = $('.dateFrom'),
    dateTo = $('.dateTo'),
    yearFrom = $('.yearFrom'),
    yearTo = $('.yearTo'),
    datepicker = $('.datepicker'),
    dateTimeFrom = $('.dateTimeFrom'),
    dateTimeFormat = $('.date_time_format'),
    dateTimeTo = $('.dateTimeTo'),
    loading_span = $('#loading'),
    error_message = "Error! Something Went Wrong, Please Check Again.",
    SUCCESS_MESSAGE = "Success!",
    // Loading Animation Span
    loading = $('<span class="editableform-loading" style="display: block;"></span>'),
    ajax_loading = $('<span class="ajax-loading" style="display: block; "></span>'),
    ajax_loading_flight_info = $('<span class="ajax-loading-flight-info" style="display: block; "></span>'),
    fill_required_fields = $('<span class="required-info">Please Fill Out Required Information</span>'),
    alert_box = $('<div class="alert"></div>'),
    information_box = $('<div class="alert alert-info"></div>'),
    success_box = $('<div class="alert alert-success" id="success_box"></div>'),
    error_box = $('<div class="alert alert-danger"></div>'),
    modal_ajax_loading = $('.modal-ajax-loading'),
    singleSelectOptions = {
        multiple: false,
        header: "Select an option",
        noneSelectedText: "Select an Option",
        selectedList: 1
    },
    singleSelectOptionsSearch = {
        multiple: false,
        header: "Select an option",
        noneSelectedText: "Select an Option",
        selectedList: 1,
        enableFiltering: true,
        enableCaseInsensitiveFiltering: true
    },
    multiSelectOptions = {
        includeSelectAllOption: true,
        //enableCaseInsensitiveFiltering: true
        //multiple: true,
        //noneSelectedText: "Select Options",
        //selectedList: 4 // 0-based index
    },
    multiSelectOptionsSearch = {
        includeSelectAllOption: true,
        enableFiltering: true,
        enableCaseInsensitiveFiltering: true
        //multiple: true,
        //noneSelectedText: "Select Options",
        //selectedList: 4 // 0-based index
    };

// Structure

var browserRes = calculateHeightAndWidthOfGraph();

Apply_Multiselect();

function Apply_Multiselect(element){
    var selector = $(document);

    if (typeof element !== 'undefined'){
        selector = $(element);
    }

    if (selector.find("select.singleselect").length > 0 )
    {
        selector.find("select.singleselect").multiselect(singleSelectOptions);
    }

    if (selector.find("select.singleselect_search").length > 0 )
    {
        selector.find("select.singleselect_search").multiselect(singleSelectOptionsSearch);//.multiselectfilter();
    }

    if (selector.find("select.multiselect").length > 0 )
    {
        selector.find("select.multiselect").multiselect(multiSelectOptions);
    }

    if (selector.find("select.multiselect_search_all").length > 0 )
    {
        selector.find("select.multiselect_search_all").multiselect(multiSelectOptionsSearch);//.multiselectfilter();
    }

    if (selector.find("select.multiselect_search").length > 0 )
    {
        selector.find("select.multiselect_search").multiselect(multiSelectOptionsSearch);//.multiselectfilter();
    }
}


function unique(list) {
    var result = [];
    $.each(list, function(i, e) {
        if ($.inArray(e, result) == -1) result.push(e);
    });
    return result;
}

String.prototype.toHHMMSS = function () {
    var sec_num = parseInt(this, 10); // don't forget the second param
    var hours   = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);

    if (hours   < 10) {hours   = "0"+hours;}
    if (minutes < 10) {minutes = "0"+minutes;}
    if (seconds < 10) {seconds = "0"+seconds;}
    return hours+':'+minutes+':'+seconds;
}

String.prototype.toDDHHMM = function () {
    var mins = parseInt(this, 10); // don't forget the second param
    var days   = Math.floor(mins / (24 * 60));
    var hours  = Math.floor((mins - (days * 24 * 60)) / 60);
    var minutes = mins - (days * 24 * 60) - (hours * 60);

    if (hours   < 10) {hours   = "0"+hours;}
    if (minutes < 10) {minutes = "0"+minutes;}


    return days > 0 ? (days + "d " + hours + ':' + minutes) : (hours + ':' + minutes);
}

String.prototype.toHHMM = function () {
    var sec_num = parseInt(this, 10); // don't forget the second param
    var hours   = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);

    if (hours   < 10) {hours   = "0"+hours;}
    if (minutes < 10) {minutes = "0"+minutes;}
    if (seconds < 10) {seconds = "0"+seconds;}
    return hours+':'+minutes;
}

function GetCrewPositionAbbr(position){
    var abbr = "";
    switch (position){
        case PILOT_INSTRUCTOR_POSITION:
            abbr = "INSTR";
            break;

        case CAPTAIN_POSITION:
        case FLIGHT_OPERATIONS_DIRECTOR_POSITION:
             abbr = "CAPT";
            break;

        case FIRST_OFFICER_POSITION:
            abbr = "FO";
            break;

        case CHIEF_PILOT_POSITION:
            abbr = "CHF-CAPT";
            break;

        case COPILOT_JUNIOR_POSITION:
            abbr = "FO-JNR";
            break;

        case PURSER_POSITION:
            abbr = "PSR";
            break;

        case FLIGHT_ATTENDANT_POSITION:
            abbr = "FA";
            break;

        case FLIGHT_ATTENDANT_N2_POSITION:
            abbr = "FA-#2";
            break;

        case FLIGHT_ATTENDANT_JUNIOR_POSITION:
            abbr = "FA-JNR";
            break;

        case INSTRUCTOR_FLIGHT_ATTENDANT_POSITION:
            abbr = "INSTR";
            break;

        case SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION:
            abbr = "SEN-INSTR";
            break;
    }

    return abbr;
}

function GetCrewPositionCssClass(position){
    var className = "";
    switch (position){
        case PILOT_INSTRUCTOR_POSITION:
            className = "instructor";
            break;

        case CAPTAIN_POSITION:
            className = "captain";
            break;

        case FIRST_OFFICER_POSITION:
            className = "";
            break;

        case CHIEF_PILOT_POSITION:
            className = "captain";
            break;

        case COPILOT_JUNIOR_POSITION:
            className = "junior";
            break;

        case PURSER_POSITION:
            className = "purser";
            break;

        case FLIGHT_ATTENDANT_POSITION:
            className = "";
            break;

        case FLIGHT_ATTENDANT_N2_POSITION:
            className = "fa_n2";
            break;

        case FLIGHT_ATTENDANT_JUNIOR_POSITION:
            className = "junior";
            break;

        case INSTRUCTOR_FLIGHT_ATTENDANT_POSITION:
            className = "instructor";
            break;

        case SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION:
            className = "instructor";
            break;
    }

    return className;
}


function Initialize_DateRangePicker(){
    $(document).find("#daterangepicker").daterangepicker({
        datepickerOptions: {
            minDate: null,
            maxDate: null
        }
    });

    $(document).find(".daterangepicker-from-now").daterangepicker({
        presetRanges: [{
            text: 'Today',
            dateStart: function() { return moment() },
            dateEnd: function() { return moment() }
        }, {
            text: 'Tomorrow',
            dateStart: function() { return moment().add('days', 1) },
            dateEnd: function() { return moment().add('days', 1) }
        }, {
            text: 'Next 7 Days',
            dateStart: function() { return moment() },
            dateEnd: function() { return moment().add('days', 6) }
        }, {
            text: 'Next Week',
            dateStart: function() { return moment().add('weeks', 1).startOf('week') },
            dateEnd: function() { return moment().add('weeks', 1).endOf('week') }
        }],
        applyOnMenuSelect: false,
        datepickerOptions: {
            minDate: 0,
            maxDate: null
        }
    });

    $(document).find("#daterangepicker-to-now").daterangepicker({
        datepickerOptions: {
            minDate: 0,
            maxDate: null
        }
    });
}

$('a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
    var _current_tab = $(e.target), current_tab_name = _current_tab.attr("href").replace("#", ""),
        tabText = $(this).find(".tabText").text();

        if (tabText == "Graphs" || tabText == "Report" || tabText == "Revenue" || tabText == "Indicators") {
            if (typeof chartsArray !== 'undefined' && chartsArray.length)
                $.each(chartsArray, function (i, each) {
                    console.log(each.func)
                    switch (each.func) {
                        case 'drawNewGoogleChart':
                            drawNewGoogleChart(each.data, each.title, each.div, each.type, each.subtitle);
                            break;
                        case 'drawComboChart':
                            drawComboChart(each.data, each.options, each.div, each.type);
                            break;
                        case 'drawGoogleChart':
                            drawGoogleChart(each.data, each.options, each.div, each.type);
                            break;
                }
            });
        }
});



function Add_Date_Format($format, timepicker, step) {
    var date_format = $(document).find('.date_format'),
        _format = (typeof $format !== 'undefined') ? $format : 'd-M-Y';

    if (typeof timepicker !== 'undefined')
        timepicker = true;
    else
        timepicker = false;

    if (typeof step !== 'undefined')
        step = step;
    else
        step = 5;

    date_format.datetimepicker({
        value: null,
        format: _format,
        closeOnDateSelect: true,
        yearStart: 1930,
        yearEnd:2040,
        dayOfWeekStart: 1,
        step:step,
        timepicker: timepicker
    });
}

function AddDateFormatElement(element, $format, timepicker, step) {
    var _format = (typeof $format !== 'undefined') ? $format : 'dMy';

    if (element && typeof element !== 'undefined') {

        step = (typeof step !== 'undefined') ? step : 60;
        timepicker = (typeof timepicker !== 'undefined');

        element.datetimepicker({
            value: null,
            format: _format,
            closeOnDateSelect: true,
            yearStart: 1930,
            yearEnd: 2040,
            dayOfWeekStart: 1,
            timepicker: timepicker,
            step: step
        });
    }
}

function AddTimeFormatElement(element, $format, step) {
    var _format = (typeof $format !== 'undefined') ? $format : 'H:i';

    if (element && typeof element !== 'undefined') {

        step = (typeof step !== 'undefined') ? step : 5;

        element.datetimepicker({
            format: _format,
            closeOnDateSelect: true,
            minTime:"00:00",
            maxTime:"23:59",
            // dayOfWeekStart: 1,
            datepicker: false,
            step: step
        });
    }
}

//jQuery(function ($) {



    function processAjaxData(response, urlPath){
        //document.title = response.pageTitle;
        window.history.pushState({"html":response},"", urlPath);
        //window.history.pushState({"html":response.html,"pageTitle":response.pageTitle},"", urlPath);
    }

    window.onpopstate = function(e){
        if(e.state){
            var content = $('#content');
            document.getElementById("content").innerHTML = e.state.html;
            //document.title = e.state.pageTitle;
            Apply_Tablesorter(content);
            Apply_Multiselect();
            AddDateFormatElement($('.datetimepicker'), 'Y-m-d')
        }

    };

    function loadCssJsAfterAjax(element, parent, filetype){
       var includedFile;
        if (filetype=="js"){ //if filename is a external JavaScript file
            includedFile = document.createElement('script');
            includedFile.setAttribute("type","text/javascript");
            includedFile.setAttribute("src", $(element).attr('src'));
            //$.getScript($(element).attr('src'));
        }
        else if (filetype=="css"){ //if filename is an external CSS file
            includedFile = document.createElement("link");
            includedFile.setAttribute("rel", "stylesheet");
            includedFile.setAttribute("type", "text/css");
            includedFile.setAttribute("href", $(element).attr('href'))
        }
        if (typeof includedFile != "undefined")
            parent.append(includedFile);
    }

    /**
     * Navbar Menu Ajax Calls
     */
    var menu =
    $(document).on('click', '.navbar .dropdown-menu li a.DELETEME', function () {
        var url_link = $(this).attr('href'), content = $('.content'), body = $('body'), parent = $(this).parents('li.dropdown');

        $('.container').children().remove();

        parent.removeClass('open');

        $(body).addClass('ajax_load');
        //ajax_loading.css('top', ($(window).height() - $(this).outerHeight()) / 2 + 'px');
        content.html(ajax_loading);

        var request = $.ajax({
            url: url_link,
            type: "GET", // not POST, laravel won't allow it
            data: {
                // passed Data;
            }});

         request.success(function (data) {
                // Done Loading Background Style
                body.removeClass('ajax_load');

                // Add Content And Change URL
                //processAjaxData(data, url_link);

                // Put Response Data To Content
                $(document).find("#content").html(data);//.html;

                // Eval JS scripts
                content.find("script:not([data-ignore])").each(function() {
                    if ($(this).text()) {
                        eval($(this).text());
                    }
                    else {
                        loadCssJsAfterAjax($(this), content, 'js');
                    }
                });
                // Eval CSS
                content.find("style, link").each(function() {
                    if ($(this).text()) {
                        loadCssJsAfterAjax($(this), content);
                    }
                    else {
                        loadCssJsAfterAjax($(this), content, 'css');
                    }
                });
                // Apply Plugins
                Apply_Tablesorter(content);
                Apply_Multiselect();
                Apply_DateFormat();
        });

        request.always(function(){

        });
        return false;
    });
//});

/**
 * Disable Form elements
 * @param element
 * @constructor
 */
function Disable_Form(element, exception){
    $(element).find("input").prop("disabled", true);
    $(element).find("button").prop("disabled", true);
    $(element).find("select").prop("disabled", true);
    $(element).find("a").attr("disabled", true);

    if (typeof exception !== 'undefined'){
        $.each(exception, function (i, each) {
            if (each == 'a') {
                $(element).find(each).attr("disabled", false);
            }
            else {
                $(element).find(each).prop("disabled", false);
            }
        })
    }
}
/**
 * Enable Form Elements
 * @param element
 * @constructor
 */
function Enable_Form(element){
    $(element).find("input").prop("disabled",  false);
    $(element).find("button").prop("disabled", false);
    $(element).find("select").prop("disabled", false);
    $(element).find("a").attr("disabled", false);
}

function mainfunc (func){
    this[func].apply(this, Array.prototype.slice.call(arguments, 1));
}


/**
 * Alert Messages To Automatically Close After N sec.
 */
function autoCloseAlert(element) {
    setTimeout(function () {
        element.remove();
    }, ALERT_CLOSE_DELAY);

}

// ********** Views JS Form AJAX Handlers ************ //
/**
 * Crew Roster
 * crewroster/cabincrew
 * crewroster/flightcrew
 * @param data
 */
function crewRosterGenerate(data){
    console.log(data);
}

/**
 * RevenueDataController
 * revenue-data/index
 * @param data
 */
function revenueDataSearch(data){
    var result_container = $('.result_container'), table, thead, tr, th, tbody, td;

    console.log(data);

    table = $('<table></table>').addClass('mytable').addClass('tablesorter');
    thead = $('<thead></thead>');
    tr = $('<tr></tr>');
    $.each(data.table_header, function(i, item){
        $('<th></th>').text(item).appendTo(tr);
    });
    tr.appendTo(thead);
    thead.appendTo(table);

    tbody = $('<tbody></tbody>');
    $.each(data.table_data, function(i, obj){
        tr = $('<tr></tr>');
        /*$('<td></td>').text(item.sales_date).appendTo(tr);
        $('<td></td>').text(item.last_name).appendTo(tr);
        $('<td></td>').text(item.last_name).appendTo(tr);*/
        $.each(obj, function (j, item) {
            $('<td></td>').text(item).appendTo(tr);
        });
        tr.appendTo(tbody);
    });
    tbody.appendTo(table);
    console.log(table);

    result_container.html(table);

}



// ************ END OF VIEWS JS ***************** //




function disableAllLinks(){
    $(document).find('a').bind("click.myDisable", function() { return false; });
}

function enableAllLinks(){
    $(document).find('a').unbind("click.myDisable");
}

function pagination(parent, form) {
    parent.find('.pagination a, .pager a').on('click', function (event) {
        event.preventDefault();
        var _this = $(this), href = _this.attr('href'), match, page;
        // Regexp get Page Number
        match = /page=(\d)/.exec(href);

        if (typeof match[1] !== 'undefined') {
            page = match[1];
            form.find('input[name=page]').remove();
            form.append($('<input />').attr('type', 'hidden').attr('name', 'page').val(page));
            form.append($('<input />').attr('type', 'hidden').attr('name', 'cacheQuery').val(1));
            form.find('.ajax_submit').click();
        }
    });

}


// Upload File Btn Styling
var uploadBtn  = $('#uploadBtn');
$(document).on('change', '#uploadBtn', function () {
    $('#uploadFile').val($(this).val().substr(12));
});

/*document.getElementById("uploadBtn").onchange = function () {
    document.getElementById("uploadFile").value = this.value.substring(12);
};*/

function changeFormEvent(form){
    form.on('change', 'input, select', function () {
        form.find('input[name=page]').remove();
    })
}

/**
 * Check Required Fields, And Select Them if Found Required
 * @param form
 * @returns {boolean}
 */
function checkRequiredFields(form, selector){
    form.find('[required=required]').removeClass('required');

    var requiredFields = form.find('[required=required]'), found = 0;
    if (requiredFields.length){
        requiredFields.each(function(){
            if (!$(this).val()) {
                $(this).addClass('required');
                found = 1;
            }
        });
        if (found) {
            selector.after(fill_required_fields);
            return false;
        }
        else {
            form.find('.required-info').remove();
        }
    }

    return true;
}

/**
 * All Ajax Form Submits
 */
$(document).on('click', '.ajax_submit', function(e){
    var _this = $(this), parent_form = _this.parents('form'), data = parent_form.serializeObject(), content = $('.content'),
        ajax_main_container = $('.ajax_main_container'), module_name_container = $('.module_name'), container = $('.container'),
        ajax_info_container = $('.ajax_info_container'), infoBox, moduleName, remainingContent, message, same_url = parent_form.attr('data-same_url'),
        actionUrl = parent_form.attr('action'), jsHandlerFunction = parent_form.attr('data-jsHandlerFunction'), no_alert = parent_form.attr('data-no_alert'),
        formMethod = parent_form.attr('method');

    if (e.originalEvent !== undefined) {
        parent_form.find('input[name=cacheQuery]').remove();
    }

    // Check If Required Fields Are Filled
    if (!checkRequiredFields(parent_form, _this))
        return false;


    // Get Submit Button Also
    if (!_this.attr('data-ignore'))
        data[_this.attr('name')] = true;

    // Get File Inputs Also
    data[parent_form.find('input[type=file]').attr('name')] = parent_form.find('input[type=file]').val();

    // Disable Form
    Disable_Form(parent_form);

    // Disable Links
    disableAllLinks();

    // Show modal
    modal_ajax_loading.show();

    //console.log('Handler Function : ' +  jsHandlerFunction);
    //console.log('Form URL : ' + actionUrl);
    //console.log('Form Method : ' + formMethod);
    //console.log(data);

    $.ajax( actionUrl, {
        headers: {
            'x-csrf-token': _this.parents('form').find('input[name=_token]').val()
        },
        type: formMethod,
        data: data
    })
      .done(function (data) {

        // Add Content And Change URL
        if (typeof same_url === 'undefined' || !same_url.length) {
            //processAjaxData(data, actionUrl);
        }

        // Display Session Flash Message
        $.get(baseUrl + '/template/ajax-session-flash-message', {})
            .done(function (flashData) {
                container.html(flashData);
                autoCloseAlert(container);
        });
        // Set Auto Close


        // Call Function Listed In Form Element If Necessary
        if (typeof  jsHandlerFunction !== 'undefined' && jsHandlerFunction) {
            mainfunc(jsHandlerFunction, data);
            data = $(data);
        }
        else{
            data = $(data);
            // Module Name
            moduleName = data.closest('.module_name');
            if (moduleName.length){
                module_name_container.html(moduleName);
            }
            console.log(moduleName);

            // Info Alert Box
            infoBox = data.closest('.alert');
            if (!infoBox.length){
                infoBox = data.find('.alert');
            }
            if (infoBox.length){
                ajax_info_container.html(infoBox);
                //infoBox.remove();
            }
            else {
                // If data-no_alert is set -> Don't show alert
                if (typeof no_alert === 'undefined') {
                    ajax_info_container.children().remove();
                    message = alert_box.clone().addClass('alert-success').text("Success!");
                    ajax_info_container.html(message);
                    autoCloseAlert(message);
                }
            }

            // Remaining Content
            remainingContent = data.not('.alert')
                                   .not('.module_name');

            if (remainingContent.length)
                ajax_main_container.html(remainingContent);
        }

        // Eval JS scripts
        data.nextAll("script:not([data-ignore])").each(function() {
            if ($(this).text()) {
                eval($(this).text());
            }
            else {
                loadCssJsAfterAjax($(this), data, 'js');
            }
        });
        // Eval CSS
        data.nextAll("style, link").each(function() {
            if ($(this).text()) {
                loadCssJsAfterAjax($(this), content);
            }
            else {
                loadCssJsAfterAjax($(this), content, 'css');
            }
        });

        // Change Form Element
        changeFormEvent(parent_form);

        // Pagination
        pagination(content, parent_form);

        // Apply Plugins
        Apply_Tablesorter(content);

        Apply_DateFormat();

        // DELETE THIS IT MAY CAUSE PROBLEM!!!!!!!!!!!
        //Apply_Multiselect();

    })
      .fail(function (jqXHR, textStatus, errorThrown) {
            message = alert_box.clone().addClass('alert-danger').text("Failed!");
            ajax_info_container.html(message);
            autoCloseAlert(message);
        })
      .always(function () {
        // Hide Modal
        modal_ajax_loading.hide();
        // Enable Form
        Enable_Form(parent_form);
        // Enable All Links
        enableAllLinks();
    });

    return false;

});


$(document).on('click', '.ajax_within_page', function(e){
    var _this = $(this), parent_form = _this.parents('form'), data = parent_form.serializeObject(), content = $('.content'),
        ajax_main_container = $('.ajax_main_container'), module_name_container = $('.module_name'), container = $('.container'),
        ajax_info_container = $('.ajax_info_container'), infoBox, moduleName, remainingContent, message, removeElement,
        actionUrl = parent_form.attr('action'), jsHandlerFunction = parent_form.attr('data-jsHandlerFunction'), no_alert = parent_form.attr('data-no_alert'),
        formMethod = parent_form.attr('method'), parentElement, operationType = APPEND, substituteId = _this.attr('data-substituteId');


    if (_this.attr("data-actionUrl")){
        actionUrl = _this.attr("data-actionUrl");
    }

    if (_this.attr("data-jsHandlerFunction")){
        jsHandlerFunction = _this.attr("data-jsHandlerFunction");
    }

    if (_this.attr("data-parentElement")){
        parentElement = $(_this.attr("data-parentElement"));
    }

    if (_this.attr("data-operationType")){
        operationType = _this.attr("data-operationType");
    }

    if (e.originalEvent !== undefined) {
        parent_form.find('input[name=cacheQuery]').remove();
    }

    // Check If Required Fields Are Filled
    if (!checkRequiredFields(parent_form, _this))
        return false;

    // Get Submit Button Also
    if (!_this.attr('data-ignore'))
        data[_this.attr('name')] = true;

    // Get File Inputs Also
    data[parent_form.find('input[type=file]').attr('name')] = parent_form.find('input[type=file]').val();

    // Disable Form
    Disable_Form(parent_form);

    // Disable Links
    disableAllLinks();

    // Show modal
    modal_ajax_loading.show();

    console.log(data);


    $.ajax( actionUrl, {
        headers: {
            'x-csrf-token': _this.parents('form').find('input[name=_token]').val()
        },
        type: formMethod,
        data: data
    })
        .done(function (data) {
            console.log(data);

            // Call Function Listed In Form Element If Necessary
            if (typeof parentElement !== 'undefined'){
                switch (operationType){
                    case INSERT:
                        parentElement.html(data);
                        break;
                    case PREPEND:
                        parentElement.prepend(data);
                        break;
                    case SUBSTITUTE:
                        if (typeof substituteId !== 'undefined'){
                            removeElement = parentElement.find(substituteId);
                            console.log(removeElement)
                            removeElement.before(data);
                            removeElement.remove();
                        }
                        break;
                    case APPEND:
                    default :
                        parentElement.append(data);
                        break;
                }
            }
            else if (typeof  jsHandlerFunction !== 'undefined' && jsHandlerFunction) {
                mainfunc(jsHandlerFunction, data);
                data = $(data);
            }

            data = $(data);
            // Module Name

            // Eval JS scripts
            data.nextAll("script:not([data-ignore])").each(function() {
                if ($(this).text()) {
                    eval($(this).text());
                }
                else {
                    loadCssJsAfterAjax($(this), data, 'js');
                }
            });
            // Eval CSS
            data.nextAll("style, link").each(function() {
                if ($(this).text()) {
                    loadCssJsAfterAjax($(this), content);
                }
                else {
                    loadCssJsAfterAjax($(this), content, 'css');
                }
            });

            // Change Form Element
            changeFormEvent(parent_form);

            // Pagination
            pagination(content, parent_form);

            // Apply Plugins
            Apply_Tablesorter(content);

            Apply_DateFormat();

            // DELETE THIS IT MAY CAUSE PROBLEM!!!!!!!!!!!
            //Apply_Multiselect();

        })
        .fail(function (jqXHR, textStatus, errorThrown) {
            message = alert_box.clone().addClass('alert-danger').text("Failed!");
            ajax_info_container.html(message);
            autoCloseAlert(message);
        })
        .always(function () {
            // Hide Modal
            modal_ajax_loading.hide();
            // Enable Form
            Enable_Form(parent_form);
            // Enable All Links
            enableAllLinks();
        });

    return false;

});


$(document).on('click', '.ajax', function () {
    var _this = $(this), parent = _this.attr('data-parent'), removeElement = _this.parents(parent).first(),
        type = _this.attr('data-type'), operationType = _this.attr('data-operationType'),
        id = _this.attr('data-id'), actionUrl = _this.attr('data-url'), container = _this.attr('data-container');

    // Show modal
    modal_ajax_loading.show();

    if (typeof container !== 'undefined') {
        container = $(container);
    }
    else {
        container = removeElement.parent();
    }

    $.get( actionUrl, {

    })
        .done(function (data) {
            showMessage(SUCCESS_MESSAGE, false, MESSAGE_SUCCESS, false, true, container);
            switch (type){
                case "remove":
                    removeElement.remove();
                    break;
                case "update":
                    switch (operationType){
                        case INSERT:
                            container.html(data);
                            break;
                        case PREPEND:
                            container.prepend(data);
                            break;
                        case APPEND:
                        default :
                            container.append(data);
                            break;
                    }
                    break;
                default :
                    break;
            }
        })
        .fail(function () {
            showMessage(error_message, false, MESSAGE_DANGER, false, false, container);
        })
        .always(function () {
            modal_ajax_loading.hide();
        });

    return false;
});

function Apply_DateFormat(){
    $(document).find('.dateFrom, .dateTo, .datepicker').datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false
    });
}

/// Template Editable ----------------------------------------------------------------------

var editable_container = $();

$(document)
    .on('click', '.editable_div a.editable', function () {
    // data_value For Checklist, Selectbox
    var _this = $(this), parent = _this.parent(), type = _this.attr('data-type'), apply_class = _this.attr('data-apply_class'),
        id = _this.attr('data-id'), input_char_max = _this.attr('data-input_char_max'),
        text = _this.text(), selector, js_format = _this.attr('data-js_format'), multiselect = false,
        url = _this.attr('data-url'), format = _this.attr('data-format'), model = _this.attr('data-model'),
        value = _this.attr('data-value'), field = _this.attr('data-field'), viewData, request;

    // Cancel Previous Edits
    cancel_previous_edits();

    // Hide A Href
    _this.hide();

    // Show Loading Animation
    parent.prepend(loading);

    // Load Content
    request = $.get(baseUrl + '/template/ajax-get-editable-fields', {
        input_char_max : input_char_max,
        class : apply_class,
        type  : type,
        field : field
    });

    request.done(function(data){
        viewData = $(data);
        switch (type){
            case 'textarea':
                selector = viewData.find('textarea');
                if (text && $.trim(text) !== 'Empty') {
                    selector.text(text);
                }
                break;
            case 'text':
                selector = viewData.find('input');
                if (text && $.trim(text) !== 'Empty') {
                    selector.val(text);
                }
                break;
            case 'select':
                selector = viewData.find('select');
                if (text && $.trim(text) !== 'Empty') {
                    selector.val(value);
                }
                break;
            case 'multiselect':
                selector = viewData.find('select');
                if (value && $.trim(value) !== 'Empty') {
                    value = JSON.parse(value);
                    selector.val(value);
                }
                multiselect = true;
                break;
            case 'time':
                selector = viewData.find('input');
                if (text && $.trim(text) !== 'Empty') {
                    text = $.trim(text);
                    selector.val(text);
                }
                console.log(text)
                AddTimeFormatElement(selector, format);
                break;
            case 'date':
                selector = viewData.find('input');
                if (text && $.trim(text) !== 'Empty') {
                    text = $.trim(text);
                    selector.val(text);
                }
                console.log(text)
                AddDateFormatElement(selector, format);
                break;
            case 'checklist':
                selector = viewData.find('input');
                if (text == "Yes") {
                    selector.prop("checked", true);
                }
                break;
        }
        parent.append(viewData);
        selector = parent.find(selector);
        selector.focus();
        if (multiselect) {
            Apply_Multiselect();
        }

    });

    request.always(function(){
        loading.remove();
    });

    return false;
})
    .on('click', '.editable_div .editable-submit', function () {
        var _this = $(this), parent = _this.parents('span.editable-container'), originalAHref = parent.prev('a.editable'),
            message_box = parent.parents('div.editable_div').find('div.message_box'),
            type = originalAHref.attr('data-type'), id = originalAHref.attr('data-id'), foreign_key = originalAHref.attr('data-foreign_key'),
            js_format = originalAHref.attr('data-js_format'), value_key = originalAHref.attr('data-value_key'),
            url = originalAHref.attr('data-url'), format = originalAHref.attr('data-format'), model = originalAHref.attr('data-model'),
            field = originalAHref.attr('data-field'), field_value = originalAHref.attr('data-field_value'),
            selector, serverValue, viewValue = '', momentDate, selectedOptions, request;

        switch (type){
            case 'textarea':
                selector = parent.find('textarea');
                serverValue = selector.val();
                viewValue = selector.val();
                if (!viewValue)
                    viewValue = 'Empty';
                break;
            case 'text':
                selector = parent.find('input');
                serverValue = selector.val();
                viewValue = selector.val();
                if (!viewValue)
                    viewValue = 'Empty';
                break;
            case 'select':
                selector = parent.find('select');
                serverValue = selector.val();
                viewValue = $(selector).find("option:selected").text();
                if (!serverValue)
                    viewValue = 'Empty';
                break;
            case 'multiselect':
                selector = parent.find('select');
                serverValue = selector.val();
                selectedOptions = $(selector).find("option:selected");
                if (selectedOptions.length){
                    selectedOptions.each(function () {
                        viewValue = viewValue ? viewValue + ', ' + $(this).text() : $(this).text();
                    });
                }
                else {
                    viewValue = 'Empty';
                }
                break;
            case 'time':
                selector = parent.find('input');
                momentDate = moment(selector.val(), js_format);
                if (momentDate.isValid()){
                    serverValue = momentDate.format('HH:mm');
                    viewValue = selector.val();
                }
                else {
                    serverValue = '';
                    viewValue = 'Empty';
                }
                break;
            case 'date':
                selector = parent.find('input');
                momentDate = moment(selector.val(), js_format);
                if (momentDate.isValid()){
                    serverValue = momentDate.format('YYYY-MM-DD');
                    viewValue = selector.val();
                }
                else {
                    serverValue = '';
                    viewValue = 'Empty';
                }
                break;
            case 'checklist':
                selector = parent.find('input');
                serverValue = selector.is(":checked") ? 1 : 0;
                viewValue = serverValue ? "Yes" : "No";
                if (!viewValue)
                    viewValue = 'Empty';
                break;
        }

        var submitData = {
            //_token      : $(this).parents('form').find('input[name=_token]').val(),
            id          : id,
            foreign_key : foreign_key,
            model       : model,
            field       : field,
            field_value : field_value,
            type        : type,
            value       : serverValue,
            value_key   : value_key
        };

        console.log(submitData)

        request = $.ajax(baseUrl + '/template/ajax-save-editable-fields', {
            type: 'GET',
            //headers: {
            //    'x-csrf-token': $(this).parents('form').find('input[name=_token]').val()
            //},
            data: submitData
        });
        request.done(function (data) {
            if (data.success){
                showMessage(data.message, 'Success', data.type, message_box, true);
                parent.remove();
                originalAHref.text(viewValue);
                if (!viewValue || viewValue == 'Empty'){
                    originalAHref.removeClass('editable-click');
                    if (!originalAHref.hasClass('editable-empty')) {
                        originalAHref.addClass('editable-empty');
                    }
                }
                else {
                    originalAHref.removeClass('editable-empty');
                    if (!originalAHref.hasClass('editable-click')) {
                        originalAHref.addClass('editable-click');
                    }
                }

                if ($.isArray(serverValue)){
                    originalAHref.attr('data-value', JSON.stringify(serverValue));
                }
                else{
                    originalAHref.attr('data-value', serverValue);
                }
                originalAHref.show();
            }
            else {
                showMessage(data.message, 'Error', data.type, message_box, true);
            }
        });

        request.fail(function(jqXHR, text_status){
            showMessage(jqXHR.statusText, 'Danger', 'danger', message_box, true);
        });

        return false;
    })
    .on('click', '.editable_div .editable-cancel', function () {
        var _this = $(this), parent = _this.parents('span.editable-container'), originalAHref = parent.prev('a.editable');
        parent.remove();
        originalAHref.show();

        return false;
    })
    .on('click', '.editable_div .editable-clear-x', function () {
        $(this).prev('input').val("");

        return false;
    });

/**
 * Cancel Previously Editable Actions
 */
function cancel_previous_edits(){
    var parent = $(document).find('span.editable-container'), originalAHref = parent.prev('a.editable');
    parent.remove();
    originalAHref.show();
}

///----------------------------------------------------------------------------------------


$.fn.serializeObject = function()
{
    var o = {};
    var a = this.serializeArray();
    $.each(a, function() {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};

if (dateFrom.length) {
    dateFrom.datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false
        /*onShow: function (ct) {
         this.setOptions({
         maxDate: dateTo.val() ? dateTo.val() : false
         })
         }*/
    });
}

if (dateTo.length) {
    dateTo.datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false
        /*onShow: function (ct) {
         this.setOptions({
         minDate: dateFrom.val() ? dateFrom.val() : false
         })
         }*/
    });
}

if (datepicker.length) {
    datepicker.datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false
        /*onShow: function (ct) {
         this.setOptions({
         minDate: dateFrom.val() ? dateFrom.val() : false
         })
         }*/
    });
}

if (dateTimeFormat.length) {
    dateTimeFormat.datetimepicker({
        format: 'd-M-Y H:i',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: true,
        step: 5,
        weeks: true
        /*onShow: function (ct) {
         this.setOptions({
         maxDate: dateTimeTo.val() ? dateTimeTo.val() : false
         })
         }*/
    });
}

if (dateTimeFrom.length) {

    dateTimeFrom.datetimepicker({
        format: 'Y-m-d H:i',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: true,
        step: 5,
        weeks: true
        /*onShow: function (ct) {
         this.setOptions({
         maxDate: dateTimeTo.val() ? dateTimeTo.val() : false
         })
         }*/
    });
}

if (dateTimeTo.length) {

    dateTimeTo.datetimepicker({
        format: 'Y-m-d H:i',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: true,
        step: 5,
        weeks: true
        /*onShow: function (ct) {
         this.setOptions({
         minDate: dateTimeFrom.val() ? dateTimeFrom.val() : false
         })
         }*/
    });
}
/**
 * GUID generator
 * @returns {string}
 */
function guidGenerator() {
    var randLetter = String.fromCharCode(65 + Math.floor(Math.random() * 26));
    return randLetter + Date.now();
}


function implode(arr, delimiter) {
    return (arr instanceof Array) ? arr.join(delimiter) : arr;
}


$(document).find('.tftextinput').autocomplete({
    source: function( request, response ) {
        $.ajax({
            url : baseUrl + '/template/ajax-model-autocomplete',
            dataType: "json",
            data: {
                name_starts_with: request.term,
                type: 'iata_terms'
            },
            success: function( data ) {
                response( $.map( data, function( item ) {
                    return {
                        label: item,
                        value: item
                    }
                }));
            }
        });
    },
    autoFocus: true,
    minLength: 0
});


function Apply_Tablesorter(parent) {
    var elem = $('.mytable');
    if (typeof parent !== 'undefined') {
        elem = parent.find(".mytable");
    }

    if (elem.length) {
        elem.tablesorter(
            {
                theme: 'blue',

                //sortList : [[1,0],[2,0],[3,0]],

                // header layout template; {icon} needed for some themes
                //headerTemplate : '{content}{icon}',

                // initialize column styling of the table
                widgets: ['zebra', 'columns'],
                widgetOptions: {
                    filter_reset: '.reset'
                    // change the default column class names
                    // primary is the first column sorted, secondary is the second, etc
                    //columns : [ "primary", "secondary", "tertiary" ]
                }
            });
    }
}

/*
$('.tableFilters').tablesorter({
    theme: 'blue',
    widgets: ['zebra', 'filter'],
    widgetOptions: {
        filter_reset: '.reset'
    }
});


$('.blackEdition').tablesorter({
    theme: 'blue',
    widgets: ['zebra', 'filter'],
    widgetOptions: {
        filter_reset: '.reset'
    }
});
*/

function ApplyTablesorter(tableClassOrId, parent) {
    if (typeof tableClassOrId === 'undefined') {
        tableClassOrId = ".blackEdition";
    }

    var elem = $(tableClassOrId);
    if (typeof parent !== 'undefined') {
        elem = parent.find(".mytable");
    }

    elem.tablesorter(
        {
            theme: 'blue',
            widgets: ['zebra', 'filter'],
            widgetOptions: {
                filter_reset: '.reset'
            }
        });
}

//ApplyTablesorter();

function ApplyTablesorter() {

    var elements = $(document).find('.tablePagination');

    if (find.length == 0) {
        return;
    }

    elements.tablesorterPager({
        // target the pager markup - see the HTML block below
        container: $(".pager"),
        // output string - default is '{page}/{totalPages}';
        // possible variables: {size}, {page}, {totalPages}, {filteredPages}, {startRow}, {endRow}, {filteredRows} and {totalRows}
        // also {page:input} & {startRow:input} will add a modifiable input in place of the value
        output: '{startRow} - {endRow} / {filteredRows} ({totalRows})',
        // if true, the table will remain the same height no matter how many records are displayed. The space is made up by an empty
        // table row set to a height to compensate; default is false
        fixedHeight: false,
        // remove rows from the table to speed up the sort of large tables.
        // setting this to false, only hides the non-visible rows; needed if you plan to add/remove rows with the pager enabled.
        removeRows: false,
        // go to page selector - select dropdown that sets the current page
        cssGoto: '.gotoPage',

        // starting page of the pager (zero based index)
        page: 0,

        // Number of visible rows - default is 10
        size: 25,
    });
}

function AjaxExportExcel(){
    request = $.ajax({
        url: baseUrl + "/crewroster/ajax-export-excel",
        type: 'POST',
        dataType: 'json',
        data: {
            msg: 'success',
            export_array: $export_array
        }
    });


    request.done(function (data) {
        if (typeof data.success !== 'undefined'){
            console.log(data);
        }
        console.log(data)

    });
    request.fail(function (jqXHR, text_status) {
        console.log(jqXHR);
        console.log(text_status);
    });
}


function uppercaseFirstLetter(str){
    str = str.toLowerCase().replace(/\b[a-z]/g, function(letter) {
        return str.toUpperCase();
    });
}


/**
 * Show message
 * @param message
 * @param title
 * @param type
 * @param container
 */
function showMessage(message, title, type, container, auto_close, containerPrepend) {
    var guid = guidGenerator();


    if (typeof containerPrepend !== 'undefined'){
        containerPrepend.find('.alert').remove();
        containerPrepend.prepend('<div class="alert alert-message alert-' + type + '" id="alert-' + guid + '">' +
            '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
            (title ? '<h4>' + title + '</h4>' : '') +
            '<p>' + message + '</p>' +
            '</div>');
    }
    else {
        container.empty()
            .append('<div class="alert alert-message alert-' + type + '" id="alert-' + guid + '">' +
            '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
            (title ? '<h4>' + title + '</h4>' : '') +
            '<p>' + message + '</p>' +
            '</div>');
       container.fadeIn(500);
    }
    // auto closing
    if (AUTO_CLOSING_SUCCESS_ALERTS || typeof auto_close !== 'undefined') {
        window.setTimeout(function () {
            var alert = $("#alert-" + guid);
            alert.fadeOut(500, function () {
                alert.remove();
            });
        }, ALERT_CLOSE_DELAY);
    }
}

function isEven(n) {
    return isNumber(n) && (n % 2 == 0);
}

function isOdd(n) {
    return isNumber(n) && (Math.abs(n) % 2 == 1);
}

function isNumber(n) {
    return n === parseFloat(n);
}

// Split a string by string
function explode(delimiter, string) {
    var emptyArray = {0: ''};

    if (arguments.length != 2
        || typeof arguments[0] == 'undefined'
        || typeof arguments[1] == 'undefined') {
        return null;
    }

    if (delimiter === ''
        || delimiter === false
        || delimiter === null) {
        return false;
    }

    if (typeof delimiter == 'function'
        || typeof delimiter == 'object'
        || typeof string == 'function'
        || typeof string == 'object') {
        return emptyArray;
    }

    if (delimiter === true) {
        delimiter = '1';
    }
    return string.toString().split(delimiter.toString());
}

/*(function ($) {
    $(".confirm").on("click", function () {
        return confirm($(this).attr("data-confirm-text"));
    });


}(jQuery));*/




$(".multiselect-toggle").click(function(e) {
    e.preventDefault();
    multiselect_toggle($(this).parent('div').find("select.multiselect_search"), $(this));
});

function calculateHeightAndWidthOfGraph(){
    var browserWidth = $( document ).width(), browserHeight;
    browserWidth =  parseInt((browserWidth - browserWidth * 0.2) / 2);
    browserHeight = parseInt(browserWidth / 2);
    browserHeight = (browserHeight < 350) ? 350 : browserHeight;
    return {'height' : browserHeight, 'width' : browserWidth};
}


function multiselect_selected($el) {
    var ret = true;
    $('option', $el).each(function (element) {
        if (!$(this).prop('selected')) {
            ret = false;
        }
    });
    return ret;
}

function multiselect_selectAll($el) {
    $('option', $el).each(function (element) {
        $el.multiselect('select', $(this).val());
    });
}

/**
 * Deselects all the options
 * param {jQuery} $el
 * returns {undefined}
 */
function multiselect_deselectAll($el) {
    $('option', $el).each(function (element) {
        $el.multiselect('deselect', $(this).val());
    });
}

function multiselect_toggle($el, $btn) {
    if (multiselect_selected($el)) {
        multiselect_deselectAll($el);
        $btn.text("Select All");
    }
    else {
        multiselect_selectAll($el);
        $btn.text("Deselect All");
    }
}

/*
$('.mytable').tablesorter(
    {
        theme: 'blue',

        //sortList : [[1,0],[2,0],[3,0]],

        // header layout template; {icon} needed for some themes
        //headerTemplate : '{content}{icon}',

        // initialize column styling of the table
        widgets: ["columns"],
        widgetOptions: {
            // change the default column class names
            // primary is the first column sorted, secondary is the second, etc
            //columns : [ "primary", "secondary", "tertiary" ]
        }
    });
*/

function Expiration_Date($date){
    var $message = '', $status = '', $filter = '';
    if ($date && typeof $date !== 'undefined' && $date != '') {
        var $today = moment().format('YYYY-MM-DD');
        var curdate_month = moment().format('M');
        var curdate_year = moment().format('YYYY');

        var date_month = moment($date).format('M');
        var date_year = moment($date).format('YYYY');
        var curdate_plus_30days = moment($today).add(30, 'days').format('YYYY-MM-DD');

        if ($date <= $today) {
            if (curdate_year == date_year && curdate_month == date_month) {
                $status = '<span class="label label-warning status_expiry">VALID</span>';
                $filter = 'valid_temp';
                $message = 'Valid(Temp)';
            }
            else {
                $status = '<span class="label label-danger status_expiry">EXPIRED</span>';
                $filter = 'expired';
                $message = 'Expired';
            }
        } else {
            if ($date < curdate_plus_30days) {
                $status = '<span class="label label-warning status_expiry">VALID</span>';
                $filter = 'valid_temp';
                $message = 'Valid(Temp)';
            }
            else{
                $status = '<span class="label label-success status_expiry">VALID</span>';
                $filter = "valid";
                $message = 'Valid';
            }
        }
    }
    else {
        $status = '<span class="label label-primary status_expiry">NOT ISSUED</span>';
        $filter = 'empty';
    }
    return {'status': $status, 'filter': $filter, 'message': $message};
}

function getMessageDiv(type, parent, text ){
    var message = [], standard;
    $('div.alert').remove();
    switch (type){
        case ("Success"):
            message = '<div class="alert alert-dismissable alert-success">'+
            '<button type="button" class="close" data-dismiss="alert">×</button>';
            standard = 'Success! Data was inserted';
            break;
        case ("Warning"):
            message = '<div class="alert alert-dismissable alert-warning">'+
            '<button type="button" class="close" data-dismiss="alert">×</button>';
            standard = 'Date is not selected. Please select Date first.';
            break;
        case ("Error"):
            message = '<div class="alert alert-dismissable alert-danger">'+
            '<button type="button" class="close" data-dismiss="alert">×</button>';
            standard = 'Error! Something went wrong. Please try submitting again.';
            break;
        default :
            break;
    }

    if (typeof text != 'undefined')
        message += text + '</div>';
    else
        message += standard + '</div>';

    parent.prepend(message);
}

function getVlyComparisonSign(array){
    var $vars = [], $diff, $icon = '';

    if (array.length == 2) {
        $.each(array, function(i, val){
            $vars.push(val);
        });

        if ($vars[0] == 0 && $vars[1] == 0) {
            $diff = 0;
        }
        else if ($vars[0] == 0) {
            $diff = -100;
        }
        else if ($vars[1] == 0) {
            $diff = 100;
        }
        else {
            $diff = (($vars[0] - $vars[1]) / $vars[0]) * 100;
        }

        $icon = $('<i></i>').addClass('fa').attr('style', 'margin-left:5px');

        if ($diff < 0) {
            $diff *= -1;
            $icon.addClass('fa-arrow-down').attr('style', 'color: red').text(Math.round($diff)+'%');
        }
        else if ($diff > 0) {
            $icon.addClass('fa-arrow-up').attr('style', 'color: #009000').text(Math.round($diff)+'%');
        }
        else {
            $icon.addClass('fa-minus').attr('style', 'color: blue');
        }
    }

    return $icon;
}

function Languages(){
    return {
        'Chinese'   :   'Chinese',
        'English'   :   'English',
        'German'    :   'German',
        'Russian'   :   'Russian',
        'Tajik'     :   'Tajik'
    }
}

function Location_Bases(){
    return {
        'LBD'   :   'LBD',
        'DYU'   :   'DYU'
    }
}

function Marital_Status(){
    return {
        ''          :   'Select',
        'Single'    :   'Single',
        'Married'   :   'Married'
    }
}

function English_Levels(){
    return {
        1   :   1,
        2   :   2,
        3   :   3,
        4   :   4,
        5   :   5,
        6   :   6
    }
}



function Aircraft_Iata_Type($type){
    var iata = $type;
    switch ($type){
        case 'B737-900' :
            iata = 'B739';
            break;
        case 'B737-800' :
            iata = 'B738';
            break;
        case 'B737-300' :
            iata = 'B733';
            break;
    }
    return iata;
}

// Used By FleetWatch Crew Report Time & Reason
function reasonShowOnCrewChange() {
    $('select.crew, input.reportTime').on('change', function () {
        var _this = $(this), parent = _this.parents(".form-group");
        parent.find('span.reason').show();
    });
};


function Ucfirst($string){
    return $string[0].toUpperCase() + $string.substr(1);
}

/**
 * Get Aircraft Id By Name
 * @param aircraftName
 */
function getAircraftIdByName(aircraftName){
    var request = $.ajax({
        async: false,
        url: baseUrl + '/aircraft/ajax-get-aircraft-id',
        type: 'GET',
        dataType: 'JSON',
        data: {
            aircraftName: aircraftName
        }
    });

    /*request.done(function (data){
        if (typeof data.success !== 'undefined' && data.success){
            return data.result;
        }
        return false;
    })*/
}

function Get_Aircraft(type, static){
    if (typeof type !== 'undefined') {
        if (typeof static !== 'undefined'){
            return {  'B737-300'  : 'B737-300',
                'B737-800'  : 'B737-800',
                'B737-900'  : 'B737-900'
            }
        }
        else {
            var request = $.ajax({
                async: false,
                url: baseUrl + "/aircraft/ajax-aircraft",
                type: 'GET',
                dataType: 'json',
                data: {
                    type: type
                }
            });

            request.done(function (data) {
                if (typeof data.success !== 'undefined') {
                    return data.result;
                }

            });
            request.fail(function (jqXHR, text_status) {
                return ['failed'];
            });
        }
    }

}


function drawGoogleChart(chart_data, chart_options, element, chart_type) {
    // Function for visualize Google Chart
    var chart, data;

    data = google.visualization.arrayToDataTable(chart_data);

    switch (chart_type) {
        case CHART_BAR:
            chart = new google.visualization.BarChart(document.getElementById(element));
            break;
        case CHART_COLUMN:
            chart = new google.visualization.ColumnChart(document.getElementById(element));
            break;
        case CHART_LINE:
            chart = new google.visualization.LineChart(document.getElementById(element));
            break;
        case CHART_PIE:
            chart = new google.visualization.PieChart(document.getElementById(element));
            break;
        case CHART_GEO:
            chart = new google.visualization.GeoChart(document.getElementById(element));
            break;
        case CHART_COMBO:
            chart = new google.visualization.ComboChart(document.getElementById(element));
            break;
        default :
            chart = new chart_type(document.getElementById(element));
            break;
    }

    chart.draw(data, chart_options);

    return chart;
}

function getChartOptions(graph_title, height, width, maxValue, ticks, left, right, position, legend, title, chart_height, slanted_text, pie_hole, magnifyingGlass, colors) {

    if (typeof height === 'undefined')
        height = '80%';
    if (typeof width === 'undefined')
        width = '90%';
    if (typeof left === 'undefined')
        left = 20;
    if (typeof right === 'undefined')
        right = 20;
    if (typeof right === 'undefined')
        position = 'right';



    var chart_width = (100 - left - right)+'%';
    left = left+'%';
    right = right+'%';

    var options = {
        colors: [
            '#00d2ff',
            '#ff7200',
            '#c3eb00',
            '#f64040',
            '#06fc2e',
            '#fe41d4'
        ],
        titleTextStyle: {color: '#A2AEB7', fontSize: 16},
        curveType: 'function',
        vAxis: {
            minValue : 0,
            gridlines: {
                count: -1
                },
            minorGridlines:{
                color: '#A3A9AD'
            },
            textStyle: {color: '#A2AEB7', fontSize: 12},
        },
        hAxis: {
            slantedText: true,
            slantedTextAngle: 70,
            textStyle: {color: '#A2AEB7', fontSize: 12},
            title: "",
            titleTextStyle: {color: '#A2AEB7', fontSize: 9, italic: 0},
            viewWindowMode:100,
            minValue : 0,
            baselineColor: '#A2AEB7',
            gridlines: {
                color: '#A3A9AD'
            },
            minorGridlines:{
                color: '#A3A9AD'
            }
        },
        chartArea: {
            left:left, right: right, width:chart_width, height: '70%'
        },

        backgroundColor: "#3A484F",

        height: height,
        width: width

    };

    if (typeof colors !== 'undefined') {
        options.colors = colors;
    }

    if (typeof pie_hole !== 'undefined') {
        options.pieHole = 0.4;
        options.is3D = true;
        options.pieStartAngle = 100;
    }
    if (typeof magnifyingGlass !== 'undefined') {
        options.magnifyingGlass = {enable: true, zoomFactor: 7.5};
    }

    if (typeof slanted_text !== 'undefined'){
        if (slanted_text == 'none')
            options.hAxis.slantedText = false;
        else {
            options.hAxis.slantedText = true;
            options.hAxis.slantedTextAngle = slanted_text;
        }
    }

    if (typeof chart_height !== 'undefined')
        options.chartArea.height = chart_height;

    if (typeof ticks === 'undefined')
        options.hAxis.ticks = [0,20,40,60,80,100];

    if (typeof maxValue !== 'undefined')
        options.hAxis.maxValue = maxValue;


    if (typeof title === 'undefined') {
        options.title = graph_title;
        options.chartArea.top = 40;
    }
    else
        options.chartArea.top = 10;

    if (typeof legend === 'undefined')
        options.legend = { position: position, alignment: 'center', textStyle: {color: '#A3A9AD', bold: 1, fontSize: 12}};
    else
        options.legend = { position: 'none' };

    return options;
}

function drawChart(graph_data, graph_title, graph_div, chart_type, height, width, maxValue, ticks, primary_color, left, right, position, legend, title, chart_height, slanted_text) {
    var chart;

    console.log('DRAW CHART IS BEING CALLED');

    if (typeof chart_type === 'undefined')
        chart_type = "LineChart";

    if (typeof height === 'undefined')
        var height = '80%';
    if (typeof width === 'undefined')
        var width = '90%';

    if (typeof left === 'undefined')
        var left = 20;
    if (typeof right === 'undefined')
        var right = 20;


    if (typeof right === 'undefined')
        var position = 'right';


    var chart_width = (100 - left - right)+'%';
    left = left+'%';
    right = right+'%';

    console.log(graph_data);
    var data = google.visualization.arrayToDataTable(
        graph_data
    );

    var options = {

        titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 16},
        curveType: 'function',
        vAxis: {
            gridlines: {count: -1}
        },
        hAxis: {
            slantedText: true,
            slantedTextAngle: 70,
            textStyle: {color: 'black', fontName: 'Verdana', fontSize: 12},
            title: "",
            titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 9, italic: 0},
            viewWindowMode:100,
            minValue : 0

        },
        chartArea: {left:left, right: right, width:chart_width, height: '70%'},

        height: height,
        width: width

    };

    if (typeof slanted_text !== 'undefined'){
        if (slanted_text == 'none')
            options.hAxis.slantedText = false;
        else
            options.hAxis.slantedText = slanted_text;
    }

    if (typeof chart_height !== 'undefined')
        options.chartArea.height = chart_height;

    if (typeof ticks === 'undefined')
        options.hAxis.ticks = [0,20,40,60,80,100];

    if (typeof maxValue !== 'undefined')
        options.hAxis.maxValue = maxValue;


    if (typeof title === 'undefined') {
        options.title = graph_title;
        options.chartArea.top = 40;
    }
    else
        options.chartArea.top = 10;

    if (typeof legend === 'undefined')
        options.legend = { position: position, alignment: 'center', textStyle: {color: 'black', bold: 1, fontSize: 12}};
    else
        options.legend = { position: 'none' };

    if(chart_type == 'BarChart')
        chart = new google.visualization.BarChart(document.getElementById(graph_div));
    else if(chart_type == 'ColumnChart')
        chart = new google.visualization.ColumnChart(document.getElementById(graph_div));
    else
        chart = new google.visualization.LineChart(document.getElementById(graph_div));

    chart.draw(data, options);
}


function drawNewGoogleChart(data, title, div, type, subtitle) {
    var chartData = google.visualization.arrayToDataTable(data),
        height = 350, chart;

    if ($.inArray(type, [CHART_BAR, CHART_COLUMN]) > -1){
        height = (data.length - 1) * 30;
        if (data.length > 4) {
            height = height < 350 ? 350 : height;
        }
        else if (data.length > 2) {
            height = height < 200 ? 200 : height;
        }
        else {
            height = height < 100 ? 100 : height;
        }
        console.log(data.length)
    }

    var options = {
        height: height,
        chart: {
            title: title,
            subtitle: typeof subtitle !== 'undefined' ? subtitle : ""
        }
    };


    if (type == CHART_BAR){
        options.bars = 'horizontal';
    }

    if (type == CHART_LINE){
        options.curveType = 'function';
        chart = new google.charts.Line(document.getElementById(div));
        chart.draw(chartData, google.charts.Line.convertOptions(options));
    }
    else {
        chart = new google.charts.Bar(document.getElementById(div));
        chart.draw(chartData, google.charts.Bar.convertOptions(options));
    }
}

function drawPieChart(graph_data, graph_title, graph_div, chart_type, height, width) {

    if (typeof chart_type === 'undefined')
        chart_type = "LineChart";

    var data = google.visualization.arrayToDataTable(
        graph_data
    );

    if (typeof height === 'undefined')
        height = '80%';
    if (typeof width === 'undefined')
        width = '90%';

    var options = {
        title: graph_title,
        titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 16},
        curveType: 'function',
        vAxis: {
            gridlines: {count: -1}
        },
        hAxis: {
            slantedText: true,
            slantedTextAngle: 70,
            textStyle: {color: 'black', fontName: 'Verdana', fontSize: 8},
            title: "",
            titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 8, italic: 0},

            viewWindowMode:100,
            maxValue:100
        },
        chartArea: {width: '90%', height: '70%'},
        height: height,
        width: width,
        legend: { position: 'right', alignment: 'end', textStyle: {color: 'black', bold: 1, fontSize: 12}}
    };


    var chart = new google.visualization.PieChart(document.getElementById(graph_div));

    chart.draw(data, options);
}

function drawComboChart(graph_data, graph_title, graph_div, column_line, height, width, maxValue, ticks, primary_color, left, right) {

    if (typeof height === 'undefined')
        var height = '20%';

    if (typeof width === 'undefined')
        var width = '20%';

    if (typeof left === 'undefined')
        var left = 20;
    if (typeof right === 'undefined')
        var right = 20;

    var chart_width = (100 - left - right)+'%';
    left = left+'%';
    right = right+'%';

    if (typeof maxValue === 'undefined')
        var maxValue = '';

    if (typeof primary_color === 'undefined')
        var primary_color = '#25891a';

    // Some raw data (not necessarily accurate)

    if (typeof column_line === 'undefined') {
        var series = {3: {type: "line"}};
    }
    else {
        switch (column_line) {
            case 2:
                var series = {2: {type: "line"}};
                break;
            case 1:
                var series = {1: {type: "line"}};
                break;
            default:
                var series = {3: {type: "line"}};
        }
    }


    var data = google.visualization.arrayToDataTable(
        graph_data
    );

    var options = {
        title : graph_title,
        hAxis: {
            slantedText: true,
            slantedTextAngle: 70,
            textStyle: {color: 'black', fontName: 'Verdana', fontSize: 12},
            title: "",
            titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 9, italic: 0}
        },

        titleTextStyle: {color: 'black', fontName: 'Verdana', fontSize: 16},
        colors:[primary_color,'#ff0000', '#25891a', '#df5f00'],
        seriesType: "bars",
        series:series,
        curveType:'function',
        chartArea: {left:left, right:right, top:50, width:chart_width, height: '60%'},
        height:height,
        width: width,
        legend: { position: 'right', alignment: 'top', textStyle: {color: 'black', bold: 1, fontSize: 12}}
    };

    var chart = new google.visualization.ComboChart(document.getElementById(graph_div));
    chart.draw(data, options);
}


function getGoogleChartOptions(options) {

    if (typeof options.height === 'undefined')
        options.height = '90%';
    if (typeof options.width === 'undefined')
        options.width = '90%';
    if (typeof options.left === 'undefined')
        options.left = 15;
    if (typeof options.right === 'undefined')
        options.right = 10;
    if (typeof options.right === 'undefined')
        options.position = 'right';



    var chart_width = (100 - options.left - options.right)+'%';
    options.left += '%';
    options.right += '%';

    var chartOptions = {
        colors: [
            '#00d2ff',
            '#ff7200',
            '#c3eb00',
            '#f64040',
            '#06fc2e',
            '#fe41d4'
        ],
        titleTextStyle: {fontName: 'Verdana', fontSize: 12},
        curveType: 'function',
        vAxis: {
            minValue : 0,
            gridlines: {
                count: -1
            },
            minorGridlines:{
                color: '#1982C5'
            },
            textStyle: {fontName: 'Verdana', fontSize: 10},
        },
        hAxis: {
            textStyle: { fontName: 'Verdana', fontSize: 10},
            viewWindowMode:100,
            minValue : 0,
            baselineColor: '#A3A9AD',

        },
        chartArea: {
            left: options.left,
            right: options.right,
            width: chart_width,
            height: '70%'
        },

//            backgroundColor: "#3A484F",

        height: options.height,
        width: options.width

    };

    if (typeof options.titleTextColor !== 'undefined') {
        chartOptions.titleTextStyle.color = options.titleTextColor;
    }
    if (typeof options.hAxisTextColor !== 'undefined') {
        chartOptions.hAxis.textStyle.color = options.hAxisTextColor;
    }

    if (typeof options.vAxisTextColor !== 'undefined') {
        chartOptions.vAxis.textStyle.color = options.vAxisTextColor;
    }

    if (typeof options.gridlinesColor !== 'undefined') {
        chartOptions.hAxis.gridlines = { color: options.gridlinesColor };
    }
    if (typeof options.minorGridlinesColor !== 'undefined') {
        chartOptions.hAxis.minorGridlines = { color: options.minorGridlinesColor };
    }

    if (typeof options.colors !== 'undefined') {
        chartOptions.colors = options.colors;
    }

    if (typeof options.colors !== 'undefined') {
        chartOptions.colors = options.colors;
    }

    if (typeof options.backgroundColor !== 'undefined') {
        chartOptions.backgroundColor = options.backgroundColor;
    }

    if (typeof options.pie_hole !== 'undefined') {
        chartOptions.pieHole = 0.4;
        chartOptions.is3D = true;
        chartOptions.pieStartAngle = 100;
    }
    if (typeof options.magnifyingGlass !== 'undefined') {
        chartOptions.magnifyingGlass = {enable: true, zoomFactor: 7.5};
    }

    if (typeof options.slantedText !== 'undefined'){
        chartOptions.hAxis.slantedText = true;
        chartOptions.hAxis.slantedTextAngle = options.slantedTextAngle;
    }

    if (typeof options.chart_height !== 'undefined')
        chartOptions.chartArea.height = options.chart_height;

    if (typeof options.ticks !== 'undefined'){
        chartOptions.hAxis.ticks = options.ticks;
    }

    if (typeof options.vTicks !== 'undefined'){
        chartOptions.vAxis.ticks = options.vTicks;
    }

    if (typeof options.maxValue !== 'undefined') {
        chartOptions.hAxis.maxValue = options.maxValue;
    }

    if (typeof options.title !== 'undefined') {
        chartOptions.title = options.title;
        chartOptions.chartArea.top = 40;
    }
    else {
        chartOptions.chartArea.top = 10;
    }

    if (typeof options.series !== 'undefined') {
        chartOptions.series = options.series;
    }

    if (typeof options.seriesType !== 'undefined') {
        chartOptions.seriesType = options.seriesType;
    }

    if (typeof options.legend !== 'undefined'){
        chartOptions.legend = options.legend;
    }
    else {
        chartOptions.legend = {
            position: "none",
            //alignment: 'center',
            //textStyle: {color: '#A3A9AD', bold: 1, fontSize: 12}
        };
    }


    return chartOptions;
}


/**
 * Options ([height, rotation, xLabel, yLabel, xCategoryType, xCategoryArray, tooltipGrouped, colors])
 * @param data
 * @param element
 * @param type
 * @param options
 * @constructor
 */
function C3Charts(data, element, type, options) {

    if (typeof type === 'undefined') {
        type = 'bar';
    }

    if (typeof options === 'undefined'){
        options = {};
    }

    if (typeof options.colors === 'undefined') {
        options.colors = [
            '#c3eb00', '#00d2ff', '#ff7200',  '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#FF0000', '#F97600', '#F6C600', '#60B044'
        ];
    }

    if (typeof options.tooltipGrouped === 'undefined') {
        options.tooltipGrouped = false;
    }

    if (typeof options.yLabel === 'undefined') {
        options.yLabel = "";
    }

    if (typeof options.xLabel === 'undefined') {
        options.xLabel = "";
    }

    if (typeof options.xCategoryArray === 'undefined') {
        options.xCategoryArray = [];
    }

    if (typeof options.xCategoryType === 'undefined') {
        options.xCategoryType = "";
    }

    if (typeof options.rotation === 'undefined') {
        options.rotation = false;
    }

    if (typeof options.donutTitle === 'undefined') {
        options.donutTitle = '';
    }

    if (options.rotation && (options.xLabel || options.yLabel)){
        var tempXLabel = options.xLabel;
        options.xLabel = options.yLabel;
        options.yLabel = tempXLabel;
    }

    var dataObject = {
        columns     : data,
        type        : type,
        onclick: function (d, i) {
            //console.log("onclick", d, i);
        },
        onmouseover: function (d, i) {
            //console.log("onmouseover", d, i);
        },
        onmouseout: function (d, i) {
            //console.log("onmouseout", d, i);
        }
    };

    if (typeof options.dataXName !== 'undefined') {
        dataObject.x = options.dataXName;
    }

    var chart = c3.generate({
        bindto: element,
        data: dataObject,
        donut: {
            title: options.donutTitle
        },
        legend: {
            show: (options.hideLegend === undefined ? true : false),
            position: (options.legendPosition === undefined ? 'bottom' : 'right'),
        },
        axis: {
            rotated: options.rotation,
            x: {
                //label: options.xLabel,
                type: options.xCategoryType,
                categories: options.xCategoryArray,
/*
                tick: {
                    format: '%Y-%m-%d'
                },
*/
                //max : options.axisXmax
            },
            y: {
                label: options.yLabel,
                max : options.axisYmax
            }
        },
        tooltip: {
            format: {
                value: function (value, ratio, id, index) { return value; }
            },
            grouped: options.tooltipGrouped
        },
        color: {
            pattern: options.colors // the three color levels for the percentage values.
            /*threshold: {
                unit: unit, // percentage is default
                max: max, // 100 is default
                values: ticks
            }*/
        },
        size: {
            height: options.height,
            width: options.width
        }
    });
}


function EncryptText(PlainText, Key) {
    var to_enc = PlainText.toString().replace(/^\n+/, "").replace
    (/\n+$/, "");  //Nozel: remove \n

    var xor_key=Key;
    var the_res="";//the result will be here
    for(i=0;i<to_enc.length;++i)
    {
        ////the_res += String.fromCharCode((xor_key ^ to_enc.charCodeAt(i)));
        //Nozel:  Xor Cipher .
        //But encoded characters are not always allowed in http headers

        if (to_enc.charCodeAt(i) <= 32) {
            //Keep c as it is
            the_res += String.fromCharCode((to_enc.charCodeAt(i))); //Nozel: Bypass
            //Invalid characters which are not supported in Http headers
        }
        else {
            the_res += String.fromCharCode
            ((to_enc.charCodeAt(i)) - Key); //Nozel: Normal substitution Cipher
        }
    }
    return(the_res);
}

function DecryptText(CipherText, Key) {
    var to_dec = CipherText;
    var xor_key = Key;
    var PlainText = "";
    for (i = 0; i < to_dec.length; i++) {

        ///// PlainText += String.fromCharCode((xor_key ^ to_dec.charCodeAt(i)));
        //Nozel:  Xor Cipher . But encoded characters are not always allowed in HTTP headers

        if (to_dec.charCodeAt(i) <= 32) {
            //Keep c as it is
            PlainText += String.fromCharCode((to_dec.charCodeAt(i)));
            //Nozel:   Bypass Invalid characters which are not supported in HTTP headers
        }
        else {
            PlainText += String.fromCharCode
            ((to_dec.charCodeAt(i)) + Key);  //Nozel:   Normal substitution Cipher
        }
    }
    return (PlainText);
}
