$(function () {
    var DEPARTURE_SERVICE = "departure_service",
        ARRIVAL_SERVICE = "arrival_service",
        TURNAROUND_SERVICE = "turnaround_service",
        inputDateFormat = "YYYY-MM-DD HH:mm:ss",
        EMPTY_DATE = "0000-00-00",
        EMPTY_TIME = "00:00:00",
        EMPTY_DATETIME = "0000-00-00 00:00:00",

        DEPARTURE = "DEPARTURE",
        ARRIVAL = "ARRIVAL",
        currentFlightType = 0,
        currentFlightID = 0,
        lastMessageID = 0,
        firstMessageID = 0,
        initialPictureIDs = [],
        noMorePrevMessages = false,
        picTab = $("#pic_tab"),
        trcTab = $("#trc_tab"),
        cknTab = $("#ckn_tab"),
        form_aircraft_id = $("#form_aircraft_id"),

        flt_dep_arr_time, flt_ac_type, flt_ac, flt_cfg, flt_bkd, flt_act,
        fltClickInstance = false,
        flightRows = $("tr.flight_row"),

        staffFlightID = $("#staff_flight_id"),
        refreshFlightID = $("#refresh_flight_id"),
        message_side = 'right',

        trcSuccessMessage = $("#trc_success_message"),
        trcFailureMessage = $("#trc_failure_message"),

        checkinSuccessMessage = $("#checkin_success_message"),
        checkinFailureMessage = $("#checkin_failure_message"),

        notifiedMessages = [],

        MVT = 'MVT',
        LDM = 'LDM',
        LIR = 'LIR',
        LDS = 'LDS',
        NOT = 'NOT',
        CPM = 'CPM',
        CAL = 'CAL',
        PSM = 'PSM',
        PTM = 'PTM',
        SOD = 'SOD',

        TAB_GENERAL = "general",
        TAB_MVT = "mvt",
        TAB_LDM = "ldm",
        TAB_LIR = "lir",
        TAB_LDS = "lds",
        TAB_NOT = "not",
        TAB_CPM = "cpm",
        TAB_CAL = "cal",
        TAB_PSM = "psm",
        TAB_PTM = "ptm",
        TAB_SOD = "sod",
        TAB_TRC = "trc",
        MESSAGE_INFO = "info",
        LOADSHEET = "L O A D S H E E T",
        LOADSHEET_FINAL = "LOADSHEET FINAL",
        ajax_loading_flight_info = $('<span class="ajax-loading-flight-info" style="display: block; "></span>');


    var CHAT_STAFF_TAB = "staffTab",
        all_tabs = [
            MVT,
            LDM,
            LIR,
            LDS,
            NOT,
            CPM,
            CAL,
            PSM,
            PTM,
            SOD,
        ],
        departure_mvt_container = $("#departure-mvt-container"),
        arrival_mvt_container = $("#arrival-mvt-container"),
        message_container = $(".message-container"),
        trc_container = $("#trc_container"),
        staffTableBody = $("#staff-table-body"),
        staffSubmitContainer = $("#staff-submit-container"),
        windowFocused = true;

    var notificationPermission = typeof Notification !== "undefined" && Notification.permission == "granted",
        staffContainer = $("#staff-container"),
        staffForm = $("#formStaff"),
        staffSubmit = $("#staff_submit"),
        staffSuccessMessage = $("#staff_success_message"),
        staffFailureMessage = $("#staff_failure_message"),
        staffTabContainer = $("#staff-tab");

    var Message;

    var topMenu = $("#top_menu"),
        // Timer
        countdown_timer = $("#countdown_timer"),

        flight_title = $("#flight_title"),
        flight_subtitle = $("#flight_subtitle"),
        flight_tracker = $("#flight_tracker"),
        parent_flight = $("#parent_flight"),
        flight_radar = $("#flight_radar"),
        messages = $('ul.messages'),
        message_input = $('#message_input'),
        parse_message_checkbox = $('#parse_message_checkbox'),
        send_message_panel = $('#send_message_panel'),
        send_btn = $('#send'),
        show_flt_details_btn = $('#show_flt_details_btn'),

        uploadPictureForm = $('#uploadPictureForm'),
        btnUploadPhoto = $('#btnUploadPhoto'),
        upload_flight_id = $('#upload_flight_id'),
        upload_flight_ids = $('#upload_flight_ids'),
        pictureNotes = $('#pictureNotes'),
        uploadKey = $('#upload_key'),
        uploadMessage = $('#upload_message'),
        uploadLastMessageID = $('#upload_last_message_id'),

        table_uld_and_notoc_fields = $('.table_uld_and_notoc_fields'),
        table_rmks_and_pax_fields = $('.table_rmks_and_pax_fields'),
        table_pts = $('.table_pts'),
        table_fhr = $('.table_fhr'),

        gate_info = $("#gate_info"),
        occForm = $("#occForm"),
        trcForm = $("#trcForm"),
        checkInForm = $("#checkInForm"),
        ptsForm = $("#ptsForm"),
        fhrForm = $("#fhrForm"),
        arrForm = $("#arrForm"),
        ssrForm = $("#ssrForm"),

        flightsTable = $(".flightsTable"),
        flightsTab = $("#flightsTab"),
        show_hide_flights = $("#show_hide_flights"),
        flt_pictures_container = $("#flt_pictures_container"),
        flight_uld_table = $("#flt_uld_table");

    var message_template_same = $('.message_template_same'),
        message_template = $('.message_template'),
        message_template_no_more_messages = $('.message_template_no_more_messages');

    var loading = $('<span class="ajax-loading" style="display: block;"></span>'),
        instance = false,
        sendInstance = false;

    var flt_pax_a = $("#flt_pax_a"),
        flt_pax_c = $("#flt_pax_c"),
        flt_pax_y = $("#flt_pax_y"),
        flt_pax_jmp = $("#flt_pax_jmp"),

        flt_pax_adult = $("#flt_pax_adult"),
        flt_pax_male = $("#flt_pax_male"),
        flt_pax_female = $("#flt_pax_female"),
        flt_pax_child = $("#flt_pax_child"),
        flt_pax_inf = $("#flt_pax_inf"),

        flt_trc_rmks = $("#flt_trc_rmks"),
        flt_ckin_ctr = $("#flt_ckin_ctr"),
        flt_ckin_num = $("#flt_ckin_num"),
        flt_materials_secured_ckin = $("#flt_materials_secured_ckin"),
        flt_materials_secured_gate = $("#flt_materials_secured_gate"),

        flt_lofo_staff = $("#flt_lofo_staff"),
        flt_lofo_rmks = $("#flt_lofo_rmks"),
        flt_lofo_start = $("#flt_lofo_start"),
        flt_lofo_end = $("#flt_lofo_end"),
        flt_mhb_ahl = $("#flt_mhb_ahl"),
        flt_mhb_ohd = $("#flt_mhb_ohd"),
        flt_mhb_dpr = $("#flt_mhb_dpr"),

        flt_trc = $("#flt_trc"),
        flt_trc_crew = $("#flt_trc_crew"),
        flt_trc_capt = $("#flt_trc_capt"),
        flt_dow = $("#flt_dow"),
        flt_doi = $("#flt_doi"),
        flt_mtow = $("#flt_mtow"),
        flt_rtow = $("#flt_rtow"),
        flt_tof = $("#flt_tof"),
        flt_trip = $("#flt_trip"),
        flt_eet = $("#flt_eet"),
        flt_taxi = $("#flt_taxi"),
        flt_block = $("#flt_block"),
        flt_altn = $("#flt_altn"),

        flt_ckin_staff = $("#flt_ckin_staff"),
        flt_gate_staff = $("#flt_gate_staff"),
        flt_gate_spvr = $("#flt_gate_spvr"),
        flt_specials = $("#flt_specials"),

        flt_spvr = $("#flt_spvr"),
        flt_spvr_rmks = $("#flt_spvr_rmks"),
        //flt_ckin_rmks = $("#flt_ckin_rmks"),

        flt_seat_a = $("#flt_seat_a"),
        flt_seat_b = $("#flt_seat_b"),
        flt_seat_c = $("#flt_seat_c"),
        flt_seat_d = $("#flt_seat_d"),
        flt_seat_e = $("#flt_seat_e"),

        flt_chkd_bag_pcs = $("#flt_chkd_bag_pcs"),
        flt_chkd_bag_wt = $("#flt_chkd_bag_wt"),

        flt_gate_bag_pcs = $("#flt_gate_bag_pcs"),
        flt_gate_bag_wt = $("#flt_gate_bag_wt");

    var REFRESH_1SEC = 1000,
        REFRESH_2SEC = 2000,
        REFRESH_3SEC = 3000,
        REFRESH_4SEC = 4000,
        REFRESH_5SEC = 5000,
        REFRESH_6SEC = 6000,
        REFRESH_7SEC = 7000,
        REFRESH_8SEC = 8000,
        REFRESH_9SEC = 9000,
        REFRESH_10SEC = 10000,
        REFRESH_12SEC = 12000,
        REFRESH_15SEC = 15000,
        REFRESH_20SEC = 20000,
        REFRESH_25SEC = 25000,
        REFRESH_30SEC = 30000,

        REFRESH_35SEC = 35000,
        REFRESH_40SEC = 40000,
        REFRESH_45SEC = 45000,
        REFRESH_50SEC = 50000,
        REFRESH_55SEC = 55000,
        REFRESH_1MIN = 60000,
        REFRESH_1MIN10SEC = 70000,
        REFRESH_1MIN20SEC = 80000,
        REFRESH_1MIN30SEC = 90000,
        REFRESH_1MIN40SEC = 100000,
        REFRESH_1MIN50SEC = 110000,
        REFRESH_2MIN = 120000,
        REFRESH_2MIN10SEC = 130000,
        REFRESH_2MIN20SEC = 140000,
        REFRESH_2MIN30SEC = 150000,
        REFRESH_2MIN40SEC = 160000,
        REFRESH_2MIN50SEC = 170000,
        REFRESH_3MIN = 180000,
        REFRESH_3MIN10SEC = 190000,
        REFRESH_3MIN20SEC = 200000,
        REFRESH_3MIN30SEC = 210000,
        REFRESH_4MIN = 240000,
        REFRESH_5MIN = 300000;

    var timeIntervals = [
        REFRESH_3SEC,
        //REFRESH_4SEC,
        REFRESH_6SEC,
        //REFRESH_8SEC,
        REFRESH_9SEC,
        REFRESH_12SEC,
        REFRESH_15SEC,
        REFRESH_20SEC,
        REFRESH_30SEC,
        REFRESH_40SEC,
        REFRESH_50SEC,
        REFRESH_1MIN,
        REFRESH_1MIN10SEC,
        REFRESH_1MIN20SEC,
        REFRESH_1MIN30SEC,
        REFRESH_1MIN40SEC,
        REFRESH_1MIN50SEC,
        REFRESH_2MIN,
        REFRESH_2MIN10SEC,
        REFRESH_2MIN20SEC,
        REFRESH_2MIN30SEC,
        REFRESH_2MIN40SEC,
        REFRESH_2MIN50SEC,
        REFRESH_3MIN,
        //REFRESH_3MIN10SEC,
        //REFRESH_3MIN20SEC,
        //REFRESH_3MIN30SEC,

        //REFRESH_10SEC,
        //REFRESH_20SEC,
        //REFRESH_30SEC,
        //REFRESH_40SEC,
        //REFRESH_50SEC,
        //REFRESH_1MIN,
        //REFRESH_1MIN10SEC,
        //REFRESH_1MIN20SEC,
        //REFRESH_1MIN30SEC,
        //REFRESH_2MIN,
        //REFRESH_2MIN30SEC,
    ];

    var prevUserID = 0,
        occSuccessMessage = $("#occ_success_message"),
        occFailureMessage = $("#occ_failure_message"),
        ptsSuccessMessage = $("#pts_success_message"),
        ptsFailureMessage = $("#pts_failure_message"),
        arrSuccessMessage = $("#arr_success_message"),
        arrFailureMessage = $("#arr_failure_message"),
        ssrSuccessMessage = $("#ssr_success_message"),
        ssrFailureMessage = $("#ssr_failure_message"),
        fhrSuccessMessage = $("#fhr_success_message"),
        fhrFailureMessage = $("#fhr_failure_message"),
        picture_notes_modal = $("#picture_notes"),
        currentInterval = REFRESH_1SEC,
        DATETIME_FORMAT = "MMM DD, HH:mm";

    /*
     $('#btn_upload_picture').click(function(){
     $('#file_input').click();
     });

     $('#file_input').change(function() {
     picture_notes_modal.show();

     if ($(this).val()){
     $('#picture_notes').show(); //.modal('toggle');
     }
     });

     btnUploadPhoto.click(function(){
     uploadPicture();

     picture_notes_modal.hide();

     return false;
     });
     */

    ApplyDateFormatToInputs($("#arrForm"));


    Dropzone.autoDiscover = false;
    var fileDropzone = new Dropzone('#fileDropzone', {
        url: uploadPictureForm.attr("action"),
        maxFilesize: 35,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
        },
        acceptedFiles: ".jpeg,.jpg,.png,.gif,.pdf",
        timeout: 50000,
        resizeWidth: 1024,
        thumbnailHeight: 150,
        maxFiles: 3,
        addRemoveLinks: false,
        accept: function (file, done) {
            done();
        },
        init: function () {
            this.on("maxfilesexceeded", function (file) {
                this.removeAllFiles();
                this.addFile(file);
            });
        },
        sending: function (file, xhr, formData) {
            var picData = setFormDataForPicture();

            if (picData && Object.keys(picData).length) {
                $.each(picData, function (i, item) {
                    //console.log(i + " - " + item);
                    formData.append(i, item);
                });
            }
        },
        success: function (file, response) {
            var flightID = topMenu.data("flight_id");
            fillMessages(response, flightID, true, true);
        },
        error: function (file, response) {
            sendInstance = false;
            instance = false;
            //return false;
        }
    });

    $(".close-modal").click(function () {
        picture_notes_modal.hide();

        fileDropzone.removeAllFiles(true);
        // autoLoadMessages();
    });

    $('#btn_upload_picture').click(function () {
        picture_notes_modal.show();
    });

    $('#file_input').change(function () {
        if ($(this).val()) {
            $('#picture_notes').show(); //.modal('toggle');
        }
    });

    function setFormDataForPicture() {
        var _parent = $(this).parents("form"), flightID = topMenu.data("flight_id");

        var empty = false;
        var images = _parent.find("input[type=file]");
        images.each(function () {
            if (!$(this).val()) {
                empty = true;
                return false;
            }
        });

        var selects = _parent.find("select");
        selects.each(function () {
            if (!$(this).val()) {
                empty = true;
                return false;
            }
        });

        if (!flightID || empty) { // && isBaggageFieldsEmpty()) {
            return false;
        }

        // Save
        if (sendInstance) {
            return false;
        }

        sendInstance = true;
        instance = true;

        // Get text
        var text = message_input.val();
        var parse_message = parse_message_checkbox.is(":checked");

        // Empty value
        message_input.val("");
        parse_message_checkbox.prop("checked", false);

        var key = ((flightID in keys) && keys[flightID] ? keys[flightID] : false);

        if (!key) {
            key = generateRandomString();
            keys[flightID] = preK + key + postK;
        }

        var uploadDATA = {};

        uploadMessage.val("");
        if (text.trim()) {
            var encrypted = CryptoJS.AES.encrypt(text, keys[flightID]);
            // var decrypted = CryptoJS.AES.decrypt(encrypted.toString(), key);
            // console.log(decrypted.toString(CryptoJS.enc.Utf8));
            uploadMessage.val(encrypted.toString());

            // Message
            uploadDATA["message"] = encrypted.toString();
            uploadDATA["parse_message"] = parse_message ? 1 : 0;
            if (parse_message) {
                uploadDATA["msg"] = text;
            }
        }

        // Flight ID
        uploadDATA["picture_notes"] = pictureNotes.val();

        // Flight ID
        upload_flight_id.val(flightID);
        uploadDATA["flight_id"] = flightID;

        // Flight IDs
        upload_flight_ids.val(flightIDs);
        uploadDATA["flight_ids"] = flightIDs;

        // Key
        uploadKey.val(key);
        uploadDATA["key"] = key;

        // Last message ID is sent
        if (lastMessageID) {
            // Last Msg ID
            uploadLastMessageID.val(lastMessageID);
            uploadDATA["last_message_id"] = lastMessageID;
        }

        return uploadDATA;
    }


    btnUploadPhoto.click(function () {
        uploadPicture();

        picture_notes_modal.hide();

        return false;
    });


    function uploadPicture() {
        var _parent = $(this).parents("form"), flightID = topMenu.data("flight_id");

        var empty = false;
        var images = _parent.find("input[type=file]");
        images.each(function () {
            if (!$(this).val()) {
                empty = true;
                return;
            }
        });

        var selects = _parent.find("select");
        selects.each(function () {
            if (!$(this).val()) {
                empty = true;
                return;
            }
        });

        if (!flightID || empty) { // && isBaggageFieldsEmpty()) {
            return false;
        }

        // Save
        if (sendInstance) {
            return false;
        }

        sendInstance = true;
        instance = true;

        // Get text
        var text = message_input.val();
        var parse_message = parse_message_checkbox.is(":checked");

        // Empty value
        message_input.val("");
        parse_message_checkbox.prop("checked", false);

        var key = ((flightID in keys) && keys[flightID] ? keys[flightID] : false);

        if (!key) {
            key = generateRandomString();
            keys[flightID] = preK + key + postK;
        }

        uploadMessage.val("");
        if (text.trim()) {
            var encrypted = CryptoJS.AES.encrypt(text, keys[flightID]);
            // var decrypted = CryptoJS.AES.decrypt(encrypted.toString(), key);
            // console.log(decrypted.toString(CryptoJS.enc.Utf8));
            uploadMessage.val(encrypted.toString());
        }

        upload_flight_id.val(flightID);
        upload_flight_ids.val(flightIDs);
        uploadKey.val(key);

        // Last message ID is sent
        if (lastMessageID) {
            uploadLastMessageID.val(lastMessageID);
        }

        var formdata = false;
        if (window.FormData) {
            formdata = new FormData(uploadPictureForm[0]);
        }

        var request = $.ajax({
            headers: {
                'x-csrf-token': uploadPictureForm.find('input[name=_token]').val()
            },
            //contentType : 'multipart/form-data',
            timeout: 150000,
            cache: false,
            contentType: false,
            processData: false,
            type: "POST",
            url: baseUrl + "/flight-com/upload-picture",
            data: formdata ? formdata : uploadPictureForm.serialize(),
            //dataType: "json",
        });

        request.always(function () {

        });

        request.fail(function () {
            sendInstance = false;
            instance = false;
        });

        request.success(function (data) {
            fillMessages(data, flightID, true, true);
        });

        ///uploadPictureForm.submit();
        return false;
    }

    // request permission on page load
    document.addEventListener('DOMContentLoaded', function () {
        if (!Notification) {
            alert('Desktop notifications not available in your browser. Try Chromium.');
            return;
        }

        if (Notification.permission !== "granted")
            Notification.requestPermission();
    });

    function onGranted() {
    }

    function onDenied() {
    }

    $(document).on("click", "a.show-msg", function () {
        var _this = $(this), par = _this.parent(),
            msgTxt = par.find(".message-text");

        if (!msgTxt.hasClass("deleted")) {
            return;
        }

        msgTxt.removeClass("deleted");
        msgTxt.addClass("display-message");
        msgTxt.text(msgTxt.attr("data-msg"));

        par.find(".message-details-container").show();
        //par.find("a.crud").remove();

    });

    $(document).on("click", "a.crud", function () {
        var _this = $(this);

        var isAdmin = confirm("Are you sure you want to delete the message?");

        if (!isAdmin) {
            return;
        }

        var messageID = _this.data("id");
        // console.log("DELETE MSG ID : " + messageID);

        var request = $.ajax({
            headers: {
                'x-csrf-token': uploadPictureForm.find('input[name=_token]').val()
            },
            url: baseUrl + "/flight-com/delete-message",
            type: "POST",
            dataType: "json",
            data: {
                message_id: messageID
            }
        });

        request.always(function () {

        });

        request.fail(function () {
        });

        request.success(function () {
            var par = _this.parent();
            // Delete
            deleteMessage(par, "You deleted a message");
        });

    });

    function deleteMessage(par, txt) {
        if (!par.length) {
            return;
        }

        var msgTxt = par.find(".message-text");

        if (msgTxt.hasClass("deleted") || msgTxt.hasClass("display-message")) {
            return;
        }

        if (!msgTxt.attr("data-msg")) {
            msgTxt.attr("data-msg", msgTxt.text());
        }

        msgTxt.addClass("deleted").text(txt);
        par.find(".message-details-container").hide();

        var timestampObj = par.find("span.timestamp");
        if (sprAdm && !par.find("a.show-msg").length) {
            timestampObj.after("<a class='show-msg'><i class='fa fa-eye' /></a>");
        }
        par.find("a.crud").remove();
    }

    function markDeletedMessage(msgs) {
        var par, txt;

        $.each(msgs, function (id, uID) {
            par = messages.find("li[data-m=" + id + "]");
            txt = /* par.hasClass("left") || */ !uID || uID == userID ? "You deleted a message" : "Message deleted";
            // Delete
            deleteMessage(par, txt);
        });
    }

    Message = function (arg) {

        this.firstMessage = false;

        if (arg.firstMessage) {
            this.firstMessage = true;
        } else {
            this.text = arg.text,
                this.details = arg.details,
                this.message_side = arg.message_side;
            this.same_user_message = arg.same_user_message;

            var serviceType, spanType, spanClass;
            this.flight_staff = "";
            if (arg.details.flight_staff && arg.details.flight_staff.length) {
                var table = "<table class='uld_table'>" +
                    "<tr>" +
                    "<td>SLA</td>" +
                    "<td>Staff</td>" +
                    "<td>Start Time</td>" +
                    "<td>Release Time</td>" +
                    "</tr>";

                var repTime, relTime;
                $.each(arg.details.flight_staff, function (i, each) {
                    console.log(each)

                    switch (each.service_type) {
                        case ARRIVAL_SERVICE:
                            spanClass = "label-success";
                            spanType = "<span class='label label-success'>ARRIVAL</span>";
                            break;

                        case DEPARTURE_SERVICE:
                            spanClass = "label-primary";
                            spanType = "<span class='label label-primary'>DEPARTURE</span>";
                            break;

                        case TURNAROUND_SERVICE:
                            spanClass = "label-warning";
                            spanType = "<span class='label label-warning'>TURNAROUND</span>";
                            break;
                    }

                    if (each.deleted_at) {
                        table += "<tr>" +
                            "<td><span class='label font-sm " + spanClass + "'>" + each.service_name + "</span></td>" +
                            "<td>" + (each.location ? "<strong>" + each.location.iata + "</strong><br>" : "") + each.user_name + "</td>" +
                            "<td class='flt_val color-red'>REMOVED</td>" +
                            "</tr>";
                    } else {

                        repTime = each.planned_report_time ? moment(each.planned_report_time).format(DATETIME_FORMAT) + " <span class='label label-success'>PLN</span><br/>" : "";
                        repTime += each.report_time ? moment(each.report_time).format(DATETIME_FORMAT) + " <span class='label label-primary'>ACT</span><br/>" : "";

                        relTime = each.planned_release_time ? moment(each.planned_release_time).format(DATETIME_FORMAT) + " <span class='label label-success'>PLN</span><br/>" : "";
                        relTime += each.release_time ? moment(each.release_time).format(DATETIME_FORMAT) + " <span class='label label-primary'>ACT</span><br/>" : "";

                        table += "<tr>" +
                            "<td><span class='label font-sm " + spanClass + "'>" + each.service_name + "</span></td>" +
                            "<td>" +
                            (each.location ? "<span style='margin-right: 10px;'><strong>" + each.location.iata + "</strong></span>" : "") + spanType + "<br>" +
                            each.user_name +
                            "</td>" +
                            "<td class='flt_val'>" + repTime + "</td>" +
                            "<td class='flt_val'>" + relTime + "</td>" +
                            "</tr>";
                    }

                });

                table += "</table>";

                this.flight_staff = table;
            }

            this.ssr_details = "";
            console.log(arg.details.ssr);
            if (arg.details.ssr) {
                this.ssr_details = "<table class='uld_table'>";
                var ssrList = ["umnr", "vip", "maas"];

                var ssr;
                this.ssr_details += "<tr>";
                for (var n = 0; n < ssrList.length; n++) {
                    ssr = ssrList[n];
                    if (arg.details.ssr[ssr] || arg.details.ssr[ssr] == "0") {
                        this.ssr_details +=
                            "<td>" + ssr.toUpperCase() + ":</td>" +
                            "<td class='flt_val'>" + arg.details.ssr[ssr] + "</td>";
                    }
                }

                this.ssr_details += "</tr>";
                this.ssr_details += "</table>";
            }

            this.pts_details = "";
            if (arg.details.pts && Object.keys(arg.details.pts).length) {
                this.pts_details = "<table class='uld_table'>";

                if (arg.details.pts.lofo_staff) {
                    this.pts_details += "<tr>" +
                        "<td>LOFO STAFF:</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.lofo_staff ? arg.details.pts.lofo_staff : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.lofo_rmks) {
                    this.pts_details += "<tr>" +
                        "<td>LOFO RMKS:</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.lofo_rmks ? arg.details.pts.lofo_rmks : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.lofo_start) {
                    this.pts_details += "<tr>" +
                        "<td>LOFO START TIME:</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.lofo_start ? getSimpleDateTime(arg.details.pts.lofo_start) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.lofo_end) {
                    this.pts_details += "<tr>" +
                        "<td>LOFO END TIME:</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.lofo_end ? getSimpleDateTime(arg.details.pts.lofo_end) : "") + "</td>" +
                        "</tr>";
                }

                // NEW BA Fields
                if (arg.details.pts.jetway_steps) {
                    this.pts_details += "<tr>" +
                        "<td>JETWAY/STEPS</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.jetway_steps ? arg.details.pts.jetway_steps : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.jetway_on) {
                    this.pts_details += "<tr>" +
                        "<td>JETWAY ON</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.jetway_on ? getSimpleTime(arg.details.pts.jetway_on) : "") + "</td>" +
                        "</tr>";
                }

                if (arg.details.pts.first_pax_off) {
                    this.pts_details += "<tr>" +
                        "<td>1ST PAX OFF</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.first_pax_off ? getSimpleTime(arg.details.pts.first_pax_off) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.last_pax_off) {
                    this.pts_details += "<tr>" +
                        "<td>LAST PAX OFF</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.last_pax_off ? getSimpleTime(arg.details.pts.last_pax_off) : "") + "</td>" +
                        "</tr>";
                }
                //
                if ((arg.details.pts.back_steps_used || arg.details.pts.back_steps_used == "0")) {
                    this.pts_details += "<tr>" +
                        "<td>BACK STEPS USED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.back_steps_used ? "YES" : (arg.details.pts.back_steps_used == "0" ? "NO" : "")) + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.cleaners_onboard) {
                    this.pts_details += "<tr>" +
                        "<td>CLEANERS ON BOARD</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.cleaners_onboard ? getSimpleTime(arg.details.pts.cleaners_onboard) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.cleaners_off) {
                    this.pts_details += "<tr>" +
                        "<td>CLEANERS OFF</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.cleaners_off ? getSimpleTime(arg.details.pts.cleaners_off) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.fuelling_started) {
                    this.pts_details += "<tr>" +
                        "<td>FUELLING STARTED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.fuelling_started ? getSimpleTime(arg.details.pts.fuelling_started) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.fuelling_finished) {
                    this.pts_details += "<tr>" +
                        "<td>FUELLING FINISHED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.fuelling_finished ? getSimpleTime(arg.details.pts.fuelling_finished) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.gate_open) {
                    this.pts_details += "<tr>" +
                        "<td>GATE OPEN</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.gate_open ? getSimpleTime(arg.details.pts.gate_open) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.crew_at_gate) {
                    this.pts_details += "<tr>" +
                        "<td>CREW AT GATE</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.crew_at_gate ? getSimpleTime(arg.details.pts.crew_at_gate) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.boarding_start_time) {
                    this.pts_details += "<tr>" +
                        "<td>BOARDING START TIME</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.boarding_start_time ? getSimpleTime(arg.details.pts.boarding_start_time) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.pre_boarding_started) {
                    this.pts_details += "<tr>" +
                        "<td>PRE-BOARDING STARTED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.pre_boarding_started ? getSimpleTime(arg.details.pts.pre_boarding_started) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.first_pax_boarded) {
                    this.pts_details += "<tr>" +
                        "<td>1ST PAX BOARDED AT GATE</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.first_pax_boarded ? getSimpleTime(arg.details.pts.first_pax_boarded) : "") + "</td>" +
                        "</tr>";
                }

                if (arg.details.pts.last_pax_boarded) {
                    this.pts_details += "<tr>" +
                        "<td>LAST PAX BOARDED AT GATE</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.last_pax_boarded ? getSimpleTime(arg.details.pts.last_pax_boarded) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.board_pax) {
                    this.pts_details += "<tr>" +
                        "<td>1ST PAX ON-BOARD</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.board_pax ? getSimpleTime(arg.details.pts.board_pax) : "") + "</td>" +
                        "</tr>";
                }

                if (arg.details.pts.all_pax_onboard) {
                    this.pts_details += "<tr>" +
                        "<td>LAST PAX ON BOARD</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.all_pax_onboard ? getSimpleTime(arg.details.pts.all_pax_onboard) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.accepted_pax) {
                    this.pts_details += "<tr>" +
                        "<td>ACCEPTED PAX</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.accepted_pax ? arg.details.pts.accepted_pax : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.first_bag_loaded) {
                    this.pts_details += "<tr>" +
                        "<td>1ST BAG LOADED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.first_bag_loaded ? getSimpleTime(arg.details.pts.first_bag_loaded) : "") + "</td>" +
                        "</tr>";
                }

                if (arg.details.pts.last_bag_loaded) {
                    this.pts_details += "<tr>" +
                        "<td>LAST BAG LOADED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.last_bag_loaded ? getSimpleTime(arg.details.pts.last_bag_loaded) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.gatebags_collected) {
                    this.pts_details += "<tr>" +
                        "<td>GATEBAGS COLLECTED BY LOADING TEAM</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.gatebags_collected ? getSimpleTime(arg.details.pts.gatebags_collected) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.bag_search_started) {
                    this.pts_details += "<tr>" +
                        "<td>BAG SEARCH STARTED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.bag_search_started ? getSimpleTime(arg.details.pts.bag_search_started) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.bag_search_finished) {
                    this.pts_details += "<tr>" +
                        "<td>BAG SEARCH FINISHED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.bag_search_finished ? getSimpleTime(arg.details.pts.bag_search_finished) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.loadsheet_onboard) {
                    this.pts_details += "<tr>" +
                        "<td>LOADSHEET ONBOARD</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.loadsheet_onboard ? getSimpleTime(arg.details.pts.loadsheet_onboard) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.all_doors_closed) {
                    this.pts_details += "<tr>" +
                        "<td>ALL DOORS CLOSED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.all_doors_closed ? getSimpleTime(arg.details.pts.all_doors_closed) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.jetway_off) {
                    this.pts_details += "<tr>" +
                        "<td>JETWAY/STEPS OFF</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.jetway_off ? getSimpleTime(arg.details.pts.jetway_off) : "") + "</td>" +
                        "</tr>";

                }
                if (arg.details.pts.tug_connected) {
                    this.pts_details += "<tr>" +
                        "<td>TUG CONNECTED</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.tug_connected ? getSimpleTime(arg.details.pts.tug_connected) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.final_walk_around) {
                    this.pts_details += "<tr>" +
                        "<td>FINAL WALK AROUND</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.final_walk_around ? getSimpleTime(arg.details.pts.final_walk_around) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.all_doors_panels_closed) {
                    this.pts_details += "<tr>" +
                        "<td>ALL DOORS & PANELS ARE CLOSED</td>" +
                        "<td class='flt_val'>YES</td>" +
                        "</tr>";
                }
                if (arg.details.pts.pilot_headset) {
                    this.pts_details += "<tr>" +
                        "<td>PILOT HEADSET</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.pilot_headset ? getSimpleTime(arg.details.pts.pilot_headset) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.rtg) {
                    this.pts_details += "<tr>" +
                        "<td>RTG</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.rtg ? getSimpleTime(arg.details.pts.rtg) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.pushback) {
                    this.pts_details += "<tr>" +
                        "<td>PUSHBACK</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.pushback ? getSimpleTime(arg.details.pts.pushback) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.cabin_bags_checkin) {
                    this.pts_details += "<tr>" +
                        "<td>CABIN BAGS AT CHECK-IN	</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.cabin_bags_checkin ? arg.details.pts.cabin_bags_checkin : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.cabin_bags_gate) {
                    this.pts_details += "<tr>" +
                        "<td>CABIN BAGS AT GATE	</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.cabin_bags_gate ? arg.details.pts.cabin_bags_gate : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.ckin_open) {
                    this.pts_details += "<tr>" +
                        "<td>CKIN OPEN</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.ckin_open ? getSimpleTime(arg.details.pts.ckin_open) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.ckin_close) {
                    this.pts_details += "<tr>" +
                        "<td>CKIN CLOSE</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.ckin_close ? getSimpleTime(arg.details.pts.ckin_close) : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.mhb_ahl) {
                    this.pts_details += "<tr>" +
                        "<td>MHB AHL</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.mhb_ahl ? arg.details.pts.mhb_ahl : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.mhb_ohd) {
                    this.pts_details += "<tr>" +
                        "<td>MHB OHD</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.mhb_ohd ? arg.details.pts.mhb_ohd : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.mhb_dpr) {
                    this.pts_details += "<tr>" +
                        "<td>MHB DPR</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.mhb_dpr ? arg.details.pts.mhb_dpr : "") + "</td>" +
                        "</tr>";
                }

                this.pts_details += "</table>";

                // FHR
                this.pts_details += "<table class='uld_table'>";
                if (arg.details.pts.missed_artg) {
                    this.pts_details += "<tr>" +
                        "<td>MISSED ARTG-5 EXPLANATION</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.missed_artg ? arg.details.pts.missed_artg : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.delay) {
                    this.pts_details += "<tr>" +
                        "<td>DELAY EXPLANATION</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.delay ? arg.details.pts.delay : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.ckn) {
                    this.pts_details += "<tr>" +
                        "<td>CHECK-IN/TKTG ISSUES</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.ckn ? arg.details.pts.ckn : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.ramp) {
                    this.pts_details += "<tr>" +
                        "<td>RAMP/CREW/DISRUPTIVE PAX ETC</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.ramp ? arg.details.pts.ramp : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.safety) {
                    this.pts_details += "<tr>" +
                        "<td>SAFETY / SECURITY / SYSTEM ISSUES</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.safety ? arg.details.pts.safety : "") + "</td>" +
                        "</tr>";
                }
                if (arg.details.pts.other) {
                    this.pts_details += "<tr>" +
                        "<td>OTHER</td>" +
                        "<td class='flt_val'>" + (arg.details.pts.other ? arg.details.pts.other : "") + "</td>" +
                        "</tr>";
                }
                this.pts_details += "</table>";

                var values = [];
                var k, prop;
                for (k = 1; k <= 5; k++) {
                    prop = "denied_boarding" + k;
                    if (arg.details.pts[prop]) {
                        values.push(arg.details.pts[prop]);
                    }
                }

                if (values.length) {
                    this.pts_details += "<table class='uld_table'>";

                    this.pts_details += "<tr>" +
                        "<td colspan='2'>INVOL DENIED BOARDING</td>" +
                        "</tr>";

                    for (k = 0; k < values.length; k++) {
                        this.pts_details += "<tr>" +
                            "<td>" + (k + 1) + ":</td>" +
                            "<td class='flt_val'>" + values[k] + "</td>" +
                            "</tr>";
                    }

                    this.pts_details += "</table>";
                }
            }

            this.pax_details = "";
            this.seat_details = "";
            this.baggage_details = "";

            if (arg.details.checkin && Object.keys(arg.details.checkin).length) {

                if (arg.details.checkin.ac || arg.details.checkin.capacity_c || arg.details.checkin.capacity_y ||
                    arg.details.checkin.gate || arg.details.checkin.pos ||
                    arg.details.checkin.pax_a_booked || arg.details.checkin.pax_c_booked || arg.details.checkin.pax_y_booked || arg.details.checkin.pax_inf_booked ||
                    arg.details.checkin.pax_a || arg.details.checkin.pax_c || arg.details.checkin.pax_y || arg.details.checkin.pax_jmp || arg.details.checkin.pax_inf ||
                    arg.details.checkin.pax_adults || arg.details.checkin.pax_m || arg.details.checkin.pax_f || arg.details.checkin.pax_ch) {
                    this.pax_details = "<table class='uld_table'>";

                    if (arg.details.checkin.gate || arg.details.checkin.pos ||
                        arg.details.checkin.ac || arg.details.checkin.capacity_c || arg.details.checkin.capacity_y) {
                        this.pax_details += "<tr>";

                        if (arg.details.checkin.gate || arg.details.checkin.pos) {
                            this.pax_details +=
                                "<td>GATE</td>" +
                                "<td class='flt_val' colspan='2'>" + (arg.details.checkin.gate ? arg.details.checkin.gate : "") + "</td>" +
                                "<td>POS</td>" +
                                "<td class='flt_val' colspan='2'>" + (arg.details.checkin.pos ? arg.details.checkin.pos : "") + "</td>";
                        }

                        if (arg.details.checkin.ac || arg.details.checkin.capacity_c || arg.details.checkin.capacity_y) {
                            this.pax_details +=
                                "<td>A/C</td>" +
                                "<td class='flt_val' colspan='2'>" + (arg.details.checkin.ac ? arg.details.checkin.ac : "") + "</td>" +
                                "<td>CFG</td>" +
                                "<td>C</td>" +
                                "<td class='flt_val' colspan='2'>" + (arg.details.checkin.capacity_c ? arg.details.checkin.capacity_c : "") + "</td>" +
                                "<td>Y</td>" +
                                "<td class='flt_val' colspan='2'>" + (arg.details.checkin.capacity_y ? arg.details.checkin.capacity_y : "") + "</td>";
                        }

                        this.pax_details += "</tr>";
                    }

                    if (arg.details.checkin.pax_a_booked || arg.details.checkin.pax_c_booked || arg.details.checkin.pax_y_booked || arg.details.checkin.pax_inf_booked) {
                        this.pax_details += "<tr>" +
                            "<td>PAX BKD</td>" +
                            //"<td>F</td>" +
                            //"<td class='flt_val'>" + (arg.details.checkin.pax_a_booked ? arg.details.checkin.pax_a_booked : "") + "</td>" +
                            "<td>C</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_c_booked ? arg.details.checkin.pax_c_booked : "") + "</td>" +
                            "<td>Y</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_y_booked ? arg.details.checkin.pax_y_booked : "") + "</td>" +
                            "<td>INF</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_inf_booked ? arg.details.checkin.pax_inf_booked : "") + "</td>" +
                            "</tr>";
                    }

                    if (arg.details.checkin.pax_a || arg.details.checkin.pax_c || arg.details.checkin.pax_y || arg.details.checkin.pax_jmp || arg.details.checkin.pax_inf) {
                        this.pax_details += "<tr class='border-top'>" +
                            "<td>PAX ACT</td>" +
                            //"<td>F</td>" +
                            //"<td class='flt_val'>" + (arg.details.checkin.pax_a ? arg.details.checkin.pax_a : "") + "</td>" +
                            "<td>C</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_c ? arg.details.checkin.pax_c : "") + "</td>" +
                            "<td>Y</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_y ? arg.details.checkin.pax_y : "") + "</td>" +
                            "<td>JMP</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_jmp ? arg.details.checkin.pax_jmp : "") + "</td>" +
                            "<td>INF</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_inf ? arg.details.checkin.pax_inf : "") + "</td>" +
                            "</tr>";
                    }

                    if (arg.details.checkin.pax_adults || arg.details.checkin.pax_m || arg.details.checkin.pax_f || arg.details.checkin.pax_ch) {
                        this.pax_details += "<tr class='border-top'>" +
                            "<td>PAX ACT</td>" +
                            "<td>A</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_adults ? arg.details.checkin.pax_adults : "") + "</td>" +
                            "<td>M</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_m ? arg.details.checkin.pax_m : "") + "</td>" +
                            "<td>F</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_f ? arg.details.checkin.pax_f : "") + "</td>" +
                            "<td>CH</td>" +
                            "<td class='flt_val'>" + (arg.details.checkin.pax_ch ? arg.details.checkin.pax_ch : "") + "</td>" +
                            "</tr>";
                    }

                    this.pax_details += "</table>";
                }

                if (arg.details.checkin.seat_a || arg.details.checkin.seat_b || arg.details.checkin.seat_c || arg.details.checkin.seat_d || arg.details.checkin.seat_e) {

                    this.seat_details = "<table class='uld_table'>" +
                        "<tr>" +
                        "<td>SEAT AREA</td>" +
                        "<td>0A</td>" +
                        "<td class='flt_val'>" + (arg.details.checkin.seat_a ? arg.details.checkin.seat_a : "") + "</td>" +
                        "<td>0B</td>" +
                        "<td class='flt_val'>" + (arg.details.checkin.seat_b ? arg.details.checkin.seat_b : "") + "</td>" +
                        "<td>0C</td>" +
                        "<td class='flt_val'>" + (arg.details.checkin.seat_c ? arg.details.checkin.seat_c : "") + "</td>" +
                        "<td>0D</td>" +
                        "<td class='flt_val'>" + (arg.details.checkin.seat_d ? arg.details.checkin.seat_d : "") + "</td>" +
                        //"<td>0E</td>" +
                        //"<td class='flt_val'>" + (arg.details.checkin.seat_e ? arg.details.checkin.seat_e : "") + "</td>" +
                        "</tr>" +
                        "</table>";
                }

                this.baggage_details = "<table class='uld_table'>";

                if (arg.details.checkin.chkd_bag_pcs || arg.details.checkin.chkd_bag_wt) {
                    this.baggage_details +=
                        "<tr>" +
                        "<td>CHKD BAGGAGE</td>" +
                        "<td>PCS</td>" +
                        "<td class='flt_val'>" + (arg.details.checkin.chkd_bag_pcs ? arg.details.checkin.chkd_bag_pcs + "</td>" : "") +
                        "<td>WT</td>" +
                        "<td class='flt_val'>" + (arg.details.checkin.chkd_bag_wt ? arg.details.checkin.chkd_bag_wt + "</td>" : "") +
                        "</tr>";
                }

                if (arg.details.checkin.gate_bag_pcs || arg.details.checkin.gate_bag_wt) {
                    this.baggage_details +=
                        "<tr>" +
                        "<td>GATE BAGGAGE</td>" +
                        "<td>PCS</td>" +
                        "<td class='flt_val'>" + (arg.details.checkin.gate_bag_pcs ? arg.details.checkin.gate_bag_pcs + "</td>" : "") +
                        "<td>WT</td>" +
                        "<td class='flt_val'>" + (arg.details.checkin.gate_bag_wt ? arg.details.checkin.gate_bag_wt + "</td>" : "") +
                        "</tr>";
                }

                this.baggage_details += "</table>";

                if (arg.details.checkin.specials) {
                    this.baggage_details +=
                        "<table class='uld_table'>" +
                        "<tr>" +
                        "<td>SPECIALS</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.specials + "</td>" +
                        "</tr>" +
                        "</table>";
                }

            }

            this.rmks = "";
            if (arg.details.checkin && (arg.details.checkin.ckin_num || arg.details.checkin.ckin_ctr || arg.details.checkin.ckin_staff ||
                arg.details.checkin.gate_staff || arg.details.checkin.spvr || arg.details.checkin.spvr_rmks ||
                arg.details.checkin.trc || arg.details.checkin.trc_rmks ||
                arg.details.checkin.crew || arg.details.checkin.capt ||
                arg.details.checkin.dow || arg.details.checkin.doi || arg.details.checkin.mtow || arg.details.checkin.rtow ||
                arg.details.checkin.tof || arg.details.checkin.trip || arg.details.checkin.eet ||
                arg.details.checkin.taxi || arg.details.checkin.block || arg.details.checkin.altn ||

                arg.details.checkin.gate_spvr || arg.details.checkin.specials ||
                arg.details.checkin.materials_secured_ckin || arg.details.checkin.materials_secured_gate
            )) {

                this.rmks = "<table class='uld_table'>";

                //
                if (arg.details.checkin.trc) {
                    this.rmks += "<tr>" +
                        "<td>TRC</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.trc + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.trc_rmks) {
                    this.rmks += "<tr>" +
                        "<td>TRC RMKS</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.trc_rmks + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.crew) {
                    this.rmks += "<tr>" +
                        "<td>CREW</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.crew + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.capt) {
                    this.rmks += "<tr>" +
                        "<td>CAPT</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.capt + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.dow) {
                    this.rmks += "<tr>" +
                        "<td>DOW</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.dow + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.doi) {
                    this.rmks += "<tr>" +
                        "<td>DOI</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.doi + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.mtow) {
                    this.rmks += "<tr>" +
                        "<td>MTOW</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.mtow + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.rtow) {
                    this.rmks += "<tr>" +
                        "<td>RTOW</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.rtow + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.tof) {
                    this.rmks += "<tr>" +
                        "<td>TAKE-OFF</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.tof + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.trip) {
                    this.rmks += "<tr>" +
                        "<td>TRIP</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.trip + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.eet) {
                    console.log(arg.details.checkin.eet)
                    this.rmks += "<tr>" +
                        "<td>EET</td>" +
                        "<td class='flt_val'>" + getSimpleTime(arg.details.checkin.eet) + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.taxi) {
                    this.rmks += "<tr>" +
                        "<td>TAXI</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.taxi + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.block) {
                    this.rmks += "<tr>" +
                        "<td>BLOCK</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.block + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.altn) {
                    this.rmks += "<tr>" +
                        "<td>ALTN</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.altn + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.ckin_num) {
                    this.rmks += "<tr>" +
                        "<td>No. Of CKIN Counters</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.ckin_num + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.ckin_ctr) {
                    this.rmks += "<tr>" +
                        "<td>CKIN CTR</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.ckin_ctr + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.materials_secured_ckin) {
                    this.rmks += "<tr>" +
                        "<td>ALL MATERIALS SECURED AT CKIN</td>" +
                        "<td class='flt_val'>YES</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.materials_secured_gate) {
                    this.rmks += "<tr>" +
                        "<td>ALL MATERIALS SECURED AT GATE</td>" +
                        "<td class='flt_val'>YES</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.ckin_staff) {
                    this.rmks += "<tr>" +
                        "<td>CKIN STAFF</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.ckin_staff + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.gate_staff) {
                    this.rmks += "<tr>" +
                        "<td>GATE STAFF</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.gate_staff + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.gate_spvr) {
                    this.rmks += "<tr>" +
                        "<td>GATE SPVR</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.gate_spvr + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.spvr) {
                    this.rmks += "<tr>" +
                        "<td>SPVR</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.spvr + "</td>" +
                        "<tr>";
                }
                if (arg.details.checkin.spvr_rmks) {
                    this.rmks += "<tr>" +
                        "<td>SPVR RMKS</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.spvr_rmks + "</td>" +
                        "<tr>";
                }
                // Not USED
                if (arg.details.checkin.ckin_rmks) {
                    this.rmks += "<tr>" +
                        "<td>CKIN RMKS</td>" +
                        "<td class='flt_val'>" + arg.details.checkin.ckin_rmks + "</td>" +
                        "<tr>";
                }

                this.rmks += "</table>"
            }

            this.uld_details = "";
            if (arg.details.containers && arg.details.containers.length) {

                table = "<table class='uld_table'>" +
                    "<tr>" +
                    "<td>DEST</td>" +
                    "<td>POS</td>" +
                    "<td>CNT</td>" +
                    "<td>ULD TYPE</td>" +
                    "<td>ULD ID</td>" +
                    "<td>OWNER</td>" +
                    "<td>PCS</td>" +
                    "<td>WT</td>" +
                    "<td>VR</td>" +
                    "<td colspan='2'>NOTOC</td>" +
                    "</tr>";

                $.each(arg.details.containers, function (i, cnt) {
                    if (cnt.remove_uld) {
                        table += "<tr>" +
                            "<td></td>" +
                            "<td class='flt_val'><span class='color-red'>" + cnt.pos + "</span></td>" +
                            "<td colspan='8' class='flt_val'><span class='color-red'>" + cnt.notes + "</span></td>" +
                            "</tr>";
                    } else {
                        table += "<tr>" +
                            "<td class='flt_val'>" + (cnt.dest ? cnt.dest : "") + "</td>" +
                            "<td class='flt_val'>" + cnt.pos + "</td>" +

                            "<td class='flt_val'>" + (cnt.content ? cnt.content : "") + "</td>" +
                            "<td class='flt_val'>" + (cnt.type ? cnt.type : "") + "</td>" +
                            "<td class='flt_val'>" + (cnt.num ? cnt.num : "") + "</td>" +
                            "<td class='flt_val'>" + (cnt.owner ? cnt.owner : "") + "</td>" +

                            "<td class='flt_val'>" + (cnt.pcs ? cnt.pcs : "") + "</td>" +
                            "<td class='flt_val'>" + (cnt.wt ? cnt.wt : "") + "</td>" +
                            "<td class='flt_val'>" + (cnt.vr || cnt.vr == "0" ? cnt.vr : "") + "</td>" +
                            "<td class='flt_val'>" + (cnt.notoc ? "YES" : "NO") + "</td>" +
                            "<td class='flt_val'>" + (cnt.notoc_details ? cnt.notoc_details : "") + "</td>" +
                            "</tr>";
                    }
                });

                table += "</table>";

                this.uld_details = table;
            }

            this.pictures = "";
            var size = "";
            if (arg.details.pictures && arg.details.pictures.length) {
                var pics = "", thumb;
                $.each(arg.details.pictures, function (i, img) {
                    size = img.size;

                    if (img.type && img.type.toLowerCase() == "pdf") {
                        thumb = baseUrl + "/assets/flight-com/img/pdf-file.png";
                    } else {
                        if (img.icon) {
                            thumb = baseUrl + "/flight-com/picture/" + img.id + "?type=icon";
                        } else {
                            thumb = baseUrl + "/assets/flight-com/img/image-file.png";
                        }
                    }

                    pics += "<div style='margin: 10px 0;'>" +
                        "<a target='_blank' href='" + baseUrl + "/flight-com/picture/" + img.id + "?type=picture'>" +
                        "<img class='attached_img' src='" + thumb + "' />" +
                        "</a>" +
                        "<div>" +
                        "<p>" + (img.notes != null && img.notes ? img.notes : "") + "</p>" +
                        "</div>" +
                        "</div>";
                });
                this.pictures = pics;
            }

            this.user_thumb = arg.details.user_thumb;
            this.author = "";
            this.time = "";
            this.deleted_time = "";
            this.delete_message = "";
            var author_class = this.message_side === "left" ? "author-left" : "";

            if (arg.user && arg.timestamp) {
                // console.log("ARG USER")
                this.author = "<span class='author " + author_class + "'>" + arg.user + "</span>";
                //this.time = (this.pictures && size ? "<span class='file-size'>(" + size + "M)</span>" : "") + "<span class='timestamp'>" + arg.timestamp + "</span>";
                this.time = (this.details.parse && this.details.parse_result ? "<span class='file-size'>(Message parsed)</span>" : "") + "<span class='timestamp'>" + arg.timestamp + "</span>";
            } else {
                this.author = "<span class='author " + author_class + "'>" + arg.details.user +
                    (arg.details.base ? ", " + arg.details.base : "") + "</span>";
                //this.time = (this.pictures && size ? "<span class='file-size'>(" + size + "M)</span>" : "") + "<span class='timestamp'>" + arg.details.timestamp + "</span>";
                this.time = (this.details.parse && this.details.parse_result ? "<span class='file-size'>(Message parsed)</span>" : "") + "<span class='timestamp'>" + arg.details.timestamp + "</span>";
            }

            if (this.same_user_message) {
                this.author = "";
            }

            // Hide your own name
            if (this.message_side == "right") {
                this.author = "";
                if (this.text || (this.pictures && this.pictures.length)) {
                    // Comment Delete -1-
                    if (messageDeletion) {
                        this.delete_message = "<a class='crud' data-id='" + arg.details.id + "' href='#'><i class='fa fa-trash-o' /></a>";
                    }
                }
            }

            if (sprAdm && (this.text || (this.pictures && this.pictures.length))) {
                // Comment Delete -2-
                if (messageDeletion) {
                    this.delete_message = "<a class='crud' data-id='" + arg.details.id + "' href='#'><i class='fa fa-trash-o' /></a>";
                }
            }
        }

        this.draw = function (_this) {
            return function () {

                var message, content;
                if (_this.firstMessage) {
                    message = $(message_template_no_more_messages.clone().html());
                } else {
                    var msg = _this.text, msgTxtClass = "", dsp = "block", dataOrigMsg = "";

                    if (_this.details.deleted_at) {
                        msgTxtClass = "deleted";
                        dsp = "none";

                        dataOrigMsg = _this.text;
                        msg = !_this.details.updated_by || _this.details.updated_by == userID ? "You deleted a message" : "Message deleted";
                        _this.delete_message = sprAdm ? "<a class='show-msg'><i class='fa fa-eye' /></a>" : "";

                        _this.deleted_time = "<span class='timestamp deleted-timestamp'>Deleted: " + arg.details.deleted_timestamp + "</span>";
                    }


                    /*
                    if (messageDeletion && _this.details.deleted_at) {

                          var delMsg = _this.message_side == "right" ? "You deleted a message" : "Message deleted";

                          content = _this.author
                              + "<div class='clearfix'></div>"
                              + "<p class='message-text deleted'>" + delMsg + "</p>"
                              + "<span class='timestamp'>" +_this.details.timestamp + "</span>";

                          if (_this.same_user_message) {
                              message = $(message_template_same.clone().html());
                          }
                          else {
                              message = $(message_template.clone().html());
                          }

                          message.addClass(_this.message_side).find('.text').html(content);
                      }
                      else {
                      */
                    content = _this.author
                        + "<div class='clearfix'></div>"
                        + "<p class='message-text " + msgTxtClass + "' data-msg='" + dataOrigMsg + "'>" + msg + "</p>"
                        + "<div class='clearfix'></div>"
                        + "<div class='message-details-container' style='display: " + dsp + "'>"
                        + _this.pictures
                        + "</div>"
                        + "<div class='clearfix'></div>"
                        + _this.ssr_details
                        + "<div class='clearfix'></div>"
                        + _this.pts_details
                        + "<div class='clearfix'></div>"
                        + _this.flight_staff
                        + "<div class='clearfix'></div>"
                        + _this.pax_details
                        + "<div class='clearfix'></div>"
                        + _this.seat_details
                        + "<div class='clearfix'></div>"
                        + _this.baggage_details
                        + "<div class='clearfix'></div>"
                        + _this.uld_details
                        + "<div class='clearfix'></div>"
                        + _this.rmks
                        + "<div class='clearfix'></div>"
                        + _this.time
                        + _this.delete_message
                        + "<div class='clearfix'></div>"
                        + (_this.deleted_time ? _this.deleted_time : "");

                    if (_this.same_user_message) {
                        message = $(message_template_same.clone().html());
                    } else {
                        message = $(message_template.clone().html());
                    }

                    message.addClass(_this.message_side).find('.text').html(content);

                    var usrLink = _this.user_thumb ? "/storage/users/" + _this.user_thumb : '/assets/img/default-user-picture-white-64.png';
                    var usrPic = "<img src='" + baseUrl + usrLink + "' />";
                    message.find(".avatar").html(usrPic);

                    message.attr("data-m", _this.details.id);

                    //}
                }

                message.addClass('appeared');

                return message;
                /*
                messages.append(message);
                return setTimeout(function () {
                    return message.addClass('appeared');
                }, 0);
                */
            };
        }(this);
        return this;
    };

    $('.position-relative :input').on('keydown focus', function () {
        if ($(this).val().length > 0) {
            $(this).parent().nextAll('.form-clear').removeClass('d-none');
        }
    }).on('change paste keyup', function () {
        if ($(this).val().length === 0) {
            $(this).parent().nextAll('.form-clear').addClass('d-none');
        }
    });
    $('.form-clear').on('click', function () {
        $(this).addClass('d-none').prev().find(':input').val('');
    });

    function Apply_DateFormat() {
        $(document).find('.dateFrom, .dateTo, .datepicker').datetimepicker({
            format: 'Y-m-d',
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            timepicker: false
        });

        $(document).find('.datepicker_current').datetimepicker({
            format: 'Y-m-d',
            closeOnDateSelect: true,
            minDate: new Date(),
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            timepicker: false
        });

        $(document).find(".timepicker").timepicki({
            //increase_direction: 'up',
            //custom_classes: '',
            min_hour_value: 0,
            max_hour_value: 23,
            show_meridian: false,
            step_size_hours: '1',
            step_size_minutes: '1',
            overflow_minutes: false,
            disable_keyboard_mobile: false,
            reset: false,
            on_change: null,
            input_writable: false
        });

        /*
         $(document).find('.timepicker').timepicker({
         'timeFormat': 'HH:mm',
         interval: 1,
         minTime: '00:00',
         maxTime: '23:59',
         //defaultTime: new Date($.now()),
         startTime: new Date($.now()),
         dynamic: true,
         dropdown: true,
         scrollbar: true
         //closeOnDateSelect: true,
         //yearEnd: parseInt(new Date().getFullYear() + 2),
         });
         */
    }

    // Action
    $("#main-tabs").tabs();

    Apply_DateFormat();

    function autoLoadMessages() {

        // IF env NOT in production -> stop
        console.log(envProduction)
        if (!envProduction && debugError){
            return;
        }

        var flightID = topMenu.data("flight_id");

        if (!flightID) {

            unseenMessages();

            return;
        }

        loadChatMessages(flightID);
    }

    function resetInterval() {
        currentInterval = timeIntervals[0];
    }

    function increaseInterval() {
        try {
            var i = timeIntervals.indexOf(currentInterval);

            // Check
            if (i == -1 || !((i + 1) in timeIntervals)) {
                resetInterval();
            } else {
                currentInterval = timeIntervals[i + 1];
            }
        } catch (e) {
            resetInterval();
        }
    }

    /*
    show_hide_flights.click(function () {
        // Reset Flight Chat

        // resetFlightChat();

        //alert("RESET FINISHED. Flight ID" + currentFlightID)
    });
    */

    $("td.flight-box").on('click', '*', function () {
        var flightID = $(this).parents("tr").data("flight_id");

        flightClicked(flightID);
    });

    $(document).on('click', '.parent-flight', function () {
        var flightID = $(this).data("flight_id"),
            url = $(this).data('url'),
            parentID = $(this).data("parent_id");

        if (url) {
            return true;
        }

        flightClicked(parentID);
    });

    function flightClicked(flightID) {

        if (fltClickInstance) {
            // alert("INST = true")
            return;
        }

        fltClickInstance = true;

        var _tr = $(".flight_row[data-flight_id=" + flightID + "]"),
            fn = _tr.data("fn"), sector = _tr.data("sector"), remark = _tr.data("remark"),
            flt_type = _tr.data("flt_type"),
            dep = _tr.data("dep"), arr = _tr.data("arr"), fltRadarLink = _tr.data("flight_radar"),

            _flt_ac_type = _tr.data("flt_ac_type"),
            _flt_ac = _tr.data("flt_ac"),
            _flt_cfg = _tr.data("flt_cfg"),
            _flt_bkd = _tr.data("flt_bkd"),
            _flt_act = _tr.data("flt_act"),
            _flt_dep_details = _tr.data("flt_dep_details"),
            _flt_arr_details = _tr.data("flt_arr_details"),
            _flt_parent_id = _tr.data("parent_id"),
            _flt_child_id = _tr.data("child_id"),
            _parent_tr,
            _flt_parent_data = "";

        console.log("Found row with same ID: " + _tr.length)

        if (_flt_parent_id) {
            _parent_tr = $(".flight_row[data-flight_id=" + _flt_parent_id + "]");
            if (_parent_tr && _parent_tr.length > 0) {
                _parent_tr.data("parent_id", flightID);
                _flt_parent_data = "<a data-flight_id='" + flightID + "' data-parent_id='" + _flt_parent_id + "' class='parent-flight'>"
                    + (flt_type === "DEPARTURE" ?
                        "<span class='label label-danger' style='font-size: 1em !important;cursor: pointer;'>INBOUND FLIGHT</span>" :
                        "<span class='label label-primary' style='font-size: 1em !important;cursor: pointer;'>OUTBOUND FLIGHT</span>") +
                    "</a>";
            } else {
                _flt_parent_data = "<a data-url=1 href='?date=" + prevDate + "&refresh=1&flight_id=" + _flt_parent_id + "' class='parent-flight'>"
                    + (flt_type === "DEPARTURE" ?
                        "<span class='label label-danger' style='font-size: 1em !important;cursor: pointer;'>INBOUND FLIGHT</span>" :
                        "<span class='label label-primary' style='font-size: 1em !important;cursor: pointer;'>OUTBOUND FLIGHT</span>") +
                    "</a>";
            }
        } else if (_flt_child_id) {
            _flt_parent_data = "<a data-url=1 href='?date=" + nextDate + "&refresh=1&flight_id=" + _flt_child_id + "' class='parent-flight'>"
                + (flt_type === "DEPARTURE" ?
                    "<span class='label label-danger' style='font-size: 1em !important;cursor: pointer;'>INBOUND FLIGHT</span>" :
                    "<span class='label label-primary' style='font-size: 1em !important;cursor: pointer;'>OUTBOUND FLIGHT</span>") +
                "</a>";
        }

        topMenu.data("flight_id", flightID);
        flight_title.html("<a target='_blank' href='" + baseUrl + "/flight-info/handling/" + flightID + "'>" + fn + sector + (remark ? "<span style='font-weight:bold;'> ( " + remark + " )</span>" : "") + "</a>");
        flight_title.attr("data-fn_sector", fn + sector);
        // flight_tracker.html("<a class='module' target='_blank' href='" + baseUrl + "/flight-tracker/" + flightID + "'>Flight Tracker</a>");

        parent_flight.html(_flt_parent_data);
        // flight_radar.html("<a class='module' target='_blank' href='https://www.radarbox24.com/data/flights/" + fltRadarLink + "'>RadarBox</a>");

        staffFlightID.val(flightID);
        refreshFlightID.val(flightID);

        var fontSize = "14px";
        if (isMobile) {
            flightsTab.attr("class", "collapse");
            fontSize = "18px"
        }

        var depArrTiming = flt_type === "DEPARTURE" ? dep : arr;
        // IF Like FRA-DUS -> Both handling flight, show -> DEP INFO
        if (_tr.length == 3) {
            depArrTiming = dep + arr;
        }

        flight_subtitle.html(depArrTiming +
            "<span id='flt_ac_type' style='margin-left: 15px; color: #007bba; font-size: " + fontSize + ";'>" + (_flt_ac_type ? _flt_ac_type + " | " : "") + "</span>" +
            "<span id='flt_ac'  style='color: #007bba; font-size: " + fontSize + ";'>" + (_flt_ac ? _flt_ac + " | " : "") + "</span>" +
            "<span id='flt_cfg' style='color: #007bba; font-size: " + fontSize + ";'>" + (_flt_cfg ? _flt_cfg + " | " : "") + "</span>" +
            "<span id='flt_bkd' style='color: #007bba; font-size: " + fontSize + ";'>" + (_flt_bkd ? _flt_bkd + " | " : "") + "</span>" +
            "<span id='flt_act' style='color: #007bba; font-size: " + fontSize + ";'>" + (_flt_act ? _flt_act : "") + "</span>"
        );
        /*
        if (flt_type == "ARRIVAL"){
            flight_subtitle.html(depArrTiming + "<span id='ac_pax_title' style='margin-left: 15px; color: #007bba; font-size: " + fontSize +";'>" + _flt_dep_details + "</span>");
        }
        else {
            flight_subtitle.html(arr + "<span id='ac_pax_title' style='margin-left: 15px; color: #007bba; font-size: " + fontSize +";'>" + _flt_arr_details + "</span>");
        }
        */
        flightRows.removeClass("current_flight");

        _tr.addClass("current_flight");

        send_message_panel.show();
        show_flt_details_btn.show();

        // Reset Flight Chat
        resetFlightChat();

        // Set
        currentFlightID = flightID;
        currentFlightType = flt_type;

        loadChatMessages(flightID, true);
    }

    function resetFlightChat() {

        initialPictureIDs = [];
        currentFlightType = prevUserID = currentFlightID = lastMessageID = firstMessageID = noMorePrevMessages = 0;

        // Remove messages
        try {
            messages.children().remove();
        } catch (e) {
        }

        // Reset ULD Details
        try {
            resetUldTable();
        } catch (e) {
        }

        // Remove
        try {
            emptyFlightCheckInInfo();
        } catch (e) {
        }

        // Empty Pictures
        try {
            emptyPicturesTab();
        } catch (e) {
        }

        // Reset Interval since new flight is clicked
        try {
            resetInterval();
        } catch (e) {
        }

        try {
            clearMessageTabs();
        } catch (e) {
        }

        try {
            // Remove mark from cknTab
            picTab.removeClass("has-message");
            trcTab.removeClass("has-message");
            cknTab.removeClass("has-message");
        } catch (e) {
        }
    }

    messages.scroll(flightScroll);

    function flightScroll() {

        var flightID = topMenu.data("flight_id");

        var pos = messages.scrollTop();


        if (noMorePrevMessages || !flightID || sendInstance || pos != 0) { // && isBaggageFieldsEmpty()) {
            return;
        }

        // console.log(flightID + " POS:" +pos);

        loadChatMessages(flightID, false, true);
    }

    $(document).on("click", ".add_img", function () {
        var _parent = $(this).parents(".btn_container").prev(".img_container");
        var row = _parent.clone();
        row.find("input").val("");
        row.find("select").val("");

        _parent.after(row);
    });

    $(document).on("click", ".remove_img", function () {
        var _parent = $(this).parents(".btn_container").parent();

        var imgContainers = _parent.find(".img_container");

        if (imgContainers.length <= 1) {
            imgContainers.find("input").val("");
            imgContainers.find("select").val("");

            return;
        }

        imgContainers.last().remove();
    });

    $(document).on("click", ".add_uld", function () {
        var _parent = $(this).parent().prev();
        var row = _parent.find("tr").last().clone();

        cleanULDrow(row);
        _parent.append(row);
    });

    $(document).on("click", ".remove_uld", function () {
        var _parent = $(this).parent().prev();

        var i = _parent.find("tr").length;

        if (i <= 2) {
            cleanULDrow(_parent);
            return;
        }
        _parent.find("tr").last().remove();
    });

    $(document).on("click", ".add_uld_rmv", function () {
        var _parent = $(this).parents("td"), td_with_input = _parent.prev();
        var new_td = td_with_input.clone();

        td_with_input.after(new_td);

        cleanULDrow(new_td);
    });

    $(document).on("click", ".remove_uld_rmv", function () {
        var _parent = $(this).parents("tr"), td_with_input = _parent.find("td.uld");

        var i = td_with_input.length;

        if (i == 1) {
            cleanULDrow(_parent);
            return;
        }

        $(this).parents("td").prev().remove();
    });

    function cleanULDrow(row) {
        row.find("select").val("");
        row.find("input[type=text]").val("");
        row.find("input[type=number]").val("");
        row.find("input[type=checkbox]").removeAttr("checked");
    }

    var JsonFormatter = {
        stringify: function (cipherParams) {
            // create json object with ciphertext
            var jsonObj = {ct: cipherParams.ciphertext.toString(CryptoJS.enc.Base64)};
            // optionally add iv and salt
            if (cipherParams.iv) {
                jsonObj.iv = cipherParams.iv.toString();
            }
            if (cipherParams.salt) {
                jsonObj.s = cipherParams.salt.toString();
            }
            // stringify json object
            return JSON.stringify(jsonObj);
        }
        , parse: function (jsonStr) {
            // parse json string
            var jsonObj = JSON.parse(jsonStr);
            // extract ciphertext from json object, and create cipher params object
            var cipherParams = CryptoJS.lib.CipherParams.create({ciphertext: CryptoJS.enc.Base64.parse(jsonObj.ct)});
            // optionally extract iv and salt
            if (jsonObj.iv) {
                cipherParams.iv = CryptoJS.enc.Hex.parse(jsonObj.iv)
            }
            if (jsonObj.s) {
                cipherParams.salt = CryptoJS.enc.Hex.parse(jsonObj.s)
            }
            return cipherParams;
        }
    };

    function sendMessage(text, flightID) {
        if (typeof flightID === "undefined") {
            flightID = topMenu.data("flight_id");
        }

        if (!flightID || text.trim() === '') { // && isBaggageFieldsEmpty()) {
            return;
        }

        // Save
        if (sendInstance) {
            return;
        }

        sendInstance = true;
        instance = true;

        var parse_message = parse_message_checkbox.is(":checked");

        // Empty value
        message_input.val("");
        parse_message_checkbox.prop("checked", false);

        var key = ((flightID in keys) && keys[flightID] ? keys[flightID] : false);

        if (!key) {
            key = generateRandomString();
            keys[flightID] = preK + key + postK;
        }

        var encrypted = CryptoJS.AES.encrypt(text, keys[flightID]);
        // var encrypted = CryptoJSAesJson.encrypt(text, keys[flightID]);
        console.log("ENCRYPT", encrypted);
        // console.log("ENCRYPT", encrypted.toString());
        // var encrypted = CryptoJS.AES.encrypt("Message", "Secret Passphrase", {format: JsonFormatter});
        // var encryptedJson = CryptoJS.AES.encrypt(text, keys[flightID], {format: JsonFormatter});
        // let decrypted = CryptoJS.AES.decrypt(encryptedJson, keys[flightID], {format: JsonFormatter});
        // console.log("ENCRYPT", encryptedJson.toString());
        // console.log('Decrypted:', decrypted)
        // console.log('Decrypted:', decrypted.toString())
        // console.log('Decrypted:', CryptoJS.AES.decrypt(encryptedJson, keys[flightID]))

        // var decrypted = CryptoJS.AES.decrypt(encrypted.toString(), key);
        // console.log(decrypted.toString(CryptoJS.enc.Utf8));

        var sendData = trcForm.serializeArray(); // convert form to array

        sendData.push({name: "flight_id", value: flightID});
        sendData.push({name: "flight_ids", value: flightIDs});
        sendData.push({name: "key", value: key});
        sendData.push({name: "message", value: encrypted.toString()});

        // sendData.push({name: "enc", value: encrypted.toString()});
        // sendData.push({name: "ct", value: encrypted.ciphertext.toString()}); //.toString(CryptoJS.enc.Base64)}); //.toString()});
        // sendData.push({name: "iv", value: encrypted.iv});
        // sendData.push({name: "s", value: encrypted.salt});

        var checkInData = checkInForm.serializeArray(); // convert form to array
        $.each(checkInData, function (i, field) {
            if (field.value || field.value === "0") {
                sendData.push({name: field.name, value: field.value});
            }
        });

        // Last message ID is sent
        if (lastMessageID) {
            sendData.push({name: "last_message_id", value: lastMessageID});
        }

        var request = $.ajax({
            headers: {
                'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
            },
            type: "POST",
            url: baseUrl + "/flight-com/send-message",
            data: sendData,
            dataType: "json",
        });

        request.always(function () {

        });

        request.fail(function () {
            sendInstance = false;
            instance = false;
        });

        request.success(function (data) {
            fillMessages(data, flightID, true, true);
        });
    };

    function showMessage(flight, key, details, sameUserMessage) {
        var flightID;

        if (flight) {
            flightID = flight.id;
        } else {
            flightID = topMenu.data("flight_id");
        }

        if (!flightID) {
            return false;
        }

        var text = "";
        if (details.message) {
            // Message is decrypted in server if enc is not null!
            if (details.enc){
                text = details.message
            }
            else {
                var decrypted = details.enc ? details.message : CryptoJS.AES.decrypt(details.message, preK + key + postK);

                // var decrypted = CryptoJSAesJson.decrypt(details.message, preK + key + postK);
                // console.log("DECRYPT", decrypted);
                try {
                    text = decrypted.toString(CryptoJS.enc.Utf8);
                } catch (e) {
                    text = "Message failed to load.";
                }
            }
        }

        message_side = details.created_by == userID ? 'right' : 'left';

        var message = new Message({
            ac: flight ? flight.ac : "",
            text: text,
            details: details,
            message_side: message_side,
            same_user_message: sameUserMessage,
        });

        return [message.draw(), text];

        /*
        message.draw();
        return messages.animate({scrollTop: messages.prop('scrollHeight')}, 0);
        */
    };

    checkInForm.on("submit", function () {

        saveCheckinForm();

        return false;
    });

    function isCheckinFormEmpty() {

        var nonEmptyInputs = $('#checkInForm input[type="text"]').filter(function () {
            return !this.value;
        }).length;

        if (nonEmptyInputs) {
            return false;
        }

        nonEmptyInputs = $('#checkInForm input[type="checkbox"]').filter(function () {
            return !this.value;
        }).length;

        if (nonEmptyInputs) {
            return false;
        }

        nonEmptyInputs = $('#checkInForm select').filter(function () {
            return !this.value;
        }).length;

        return !nonEmptyInputs;
    }

    function saveCheckinForm(flightID) {

        checkinFailureMessage.hide();
        checkinSuccessMessage.hide();

        if (typeof flightID === "undefined") {
            flightID = topMenu.data("flight_id");
        }

        if (!flightID) { // && isBaggageFieldsEmpty()) {
            return;
        }

        // Save
        if (sendInstance || isCheckinFormEmpty()) {
            return;
        }

        sendInstance = true;
        instance = true;

        var key = ((flightID in keys) && keys[flightID] ? keys[flightID] : false);

        if (!key) {
            key = generateRandomString();
            keys[flightID] = preK + key + postK;
        }

        var sendData = checkInForm.serializeArray(); // convert form to array

        sendData.push({name: "flight_id", value: flightID});
        sendData.push({name: "flight_ids", value: flightIDs});
        sendData.push({name: "key", value: key});

        // Last message ID is sent
        if (lastMessageID) {
            sendData.push({name: "last_message_id", value: lastMessageID});
        }

        var request = $.ajax({
            headers: {
                'x-csrf-token': checkInForm.find('input[name=_token]').val()
            },
            //contentType : 'multipart/form-data',
            type: "POST",
            url: baseUrl + "/flight-com/check-in-trc",
            data: sendData,
            //dataType  : "json",
        });

        request.always(function () {

        });

        request.fail(function () {
            checkinFailureMessage.show();
            sendInstance = false;
            instance = false;
        });

        request.success(function (data) {
            if (data.success) {
                checkinSuccessMessage.show();
            } else {
                checkinFailureMessage.show();
            }

            fillMessages(data, flightID, true, true);
        });
    }

    trcForm.on("submit", function () {

        saveTrcForm();

        return false;
    });

    function saveTrcForm(flightID) {
        trcSuccessMessage.hide();
        trcFailureMessage.hide();

        if (typeof flightID === "undefined") {
            flightID = topMenu.data("flight_id");
        }

        if (!flightID) { // && isBaggageFieldsEmpty()) {
            return;
        }

        // Save
        if (sendInstance) {
            return;
        }

        sendInstance = true;
        instance = true;

        var key = ((flightID in keys) && keys[flightID] ? keys[flightID] : false);

        if (!key) {
            key = generateRandomString();
            keys[flightID] = preK + key + postK;
        }

        var sendData = trcForm.serializeArray(); // convert form to array

        sendData.push({name: "flight_id", value: flightID});
        sendData.push({name: "flight_ids", value: flightIDs});
        sendData.push({name: "key", value: key});

        // Last message ID is sent
        if (lastMessageID) {
            sendData.push({name: "last_message_id", value: lastMessageID});
        }

        var request = $.ajax({
            headers: {
                'x-csrf-token': checkInForm.find('input[name=_token]').val()
            },
            //contentType : 'multipart/form-data',
            type: "POST",
            url: baseUrl + "/flight-com/check-in-trc",
            data: sendData,
            //dataType  : "json",
        });

        request.always(function () {

        });

        request.fail(function () {
            trcFailureMessage.show();
            sendInstance = false;
            instance = false;
        });

        request.success(function (data) {
            if (data.success) {
                trcSuccessMessage.show();
            } else {
                trcFailureMessage.show();
            }

            fillMessages(data, flightID, true, true);
        });
    }

    ssrForm.on("submit", function () {

        savePtsForm(ssrForm, "SSR");

        return false;
    });

    arrForm.on("submit", function () {

        savePtsForm(arrForm, "ARR");

        return false;
    });

    ptsForm.on("submit", function () {

        savePtsForm(ptsForm, "PTS");

        return false;
    });

    fhrForm.on("submit", function () {

        savePtsForm(fhrForm, "FHR");

        return false;
    });

    function savePtsForm(form, type) {

        var url = "/flight-com/pts";

        if (type === "ARR") {
            arrSuccessMessage.hide();
            arrFailureMessage.hide();
        } else if (type === "SSR") {
            ssrSuccessMessage.hide();
            ssrFailureMessage.hide();
            url = "/flight-com/ssr";
        } else if (type === "FHR") {
            fhrSuccessMessage.hide();
            fhrFailureMessage.hide();
        } else {
            ptsSuccessMessage.hide();
            ptsFailureMessage.hide();
        }

        var flightID = topMenu.data("flight_id");
        /*
        if (typeof flightID === "undefined"){
            flightID = topMenu.data("flight_id");
        }
        */
        if (!flightID) { // && isBaggageFieldsEmpty()) {
            return;
        }

        // Save
        if (sendInstance) {
            return;
        }

        sendInstance = true;
        instance = true;

        var key = ((flightID in keys) && keys[flightID] ? keys[flightID] : false);

        if (!key) {
            key = generateRandomString();
            keys[flightID] = preK + key + postK;
        }

        var sendData = form.serializeArray(); // convert form to array

        sendData.push({name: "flight_id", value: flightID});
        sendData.push({name: "flight_ids", value: flightIDs});
        sendData.push({name: "key", value: key});

        // Last message ID is sent
        if (lastMessageID) {
            sendData.push({name: "last_message_id", value: lastMessageID});
        }

        var request = $.ajax({
            headers: {
                'x-csrf-token': form.find('input[name=_token]').val()
            },
            //contentType : 'multipart/form-data',
            type: "POST",
            url: baseUrl + url,
            data: sendData,
            //dataType  : "json",
        });

        request.always(function () {

        });

        request.fail(function () {
            if (type === "ARR") {
                arrFailureMessage.show();
            } else if (type === "SSR") {
                ssrFailureMessage.show();
            } else if (type === "FHR") {
                fhrFailureMessage.show();
            } else {
                ptsFailureMessage.show();
            }
            sendInstance = false;
            instance = false;
        });

        request.success(function (data) {
            if (data.success) {
                if (type === "ARR") {
                    arrSuccessMessage.show();
                } else if (type === "SSR") {
                    ssrSuccessMessage.show();
                } else if (type === "FHR") {
                    fhrSuccessMessage.show();
                } else {
                    ptsSuccessMessage.show();
                }
            } else {
                if (type === "ARR") {
                    arrFailureMessage.show();
                } else if (type === "SSR") {
                    ssrFailureMessage.show();
                } else if (type === "FHR") {
                    fhrFailureMessage.show();
                } else {
                    ptsFailureMessage.show();
                }
            }

            fillMessages(data, flightID, true, true);
        });
    }

    occForm.on("submit", function () {

        sendOccForm(occForm);

        return false;
    });

    function sendOccForm(form) {

        var url = "/flight-com/occ";

        occSuccessMessage.hide();
        occFailureMessage.hide();

        var flightID = topMenu.data("flight_id");
        /*
        if (typeof flightID === "undefined"){
            flightID = topMenu.data("flight_id");
        }
        */
        if (!flightID) { // && isBaggageFieldsEmpty()) {
            return;
        }

        // Save
        if (sendInstance) {
            return;
        }

        sendInstance = true;
        instance = true;

        /*
        var key = ((flightID in keys) && keys[flightID] ? keys[flightID] : false);

        if (!key){
            key = generateRandomString();
            keys[flightID] = preK + key + postK;
        }
        */

        var sendData = form.serializeArray(); // convert form to array

        sendData.push({name: "flight_id", value: flightID});
        // sendData.push({name: "flight_ids", value: flightIDs});
        // sendData.push({name: "key", value: key});

        // Last message ID is sent
        if (lastMessageID) {
            sendData.push({name: "last_message_id", value: lastMessageID});
        }

        var request = $.ajax({
            headers: {
                'x-csrf-token': form.find('input[name=_token]').val()
            },
            //contentType : 'multipart/form-data',
            type: "POST",
            url: baseUrl + url,
            data: sendData,
            //dataType  : "json",
        });

        request.always(function () {

        });

        request.fail(function () {
            occFailureMessage.show();
            sendInstance = false;
            instance = false;
            debugError = true;
        });

        request.success(function (data) {
            if (data.success) {
                occSuccessMessage.show();
                debugError = false;

            } else {
                occFailureMessage.show();
            }

            fillMessages(data, flightID, true, true);
        });
    }

    send_btn.click(function (e) {
        sendMessage(message_input.val());

        message_input.focus();
    });

    message_input.keyup(function (e) {
        if (e.ctrlKey && e.which === 13) {
            sendMessage(message_input.val());

            message_input.focus();
        }
    });

    function unseenMessages() {

        if (sendInstance || instance) {
            return;
        }
        /*
         var cloneLoading = loading.clone();
         cloneLoading.show();
         messages.html(cloneLoading);
         */
        instance = true;

        var request = $.ajax({
                headers: {
                    'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
                },
                type: "POST",
                url: baseUrl + "/flight-com/unseen-messages",
                data: {
                    date: currentDate,
                    flight_ids: flightIDs,
                }
            }
        );

        request.success(function (data) {
            debugError = false;

            // unseen and autoload
            if (data.unseen && data.unseen.length) {
                resetInterval();
            } else {
                increaseInterval();
            }

            fillUnseenMessages(data.unseen, data.counter);

        });

        request.fail(function () {
            console.log("Request Failed");

            debugError = true;

            autoLoadMessages();
        });

        request.always(function () {
            //cloneLoading.hide();
            instance = false;
        });
    }

    var debugError = false;

    function loadChatMessages(flightID, flightClicked, scrollUp) {

        if (!flightClicked && (sendInstance || instance)) {
            return;
        }

        if (typeof flightID === "undefined") {
            flightID = topMenu.data("flight_id");
        }

        if (!flightID) {
            // Reset vars
            instance = false;
            fltClickInstance = false;

            return;
        }

        data = {};

        var initialLoad = false;

        var requestUrl = baseUrl + "/flight-com/load-messages";

        if (typeof flightClicked !== "undefined" && flightClicked) {
            // messages.append(loading);
            data.initial_load = 1;
            initialLoad = true;

            requestUrl += "/" + flightID;
        }

        instance = true;

        data.flight_id = flightID;
        data.flight_ids = flightIDs;

        if (typeof scrollUp !== "undefined" && scrollUp) {
            // Don't load more
            if (noMorePrevMessages) {
                instance = false;
                fltClickInstance = false;

                return;
            }

            if (firstMessageID) {
                data.first_message_id = firstMessageID;
            }
        } else {
            if (lastMessageID) {
                data.last_message_id = lastMessageID;
                //alert("Last message ID:" + lastMessageID)
            }
        }

        var request = $.ajax({
            headers: {
                'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
            },
            type: "POST",
            url: requestUrl,
            data: data,
        });

        request.success(function (data) {

            debugError = false;

            if (currentFlightID == flightID) {
                try {
                    fillMessages(data, flightID, false, false, scrollUp, initialLoad);
                } catch (e) {
                    // Reset vars
                    //instance = false;
                    //fltClickInstance = false;
                }
            }

        });

        request.fail(function () {
            // Reset vars
            instance = false;
            fltClickInstance = false;

            debugError = true;

            autoLoadMessages();
        });

        request.always(function () {
            // Reset vars
            instance = false;
            fltClickInstance = false;
        });
    }

    function setTitleVars() {
        flt_dep_arr_time = flight_subtitle.find("#flt_dep_arr_time");
        flt_ac_type = flight_subtitle.find("#flt_ac_type");
        flt_ac = flight_subtitle.find("#flt_ac");
        flt_cfg = flight_subtitle.find("#flt_cfg");
        flt_bkd = flight_subtitle.find("#flt_bkd");
        flt_act = flight_subtitle.find("#flt_act");
    }

    function setACByAirline(flightID) {
        if (!flightID) {
            return;
        }

        if (flightID in airlineByFlight) {

            var airlineID = airlineByFlight[flightID];

            if (airlineID in aircraftByAirline) {

                var acList = aircraftByAirline[airlineID];
                form_aircraft_id.children().remove();

                $.each(acList, function (key, value) {
                    form_aircraft_id
                        .append($("<option></option>")
                            .attr("value", value.id)
                            .text(value.name));
                });
            }
        }
    }

    var initialTimerSet;
    var markRedSeconds = 600;
    var countDownMax = 3600;
    var countDownMin = -3600;

    function initiateCountdownTimer(flight) {

        // Stop if ATD happened
        if (currentFlightType == ARRIVAL || (flight.atd && flight.atd != EMPTY_DATETIME)) {
            countdown_timer.stop();
            countdown_timer.hide();
            return;
        }

        var depDate = getFlightDepartureDate(flight),
            curTime = moment().utc().format(inputDateFormat),
            duration;


        depDate = moment(depDate).format(inputDateFormat);

        if (!moment(depDate).isSame(new Date(), 'd')) {
            return;
        }

        duration = getDuration(curTime, depDate, true);

        if (duration || duration == 0) {
            if (duration > 0 && duration < countDownMax) {
                countdown_timer.show();

                if (!initialTimerSet) {
                    setCountdown(duration);
                    initialTimerSet = true;
                } else {
                    updateCountdown(duration);
                }

                return;
            } else if (duration < 0 && duration > countDownMin) {
                //countdown_timer.show();
            }
            // Duration = 0
            else if (duration == 0) {
            }
        }

        countdown_timer.stop();
        countdown_timer.hide();
    }

    function setCountdown(secs, countUp) {

        if (typeof countUp !== "undefined" && countUp) {
            countdown_timer.removeClass("red");
        } else {
            if (secs <= markRedSeconds) {
                if (!countdown_timer.hasClass("red")) {
                    countdown_timer.addClass("red");
                }
            } else {
                countdown_timer.removeClass("red");
            }
        }

        countdown_timer.countdown({
            date: +(new Date) + (secs * 1000),
            render: function (data) {
                //$(this.el).text(this.leadingZeros(data.sec, 2) + " sec");
                $(this.el).html("<div>" + this.leadingZeros(data.min, 2) + " <span>min</span></div><div>" + this.leadingZeros(data.sec, 2) + " <span>sec</span></div>");
                //$(this.el).html("<div>" + this.leadingZeros(data.hours, 2) + " <span>hrs</span></div><div>" + this.leadingZeros(data.min, 2) + " <span>min</span></div><div>" + this.leadingZeros(data.sec, 2) + " <span>sec</span></div>");
            },
            onEnd: function () {
                $(this.el).addClass('ended');
            }
        }).on("click", function () {
            //$(this).removeClass('ended').data('countdown').update(+(new Date) + 10000).start();
        });
    }

    function updateCountdown(secs, countUp) {
        if (typeof countUp !== "undefined" && countUp) {
            countdown_timer.removeClass("red");
        } else {
            if (secs <= markRedSeconds) {
                if (!countdown_timer.hasClass("red")) {
                    countdown_timer.addClass("red");
                }
            } else {
                countdown_timer.removeClass("red");
            }
        }

        countdown_timer.removeClass('ended').data('countdown').update(+(new Date) + (secs * 1000)).start();
    }


    function fillMessages(data, flightID, cleanFormInputs, sendMessageInstances, scrollUp, initialLoad) {
        var msgs = data.messages, deletedMessages = data.deleted, flight = data.flight, com = data.com,
            unseen = data.unseen, counter = data.counter, initial_pictures = data.pictures, msgID = false;

        if (!data.success || flightID != currentFlightID) {
            // Unset
            unsetInstanceAndInitializeTimeout(sendMessageInstances);

            return;
        }

        // Empty Messages
        if (typeof cleanFormInputs !== "undefined" && cleanFormInputs) {
            emptyFormInputs();
        }

        if (flight) {
            var gate = "";
            if (flight.gate_boarding) {
                gate += "GATE: " + flight.gate_boarding + " | ";
            }
            if (flight.gate_parking) {
                gate += "POS: " + flight.gate_parking;
            }
            gate_info.text(gate);

            // AC
            if (initialLoad) {
                // Set AC by airline
                try {
                    setACByAirline(flightID);
                } catch (e) {
                    console.log(e.message);
                }

                // Initiate Timer
                try {
                    initiateCountdownTimer(flight);
                } catch (e) {
                    console.log(e.message);
                }
            }

            setTitleVars();

            flt_ac_type.text(flight.ac_type ? flight.ac_type + " | " : "");
            flt_ac.text(flight.ac ? flight.ac + " | " : "");

            flt_cfg.text(flight.cfg ? flight.cfg + " | " : "");
            flt_bkd.text(flight.bkd ? flight.bkd + " | " : "");
            flt_act.text(flight.act ? flight.act + " | " : "");

            flt_pax_a.text(flight.pax_a);
            flt_pax_c.text(flight.pax_c);
            flt_pax_y.text(flight.pax_y);
            flt_pax_jmp.text(flight.pax_jmp);

            flt_pax_adult.text(flight.pax_adults);
            flt_pax_male.text(flight.pax_m);
            flt_pax_female.text(flight.pax_f);
            flt_pax_child.text(flight.pax_ch);
            flt_pax_inf.text(flight.pax_inf);

            // New fields
            flt_dow.text(flight.dow);
            flt_doi.text(flight.doi);
            flt_mtow.text(flight.mtow);
            flt_rtow.text(flight.rtow);
            flt_tof.text(flight.tof);
            flt_trip.text(flight.trip);
            flt_eet.text(flight.eet ? getSimpleTime(flight.eet) : "");
            flt_taxi.text(flight.taxi);
            flt_block.text(flight.block);
            flt_altn.text(flight.altn);

            flt_lofo_staff.text(flight.lofo_staff);
            flt_lofo_rmks.text(flight.lofo_rmks);
            flt_lofo_start.text(flight.lofo_start ? getSimpleDateTime(flight.lofo_start) : "");
            flt_lofo_end.text(flight.lofo_end ? getSimpleDateTime(flight.lofo_end) : "");
            flt_mhb_ahl.text(flight.mhb_ahl);
            flt_mhb_ohd.text(flight.mhb_ohd);
            flt_mhb_dpr.text(flight.mhb_dpr);


            markMessageTabs(flight);

            if (flight.pax_a || flight.pax_c || flight.pax_y || flight.pax_jmp
                || flight.pax_adults || flight.pax_m || flight.pax_f || flight.pax_ch || flight.pax_inf) {
                // Mark cknTab
                if (!cknTab.hasClass("has-message")) {
                    cknTab.addClass("has-message");
                }
            }
        }

        //
        markPicTab();

        if (com) {

            flt_ckin_num.text(com.ckin_num);
            flt_ckin_ctr.text(com.ckin_ctr);
            flt_materials_secured_ckin.text(com.materials_secured_ckin ? "YES" : "");
            flt_materials_secured_gate.text(com.materials_secured_gate ? "YES" : "");


            //flt_ckin_rmks.text(com.ckin_rmks);
            flt_spvr_rmks.text(com.spvr_rmks);
            flt_trc_rmks.text(com.trc_rmks);

            flt_trc_crew.text(com.crew);
            flt_trc_capt.text(com.capt);

            flt_trc.text(com.trc);
            flt_ckin_staff.text(com.ckin_staff);
            flt_gate_staff.text(com.gate_staff);

            flt_specials.text(com.specials);
            flt_gate_spvr.text(com.gate_spvr);

            flt_spvr.text(com.spvr);

            flt_seat_a.text(com.seat_a);
            flt_seat_b.text(com.seat_b);
            flt_seat_c.text(com.seat_c);
            flt_seat_d.text(com.seat_d);
            flt_seat_e.text(com.seat_e);

            flt_chkd_bag_pcs.text(com.chkd_bag_pcs);
            flt_chkd_bag_wt.text(com.chkd_bag_wt);

            flt_gate_bag_pcs.text(com.gate_bag_pcs);
            flt_gate_bag_wt.text(com.gate_bag_wt);
            //

            if (com.ckin_num || com.ckin_ctr || com.ckin_staff || com.gate_staff || com.gate_spvr || com.specials || com.spvr || com.spvr_rmks
                || com.seat_a || com.seat_b || com.seat_c || com.seat_d || com.seat_e
                || com.chkd_bag_pcs || com.chkd_bag_wt || com.gate_bag_pcs || com.gate_bag_wt
                || com.materials_secured_ckin || com.materials_secured_gate) {
                // Mark cknTab
                if (!cknTab.hasClass("has-message")) {
                    cknTab.addClass("has-message");
                }
            }

            if (com.trc || com.trc_rmks) {
                // Mark cknTab
                if (!trcTab.hasClass("has-message")) {
                    trcTab.addClass("has-message");
                }
            }
        }

        if (data.key && data.key != "null") { // && !(flightID in keys )){
            keys[flightID] = preK + data.key + postK;
        }

        // Fill messages
        if (msgs && msgs.length) {

            var check = false;
            var pics = "";

            var msg, msgContainer = $("<ul></ul>");

            if (typeof scrollUp !== "undefined" && scrollUp) {
                firstMessageID = 0;
            }

            try {
                if (initial_pictures && initial_pictures.length) {

                    var thumb = "";
                    $.each(initial_pictures, function (j, img) {

                        initialPictureIDs.push(img.id);

                        if (img.type && img.type.toLowerCase() == "pdf") {
                            thumb = baseUrl + "/assets/flight-com/img/pdf-file.png";
                        } else {
                            if (img.icon) {
                                thumb = baseUrl + "/flight-com/picture/" + img.id + "?type=icon";
                            } else {
                                thumb = baseUrl + "/assets/flight-com/img/image-file.png";
                            }
                        }

                        pics += "<div class='attached'>" +
                            "<div class='attached_img_container'>" +
                            "<a target='_blank' href='" + baseUrl + "/flight-com/picture/" + img.id + "?type=picture'>" +
                            "<img class='attached_img' src='" + thumb + "' />" +
                            "</a>" +
                            "</div>" +
                            "<div class='text-center' style='padding: 0 5px;'>" +
                            "<p>" + (img.notes != null && img.notes ? img.notes : "") + "</p>" +
                            "</div>" +
                            "</div>";
                    });
                }
            } catch (e) {
                console.log("ERROR TRY/CATCH: " + e.message);
            }

            var notifyTitle = flight_title.data("fn_sector");
            var picturesMsg = "";

            try {
                $.each(msgs, function (i, each) {

                    if (each.flight_com_details_id) {
                        msgID = each.flight_com_details_id;
                    } else {
                        msgID = each.id;
                    }

                    // First Message ID
                    if (!firstMessageID) {
                        firstMessageID = msgID;
                    }

                    check = (each.created_by == prevUserID);

                    prevUserID = each.created_by;

                    picturesMsg = "";
                    if (!each.deleted_at && Object.keys(each.pictures).length) {

                        var thumb = "";
                        $.each(each.pictures, function (j, img) {

                            if ($.inArray(img.id, initialPictureIDs) !== -1) {
                                return;
                            }

                            if (img.type && img.type.toLowerCase() == "pdf") {
                                thumb = baseUrl + "/assets/flight-com/img/pdf-file.png";
                            } else {
                                if (img.icon) {
                                    thumb = baseUrl + "/flight-com/picture/" + img.id + "?type=icon";
                                } else {
                                    thumb = baseUrl + "/assets/flight-com/img/image-file.png";
                                }
                            }

                            pics += "<div class='attached'>" +
                                "<div class='attached_img_container'>" +
                                "<a target='_blank' href='" + baseUrl + "/flight-com/picture/" + img.id + "?type=picture'>" +
                                "<img class='attached_img' src='" + thumb + "' />" +
                                "</a>" +
                                "</div>" +
                                "<div class='text-center' style='padding: 0 5px;'>" +
                                "<p>" + (img.notes != null && img.notes ? img.notes : "") + "</p>" +
                                "</div>" +
                                "</div>";

                            picturesMsg += (img.notes != null && img.notes ? img.notes : "PIC")
                        });
                    }

                    try {
                        msg = showMessage(flight, data.key, each, check);
                    } catch (e) {
                        console.log("ERROR TRY/CATCH: " + e.message);
                    }

                    if (msg[0]) {
                        msgContainer.append(msg[0]);

                        // if not focused notify
                        if (!initialLoad && !scrollUp && !sendMessageInstances && notificationPermission && !windowFocused) {
                            // console.log("INIT LOAD: " + initialLoad + ", SEND INST : " + sendMessageInstances);
                            notify(flightID, notifyTitle, (msg[1] ? msg[1] : picturesMsg), 2000);
                        }
                    }

                });
            } catch (e) {
                console.log("ERROR TRY/CATCH: " + e.message);
            }

            // Added
            if (msgContainer.children().length) {
                if (typeof scrollUp !== "undefined" && scrollUp) {
                    messages.prepend(msgContainer.children());
                    messages.animate({scrollTop: 40}, 0);
                } else {

                    messages.append(msgContainer.children());
                    messages.animate({scrollTop: messages.prop('scrollHeight')}, 0);

                    if (msgID) {
                        lastMessageID = msgID;
                    }
                }
            }

            // Pictures
            if (currentFlightID == flightID) {
                flt_pictures_container.append(pics);
            } else {
                flt_pictures_container.html(pics);
            }

            // end

            // Reset Interval
            resetInterval();
        } else {
            if (typeof scrollUp !== "undefined" && scrollUp) {
                noMorePrevMessages = true;

                var message = new Message({
                    firstMessage: true,
                });

                try {
                    messages.prepend(message.draw());
                    messages.animate({scrollTop: 40}, 0);
                } catch (e) {
                    console.log("LINE 2506: " + e.message);
                }
            }

            // Message not found -> Increase interval
//                        console.log("No messages => Increase Interval");
            increaseInterval();
        }

        // Deleted Messages
        markDeletedMessage(deletedMessages);

        // unseen and autoload
        fillUnseenMessages(unseen, counter, sendMessageInstances);
    }


    function resetUldTable() {
        flight_uld_table.children().remove();
        flight_uld_table.append("<tr>" +
            "<td>DEST</td>" +
            "<td>POSITION</td>" +
            "<td>CNT</td>" +
            "<td>ULD TYPE</td>" +
            "<td>ULD ID</td>" +
            "<td>PCS</td>" +
            "<td>WT</td>" +
            "<td>VR</td>" +
            "<td>NOTOC</td>" +
            "</tr>");
    }

    function fillUnseenMessages(unseen, counter, sendMessageInstances) {
        $.each(flightIDs, function (i, fltID) {
            var _tr = flightsTable.find("tr[data-flight_id='" + fltID + "']");

            var count = "";
            if (fltID in unseen) {
                count = unseen[fltID]["c"];
            }
            _tr.find(".flight_msg_count span").text(count);

            if (notificationPermission && count && count > 0) {

                if (!(fltID in notifiedMessages && notifiedMessages[fltID] == count)) {
                    var msg = (unseen[fltID]['c'] == 1 ? unseen[fltID]['c'] + ' new message' : unseen[fltID]['c'] + ' new messages');
                    notify(fltID, unseen[fltID]["f"], msg);

                    notifiedMessages[fltID] = count;
                }
            }

            if ($.inArray(fltID, counter) != -1) {
                _tr.addClass("messages_exist");
            }
        });

        // Unset
        unsetInstanceAndInitializeTimeout(sendMessageInstances);
    }

    function notify(fltID, title, message, timeout) {
        //console.log("NOTIFY " + title)

        timeout = 10000; // typeof timeout !== "undefined" && timeout ? timeout : 1800000;

        Push.create(title, {
            icon: baseUrl + "/smart/img/logo_gsrm.png",
            body: message,
            //requireInteraction : true,
            //icon: 'icon.png',
            timeout: timeout,               // Timeout before notification closes automatically.
            vibrate: [100, 100, 100],    // An array of vibration pulses for mobile devices.
            slient: false,
            onClick: function () {
                // Callback for when the notification is clicked.
                flightClicked(fltID);
                this.close();
            }
        });
    }

    function emptyFormInputs() {
        table_uld_and_notoc_fields.find("input[type=text]").val("");
        table_uld_and_notoc_fields.find("input[type=checkbox]").prop("checked", false);

        var i = table_uld_and_notoc_fields.find("tr").length;
        //if (i > 2){
        //    table_uld_and_notoc_fields.find("tr:gt(1)").remove();
        //}

        cleanULDrow(table_uld_and_notoc_fields);
        //

        table_rmks_and_pax_fields.find("input[type=checkbox]").prop("checked", false);
        table_rmks_and_pax_fields.find("input[type=text]").val("");
        table_rmks_and_pax_fields.find("select").removeAttr("selected");

        table_fhr.find("input[type=text]").val("");
        table_fhr.find("input[type=checkbox]").prop("checked", false);
        table_fhr.find("textarea").val("");

        table_pts.find("input[type=text]").val("");
        table_pts.find("input[type=checkbox]").prop("checked", false);
        table_pts.find("select").val("");

        uploadPictureForm.find(".img_container:gt(0)").remove();
        uploadPictureForm.find("input[type=file]").val("");
        //uploadPictureForm.find("select").val("");

        // Rebuild multiselect
        try {
            var a = $(document).find(".table_uld_and_notoc_fields .multiselect"),
                b = $(document).find(".table_uld_and_notoc_fields .multiselect_search");
            a.multiselect('destroy');
            a.multiselect('rebuild');
            b.multiselect('destroy');
            b.multiselect('rebuild');
        }
        catch (e) {
            console.log(e)
        }

    }

    function emptyPicturesTab() {
        flt_pictures_container.html("");
    }

    function emptyFlightCheckInInfo() {

        form_aircraft_id.val("");

        flt_pax_a.text("");
        flt_pax_c.text("");
        flt_pax_y.text("");
        flt_pax_jmp.text("");

        flt_pax_adult.text("");
        flt_pax_male.text("");
        flt_pax_female.text("");
        flt_pax_child.text("");
        flt_pax_inf.text("");

        flt_ckin_num.text("");
        flt_ckin_ctr.text("");
        flt_materials_secured_ckin.text("");
        flt_materials_secured_gate.text("");
        //flt_ckin_rmks.text("");
        flt_trc_rmks.text("");

        flt_trc_crew.text("");
        flt_trc_capt.text("");

        flt_dow.text("");
        flt_doi.text("");
        flt_mtow.text("");
        flt_rtow.text("");
        flt_tof.text("");
        flt_trip.text("");
        flt_eet.text("");
        flt_taxi.text("");
        flt_block.text("");
        flt_altn.text("");

        flt_spvr_rmks.text("");

        flt_trc.text("");
        flt_ckin_staff.text("");
        flt_gate_staff.text("");
        flt_gate_spvr.text("");
        flt_specials.text("");
        flt_spvr.text("");


        flt_seat_a.text("");
        flt_seat_b.text("");
        flt_seat_c.text("");
        flt_seat_d.text("");
        flt_seat_e.text("");

        flt_chkd_bag_pcs.text("");
        flt_chkd_bag_wt.text("");

        flt_gate_bag_pcs.text("");
        flt_gate_bag_wt.text("");
    }

    function markMessageTabs(flight) {

        var messageTypes = [];

        if (flight.has_staff) {
            item = $("#sod_tab");

            if (!item.hasClass("has-message")) {
                item.addClass("has-message");
            }

            messageTypes.push(SOD);
        }

        if (flight.message) {
            var msg, item;
            $.each(flight.message, function (i, type) {
                if ($.inArray(type, messageTypes) == -1) {

                    if (type == LOADSHEET || type == LOADSHEET_FINAL) {
                        msg = LDS;
                    } else {
                        msg = type;
                    }

                    if (!msg) {
                        return;
                    }


                    item = $("#" + msg.toLowerCase() + "_tab");

                    if (!item.hasClass("has-message")) {
                        item.addClass("has-message");
                    }

                    messageTypes.push(msg);
                }
            });

            /*
            $.each(all_tabs, function(i, each){
                if ($.inArray(each, messageTypes) == -1){
                    msg = each.toLowerCase();
                    $("#" + msg + "_tab").removeClass("has-message");
                }
            });
            */
        }

        /**
         * Here' SOD tab has also be tagged
         *
         */
    }

    function markPicTab() {
        try {
            if (flt_pictures_container.children().length) {
                if (!picTab.hasClass("has-message")) {
                    picTab.addClass("has-message");
                }
            } else {
                picTab.removeClass("has-message");
            }
        } catch (e) {
            console.log(e.message)
        }
    }

    function clearMessageTabs() {

        departure_mvt_container.html("");
        arrival_mvt_container.html("");
        message_container.html("");

        //var index = $('#main-tabs > li > a[href="#tabChat"]').parent().index();
        //$("#main-tabs").tabs("option", "active", 0);
        //$( "#tabs" ).tabs({ active: "0" });

        $.each(all_tabs, function (i, each) {
            $("#" + each.toLowerCase() + "_tab").removeClass("has-message");
        });

        try {
            $('#tabChatAnchor').click();
        } catch (e) {
            console.log(e.message)
        }

        try {
            $('#chatTrcTabAnchor').click();
        } catch (e) {
            console.log(e.message)
        }
    }

    $('#main-tabs > li > a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
        var _current_tab = $(e.target), current_tab_name = _current_tab.attr("href").replace("#", "");

        var flightID = topMenu.data("flight_id");

        if (!flightID) {
            return;
        }

        switch (current_tab_name) {
            case TAB_LDM:
            case TAB_LDS:
            case TAB_LIR:
            case TAB_NOT:
            case TAB_CPM:
            case TAB_CAL:
            case TAB_PSM:
            case TAB_PTM:
                loadTabMessages(current_tab_name);
                break;

            case TAB_MVT:
                loadMVTMessages();
                break;

            case TAB_SOD:
                loadSODTab();
                break;

            case TAB_TRC:
                loadTRCTab();
                break;

            default:
                break;
        }
    });

    function loadMVTMessages() {
        var request, mvt_message_block = $("#mvt-message-block"), fare,
            mvt_container = $("#mvt-container"), email_body, i, l, readyMessage,
            departure_mvt_container = $("#departure-mvt-container"),
            arrival_mvt_container = $("#arrival-mvt-container");

        mvt_message_block.empty();
        departure_mvt_container.empty();
        arrival_mvt_container.empty();
        mvt_container.append(ajax_loading_flight_info);

        // send AJAX request to load MVT messages
        request = $.ajax({
            url: baseUrl + "/flight/ajax-get-mvt-messages-list",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                flight_id: topMenu.data("flight_id"),
            }
        });
        request.done(function (data) {
            if (typeof data.departureMVT !== "undefined") {
                if (data.departureMVT.length > 0 || data.arrivalMVT.length > 0) {

                    departure_mvt_container.empty();
                    var skippedClass;
                    for (i = 0; i < data.departureMVT.length; i++) {
                        skippedClass = data.departureMVT[i].skipped ? "skipped" : "";
                        departure_mvt_container.append("<div class='mvt-message-item " + data.departureMVT[i].type + "'>" +
                            "<pre class='mvt-message " + skippedClass + "'>" + data.departureMVT[i].readyData + "</pre>" +
                            "</div>");
                    }

                    arrival_mvt_container.empty();
                    for (i = 0; i < data.arrivalMVT.length; i++) {
                        skippedClass = data.arrivalMVT[i].skipped ? "skipped" : "";
                        arrival_mvt_container.append("<div class='mvt-message-item " + data.arrivalMVT[i].type + "'>" +
                            "<pre class='mvt-message " + skippedClass + "'>" + data.arrivalMVT[i].readyData + "</pre>" +
                            "</div>");
                    }
                } else {
                    showMessage("Not found any MVT messages for this flight", "No Result!", MESSAGE_INFO, mvt_message_block);
                }
            }
        });
        request.always(function () {
            mvt_container.find('.ajax-loading-flight-info').remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, mvt_message_block);
        });
    }

    function loadTabMessages(message_type) {
        var request, message_block = $(".message-block[data-type='" + message_type + "']"),
            container = $(".message-container[data-type='" + message_type + "']");

        message_block.empty();
        container.empty();
        container.append(ajax_loading_flight_info);

        // send AJAX request to load MVT messages
        request = $.ajax({
            url: baseUrl + "/flight/ajax-get-messages",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                flight_id: topMenu.data("flight_id"),
                type: message_type
            }
        });
        request.done(function (data) {
            if (typeof data.messages !== "undefined") {
                if (data.messages.length > 0) {
                    container.empty();
                    for (var i = 0; i < data.messages.length; i++) {
                        container.append("<div class='message-item'>" +
                            "<pre>" + data.messages[i] + "</pre>" +
                            "</div>");
                    }
                } else {
                    showMessage(message_type.toUpperCase() + " messages not found.", "Result: Found 0.", MESSAGE_INFO, message_block);
                }
            }
        });
        request.always(function () {
            container.find('.ajax-loading-flight-info').remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
    }

    function loadTRCTab() {
        var request, flightID = topMenu.data("flight_id");

        if (!flightID) {
            return;
        }

        resetUldTable();

        trc_container.append(ajax_loading_flight_info);

        // send AJAX request to load MVT messages
        request = $.ajax({
            url: baseUrl + "/flight-com/load-trc",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                flight_id: flightID,
            }
        });
        request.done(function (data) {
            if (typeof data !== "undefined") {
                fillTRCTab(data.uld);
            }
        });
        request.always(function () {
            trc_container.find('.ajax-loading-flight-info').remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
    }

    function fillTRCTab(uld) {
        if (uld && Object.keys(uld).length) {
            flight_uld_table.children().remove();

            var tr = "";
            var td_dest = "<td>DEST</td>";
            var td_pos = "<td>POSITION</td>";
            var td_content = "<td>CNT</td>";
            var td_type = "<td>ULD TYPE</td>";
            var td_num = "<td>ULD ID</td>";
            var td_owner = "<td>OWNER</td>";
            var td_pcs = "<td>PCS</td>";
            var td_wt = "<td>WT</td>";
            var td_vr = "<td>VR</td>";
            var td_notoc = "<td>NOTOC</td>";

            $.each(uld, function (i, row) {
                td_dest += "<td><strong>" + (row.dest ? row.dest : "") + "</strong></td>";
                td_pos += "<td><strong>" + row.pos + "</strong></td>";
                td_content += "<td><strong>" + (row.content ? row.content : "") + "</strong></td>";
                td_type += "<td><strong>" + (row.type ? row.type : "") + "</strong></td>";
                td_num += "<td><strong>" + (row.num ? row.num : "") + "</strong></td>";
                td_owner += "<td><strong>" + (row.owner ? row.owner : "") + "</strong></td>";
                td_pcs += "<td><strong>" + (row.pcs || row.pcs == "0" ? row.pcs : "") + "</strong></td>";
                td_wt += "<td><strong>" + (row.wt || row.wt == "0" ? row.wt : "") + "</strong></td>";
                td_vr += "<td><strong>" + (row.vr || row.vr == "0" ? row.vr : "") + "</strong></td>";
                td_notoc += "<td><strong>" + row.notoc + "</strong></td>";

                /*
                 tr += "<tr>" +
                 "<td><strong>" + row.pos +  "</strong></td>" +
                 "<td><strong>" + row.content +  "</strong></td>" +
                 "<td><strong>" + row.type +  "</strong></td>" +
                 "<td><strong>" + row.num +  "</strong></td>" +
                 "<td><strong>" + row.pcs +  "</strong></td>" +
                 "<td><strong>" + row.wt +  "</strong></td>" +
                 "<td><strong>" + row.vr +  "</strong></td>" +
                 "<td><strong>" + row.notoc +  "</strong></td>" +
                 "</tr>";
                 */
            });

            tr += "<tr>" + td_dest + "</tr>" +
                "<tr>" + td_pos + "</tr>" +
                "<tr>" + td_content + "</tr>" +
                "<tr>" + td_type + "</tr>" +
                "<tr>" + td_num + "</tr>" +
                "<tr>" + td_owner + "</tr>" +
                "<tr>" + td_pcs + "</tr>" +
                "<tr>" + td_wt + "</tr>" +
                "<tr>" + td_vr + "</tr>" +
                "<tr>" + td_notoc + "</tr>";

            flight_uld_table.append(tr);

            // Mark trcTab
            if (!trcTab.hasClass("has-message")) {
                trcTab.addClass("has-message");
            }
        } else {
            resetUldTable();
        }
    }

    function loadSODTab() {
        var request, container = staffTableBody.parents(".staff-container");

        staffTableBody.empty();
        container.prepend(ajax_loading_flight_info);

        // send AJAX request to load MVT messages
        request = $.ajax({
            url: baseUrl + "/flight/ajax-get-sod",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                flight_id: topMenu.data("flight_id"),
            }
        });
        request.done(function (data) {
            if (typeof data !== "undefined") {
                fillSODTab(data.flight, data.serviceData);
            }
        });
        request.always(function () {
            container.find('.ajax-loading-flight-info').remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
    }

    function fillSODTab(flight, serviceData) {

        var tr = "", foundStaff, user, k,
            services = serviceData.services,
            //serviceType = serviceData.serviceType,
            staffList = flight.staffList, flightDepArr;

        staffTableBody.empty();

        var serviceType, spanType, spanClass, req, min, report, release;

        //duration = moment.duration(moment(to).diff(from));
        //minutes = duration.asMinutes();

        var obj, pReportTime, pReleaseTime, pDuration, reportTime, releaseTime, duration, plannedReport, plannedRelease,
            plannedDuration;

        if (services && services.length) {
            $.each(services, function (key, airlineService) {

                serviceType = airlineService.serviceType;
                if (airlineService.service_timings == 1) {
                    if (airlineService.service[serviceType] != 1) {
                        // Continue
                        return true;
                    }
                    obj = airlineService.service;
                } else {
                    if (airlineService[serviceType] != 1) {
                        // Continue
                        return true;
                    }
                    obj = airlineService;
                }

                switch (serviceType) {
                    case ARRIVAL_SERVICE:
                        req = "arr_staff_req";
                        min = "arr_staff_min";
                        report = "arr_report_time";
                        release = "arr_release_time";
                        flightDepArr = getSLAFlightArrival(flight);
                        spanType = "<span class='label label-success'>ARRIVAL</span>";
                        spanClass = "label-success";

                        flightDepArr = getSLAFlightArrival(flight);
                        plannedReport = moment(flightDepArr).subtract(obj[report], 'm');
                        plannedRelease = moment(flightDepArr).add(obj[release], 'm');
                        break;

                    case DEPARTURE_SERVICE:
                        req = "dep_staff_req";
                        min = "dep_staff_min";
                        report = "dep_report_time";
                        release = "dep_release_time";
                        flightDepArr = getSLAFlightDeparture(flight);
                        spanType = "<span class='label label-primary'>DEPARTURE</span>";
                        spanClass = "label-primary";

                        flightDepArr = getSLAFlightDeparture(flight);
                        plannedReport = moment(flightDepArr).subtract(obj[report], 'm');
                        plannedRelease = moment(flightDepArr).subtract(obj[release], 'm');
                        break;

                    case TURNAROUND_SERVICE:
                        req = "turn_staff_req";
                        min = "turn_staff_min";
                        report = "turn_report_time";
                        release = "turn_release_time";
                        spanType = "<span class='label label-warning'>TURNAROUND</span>";
                        spanClass = "label-warning";

                        var flightDepArrParent = getSLAFlightArrival(flight.flight_parent);
                        flightDepArr = getSLAFlightDeparture(flight);

                        plannedReport = moment(flightDepArrParent).subtract(obj[report], 'm');
                        plannedRelease = moment(flightDepArr).subtract(obj[release], 'm');
                        break;
                }

                plannedDuration = getDuration(plannedReport, plannedRelease);

                tr += "<tr class='sla-header'>" +
                    "<td data-center><span class='label font-sm " + spanClass + "'>" + airlineService.service.abbr + "</span></td>" +
                    "<td>" +
                    spanType +
                    "<span style='margin-left: 10px'><strong>Required: " + obj[req] + "</strong></span>" +
                    "</td>" +
                    "<td>" + plannedReport.format("MMM DD, HH:mm") + " <span class='label label-warning'>SLA</span></td>" +
                    "<td>" + plannedRelease.format("MMM DD, HH:mm") + " <span class='label label-warning'>SLA</span></td>" +
                    "<td data-center>" + plannedDuration + " <span class='label label-warning'>SLA</span></td>" +
                    "</tr>";

                foundStaff = false;
                if (staffList.hasOwnProperty(airlineService.service.abbr) && staffList[airlineService.service.abbr].length > 0) {
                    k = 0;
                    $.each(staffList[airlineService.service.abbr], function (j, staffDetail) {
                        if (airlineService.service_id == staffDetail.service_id) {
                            user = staffDetail.user;
                            pReportTime = staffDetail.planned_report_time && staffDetail.planned_report_time != EMPTY_DATETIME ? moment(staffDetail.planned_report_time) : "";
                            pReleaseTime = staffDetail.planned_release_time && staffDetail.planned_release_time != EMPTY_DATETIME ? moment(staffDetail.planned_release_time) : "";
                            pDuration = pReportTime && pReleaseTime ? getDuration(pReportTime, pReleaseTime) : "";

                            reportTime = staffDetail.report_time && staffDetail.report_time != EMPTY_DATETIME ? moment(staffDetail.report_time) : "";
                            releaseTime = staffDetail.release_time && staffDetail.release_time != EMPTY_DATETIME ? moment(staffDetail.release_time) : "";
                            duration = reportTime && releaseTime ? getDuration(reportTime, releaseTime) : "";

                            tr += "<tr>" +
                                "<td style='vertical-align: middle' data-center>" + (++k) + "</td>" +
                                "<td class='staff-name'>" +
                                (staffDetail.location ? staffDetail.location.iata + " - " : "") +
                                (user ? user.first_name + " " + user.last_name : "") +
                                "</td>" +

                                "<td>" + (pReportTime ? (pReportTime.format("MMM DD, HH:mm") + " <span class='label label-success'>PLN</span>") : "") + "<br/>" +
                                (reportTime ? (reportTime.format("MMM DD, HH:mm") + " <span class='label label-primary'>ACT</span>") : "") +
                                "</td>" +

                                "<td>" + (pReleaseTime ? (pReleaseTime.format("MMM DD, HH:mm") + " <span class='label label-success'>PLN</span>") : "") + "<br/>" +
                                (releaseTime ? (releaseTime.format("MMM DD, HH:mm") + " <span class='label label-primary'>ACT</span>") : "") +
                                "</td>" +

                                "<td data-center>" + (pDuration ? pDuration + " <span class='label label-success'>PLN</span>" : "") + "<br/>" +
                                (duration ? duration + " <span class='label label-primary'>ACT</span>" : "") +
                                "</td>" +

                                "</tr>";

                            foundStaff = true;
                        }
                    });
                }
            });

            staffTableBody.append(tr);
        }
    }


    $(window).on("blur focus", function (e) {
        var prevType = $(this).data("prevType");

        if (prevType != e.type) {   //  reduce double fire issues
            switch (e.type) {
                case "blur":
                    // do work
                    windowFocused = false;
                    //console.log("BLUR" + new Date($.now()));
                    break;
                case "focus":
                    // do work
                    windowFocused = true;
                    //console.log("FOCUS" + new Date($.now()));
                    resetInterval();
                    break;
            }
        }

        $(this).data("prevType", e.type);
    });

    function ApplyDateFormatToInputs(parentElement) {

        parentElement.find(".datetimepicker").datetimepicker({
            format: "Y-m-d H:i",
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            step: 1
        });

        parentElement.find(".datetimepicker-current").datetimepicker({
            format: "Y-m-d H:i",
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            step: 1,
            // maxDate: new Date(moment.utc().format("YYYY-MM-DD HH:mm")),
            onChangeDateTime: function (date, $input) {
                var maxDate = moment.utc().format("YYYY-MM-DD HH:mm");
                if (moment(maxDate).isBefore(moment(date))) {
                    alert("Time is in future!");
                    $input.val("");
                }
            }
        });
    }

    $(document).on("change", ".assigned-staff", function () {
        var _this = $(this), assignedContainer = _this.parents(".assigned-container");
        console.log("Changed");
        console.log(assignedContainer);
        if (_this.val()) {
            assignedContainer.find(".p-report-time").attr("required", "required");
            assignedContainer.find(".p-release-time").attr("required", "required");
        } else {
            assignedContainer.find(".p-report-time").removeAttr("required");
            assignedContainer.find(".p-release-time").removeAttr("required");
        }
    });

    staffContainer.on("click", ".add-staff", function () {
        var _this = $(this), assignedContainer = _this.parents(".assigned-container"), newContainer, staff;

        newContainer = assignedContainer.clone();

        newContainer.find(".assigned-service").text("");

        newContainer.find(".assigned-staff").val("");

        newContainer.find(".report-time").val("");

        newContainer.find(".release-time").val("");

        assignedContainer.find(".staff-operations").hide();

        assignedContainer.removeClass("gray-border-bottom");

        newContainer.insertAfter(assignedContainer);

        newContainer.find(".sla-info").hide();

        newContainer.addClass("gray-border-bottom");

        ApplyDateFormatToInputs(newContainer);
    })
        .on("click", ".remove-staff", function () {
            var _this = $(this), assignedContainer = _this.parents(".assigned-container"), assignedService;

            assignedService = assignedContainer.find(".assigned-service");

            if (assignedService.text() == "") {

                assignedContainer.prev().find(".staff-operations").show();

                assignedContainer.prev().addClass("gray-border-bottom");

                assignedContainer.remove();
            } else {

                assignedContainer.find(".assigned-staff").val("");

                assignedContainer.find(".p-report-time").val("");
                assignedContainer.find(".p-report-time").removeAttr("required");

                assignedContainer.find(".p-release-time").val("");
                assignedContainer.find(".p-release-time").removeAttr("required");

                assignedContainer.find(".report-time").val("");

                assignedContainer.find(".release-time").val("");

                assignedContainer.find(".staff-operations").show();
            }
        })
        .on("click", ".copy-pln-report-time", function () {
            var _this = $(this), plnReportTime = _this.parent().find(".p-report-time"),
                container = _this.parents(".assigned-container");

            var utcDate = moment().utc().format("YYYY-MM-DD HH:mm");

            if (moment(utcDate).isBefore(moment(plnReportTime.val(), "YYYY-MM-DD HH:mm"))) {
                alert("Time is in future!");
                return;
            }

            container.find(".report-time").val(plnReportTime.val());

        })
        .on("click", ".copy-pln-release-time", function () {
            var _this = $(this), plnReleaseTime = _this.parent().find(".p-release-time"),
                container = _this.parents(".assigned-container");

            var utcDate = moment().utc().format("YYYY-MM-DD HH:mm");

            if (moment(utcDate).isBefore(moment(plnReleaseTime.val(), "YYYY-MM-DD HH:mm"))) {
                alert("Time is in future!");
                return;
            }

            container.find(".release-time").val(plnReleaseTime.val());

        });

    staffForm.on("submit", function () {

        saveStaffForm();

        return false;
    });

    function saveStaffForm(flightID) {

        staffFailureMessage.hide();
        staffSuccessMessage.hide();

        if (typeof flightID === "undefined") {
            flightID = topMenu.data("flight_id");
        }

        if (!flightID) { // && isBaggageFieldsEmpty()) {
            return;
        }

        // Save
        if (sendInstance) {
            return;
        }

        //console.log(text);

        sendInstance = true;
        instance = true;

        var key = ((flightID in keys) && keys[flightID] ? keys[flightID] : false);

        if (!key) {
            key = generateRandomString();
            keys[flightID] = preK + key + postK;
        }

        var sendData = staffForm.serializeArray(); // convert form to array

        sendData.push({name: "flight_id", value: flightID});
        sendData.push({name: "flight_ids", value: flightIDs});
        sendData.push({name: "key", value: key});

        // Last message ID is sent
        if (lastMessageID) {
            sendData.push({name: "last_message_id", value: lastMessageID});
        }

        var request = $.ajax({
            headers: {
                'x-csrf-token': staffForm.find('input[name=_token]').val()
            },
            //contentType : 'multipart/form-data',
            type: "POST",
            url: baseUrl + "/flight-com/staff",
            data: sendData,
            //dataType  : "json",
        });

        request.always(function () {

        });

        request.fail(function () {
            staffFailureMessage.show();
            sendInstance = false;
            instance = false;
        });

        request.success(function (data) {
            if (data.success) {
                staffSuccessMessage.show();
            } else {
                staffFailureMessage.show();
            }

            fillMessages(data, flightID, true, true);
        });
    }

    $(document).on("shown.bs.tab", '#chat_update_info_tabs > li > a[data-toggle="tab"]', function (e) {
        var _current_tab = $(e.target), current_tab_name = _current_tab.attr("href").replace("#", "");

        var flightID = topMenu.data("flight_id");

        if (!flightID) {
            return;
        }

        switch (current_tab_name) {
            case CHAT_STAFF_TAB:
                loadChatStaffTab();
                break;

            default:
                break;
        }
    });

    function loadChatStaffTab() {
        var request, flightID = topMenu.data("flight_id");

        if (!flightID) {
            return;
        }

        resetUldTable();

        staffContainer.children().remove();
        staffTabContainer.append(ajax_loading_flight_info);

        // send AJAX request to load MVT messages
        request = $.ajax({
            url: baseUrl + "/flight-com/load-staff",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                flight_id: flightID,
            }
        });
        request.done(function (data) {
            if (typeof data !== "undefined") {
                fillStaffForm(data.serviceData, data.flight);
            }
        });
        request.always(function () {
            staffTabContainer.find('.ajax-loading-flight-info').remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
    }

    function fillStaffForm(flightsData, flight) {

        var parentContainer = staffContainer.parent(),

            assignedFlights = parentContainer.find(".flight-container"),
            num = assignedFlights.length,

            assignedContainer = parentContainer.find(".assigned-container[data-initial=1]");

        num++;


        var flightContainer = $("<div class='col-md-12 flight-container border-bottom no-padding' data-num='" + num + "'></div>");

        // Delete
        // staffContainer.children().remove();

        var staffObjects = flight.staffList, serviceType;

        var foundStaff = false;

        var obj;

        if (Object.keys(flightsData.services).length) {
            staffSubmitContainer.show();

            $.each(flightsData.services, function (key, airlineService) {
                serviceType = airlineService.serviceType;
                if (airlineService.service_timings == 1) {
                    if (airlineService.service[serviceType] != 1) {
                        // Continue
                        return true;
                    }
                    obj = airlineService.service;
                } else {
                    if (airlineService[serviceType] != 1) {
                        // Continue
                        return true;
                    }
                    obj = airlineService;
                }

                foundStaff = false;
                if (staffObjects.hasOwnProperty(airlineService.service.abbr) && staffObjects[airlineService.service.abbr].length > 0) {
                    $.each(staffObjects[airlineService.service.abbr], function (j, staffDetail) {
                        if (airlineService.service_id == staffDetail.service_id) {

                            flightContainer = createStaffContainer(airlineService, obj, flight, serviceType, assignedContainer, flightContainer, !foundStaff, staffDetail);
                            foundStaff = true;
                        }
                    });
                }

                if (!foundStaff) {
                    flightContainer = createStaffContainer(airlineService, obj, flight, serviceType, assignedContainer, flightContainer, true);
                }

                flightContainer.find(".staff-operations").last().show();
                flightContainer.find(".assigned-container").last().addClass("gray-border-bottom");
                staffContainer.append(flightContainer);

            });

            ApplyDateFormatToInputs(staffContainer);
        } else {
            staffSubmitContainer.hide();
        }
    }

    function createStaffContainer(airlineService, obj, flight, serviceType, assignedContainer, flightContainer, showLabel, selectedStaff) {
        var slaInfo, slaStaffReq, newStaff, pReportTime, pReleaseTime, reportTime, releaseTime, newContainer,
            newService;

        newContainer = assignedContainer.clone();
        newContainer.removeAttr("data-initial");
        slaInfo = newContainer.find(".sla-info");

        if (showLabel && showLabel !== "undefined") {
            var req, min, slaType, report, release, pReport, pRelease, pDuration, flightDepArr;

            slaType = newContainer.find(".assigned-sla-type");
            slaType.attr("name", "t_" + airlineService.service_id);

            switch (serviceType) {
                case ARRIVAL_SERVICE:
                    req = "arr_staff_req";
                    report = "arr_report_time";
                    release = "arr_release_time";
                    flightDepArr = getSLAFlightArrival(flight);
                    pReport = moment(flightDepArr).subtract(obj[report], 'm');
                    pRelease = moment(flightDepArr).add(obj[release], 'm');

                    newContainer.find(".assigned-service").addClass("label-success").text(airlineService.service.abbr);
                    newContainer.find(".assigned-service-type").addClass("label-success").text("ARRIVAL");
                    newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                    // Service Type sent to form
                    slaType.val("a");
                    break;

                case DEPARTURE_SERVICE:
                    req = "dep_staff_req";
                    report = "dep_report_time";
                    release = "dep_release_time";
                    flightDepArr = getSLAFlightDeparture(flight);
                    pReport = moment(flightDepArr).subtract(obj[report], 'm');
                    pRelease = moment(flightDepArr).subtract(obj[release], 'm');

                    newContainer.find(".assigned-service").addClass("label-primary").text(airlineService.service.abbr);
                    newContainer.find(".assigned-service-type").addClass("label-primary").text("DEPARTURE");
                    newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                    // Service Type sent to form
                    slaType.val("d");
                    break;

                case TURNAROUND_SERVICE:
                    req = "turn_staff_req";
                    report = "turn_report_time";
                    release = "turn_release_time";

                    var flightDepArrParent = getSLAFlightArrival(flight.flight_parent);
                    flightDepArr = getSLAFlightDeparture(flight);

                    pReport = moment(flightDepArrParent).subtract(obj[report], 'm');
                    pRelease = moment(flightDepArr).subtract(obj[release], 'm');

                    newContainer.find(".assigned-service").addClass("label-warning").text(airlineService.service.abbr);
                    newContainer.find(".assigned-service-type").addClass("label-warning").text("TURNAROUND");
                    newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                    // Service Type sent to form
                    slaType.val("t");
                    break;

            }

            pDuration = getDuration(pReport, pRelease);

            newContainer.find(".sla-report-time").text(pReport.format("YYYY-MM-DD HH:mm"));
            newContainer.find(".sla-release-time").text(pRelease.format("YYYY-MM-DD HH:mm"));
        } else {
            slaInfo.hide();
        }

        newStaff = newContainer.find(".assigned-staff");
        newStaff.attr("name", "s_" + airlineService.service_id + "[]");
        newStaff.append($("<option value=''>-Select Staff-</option>"));

        $.each(airlineService.eligibleStaff, function (j, staff) {
            newStaff.append($("<option value='" + staff.user_id + "'>" + staff.iata + " - " + staff.first_name + " " + staff.last_name + "</option>"));
        });

        //newStaff.multiselect(multiSelectOptionsSearch);

        pReportTime = newContainer.find(".p-report-time");
        pReportTime.attr("name", "pr_" + airlineService.service_id + "[]");
        pReportTime.attr("required", "required");

        pReleaseTime = newContainer.find(".p-release-time");
        pReleaseTime.attr("name", "pf_" + airlineService.service_id + "[]");
        pReleaseTime.attr("required", "required");

        reportTime = newContainer.find(".report-time");
        reportTime.attr("name", "r_" + airlineService.service_id + "[]");

        releaseTime = newContainer.find(".release-time");
        releaseTime.attr("name", "f_" + airlineService.service_id + "[]");

        if (selectedStaff && selectedStaff !== "undefined") {
            newStaff.val(selectedStaff.user_id);
            // PLANNED
            if (selectedStaff.planned_report_time && selectedStaff.planned_report_time != EMPTY_DATETIME) {
                pReportTime.val(correctDateFormat(selectedStaff.planned_report_time));
            } else if (pReport && pReport != EMPTY_DATETIME) {
                pReportTime.val(pReport.format("YYYY-MM-DD HH:mm"));
            }

            if (selectedStaff.planned_release_time && selectedStaff.planned_release_time != EMPTY_DATETIME) {
                pReleaseTime.val(correctDateFormat(selectedStaff.planned_release_time));
            } else if (pRelease && pRelease != EMPTY_DATETIME) {
                pReleaseTime.val(pRelease.format("YYYY-MM-DD HH:mm"));
            }

            // ACTUALS
            reportTime.val(selectedStaff.report_time && selectedStaff.report_time != EMPTY_DATETIME ? correctDateFormat(selectedStaff.report_time) : "");
            releaseTime.val(selectedStaff.release_time && selectedStaff.release_time != EMPTY_DATETIME ? correctDateFormat(selectedStaff.release_time) : "");
        } else {
            if (pReport && pReport != EMPTY_DATETIME) {
                pReportTime.val(pReport.format("YYYY-MM-DD HH:mm"));
            }

            if (pRelease && pRelease != EMPTY_DATETIME) {
                pReleaseTime.val(pRelease.format("YYYY-MM-DD HH:mm"));
            }
        }


        newContainer.removeClass("hidden");
        flightContainer.append(newContainer);

        return flightContainer;
    }

    function correctDateFormat(date, format) {
        if (format)
            return moment(date, inputDateFormat).format(format);
        else
            return moment(date, inputDateFormat).format("YYYY-MM-DD HH:mm");
    }

    function getSimpleDateTime(time) {
        return moment(time, "YYYY-MM-DD HH:mm:ss").format("MMM DD, HH:mm");
    }

    function getSimpleTime(time) {
        return moment(time, "HH:mm:ss").format("HH:mm");
    }

    function getSLAFlightDeparture(flight) {
        var date;
        /*
        if (flight.atd && flight.atd != EMPTY_DATETIME) {
            date = moment(flight.atd, inputDateFormat).toDate();
        }
        else if (flight.etd && flight.etd != EMPTY_DATETIME) {
            date = moment(flight.etd, inputDateFormat).toDate();
        }
        else
        */
        if (flight.ptd && flight.ptd != EMPTY_DATETIME) {
            date = moment(flight.ptd, inputDateFormat).toDate();
        } else {
            date = moment(flight.std, inputDateFormat).toDate();
        }
        return date;
    }

    function getSLAFlightArrival(flight) {
        var date;
        /*
        if (flight.ata && flight.ata != EMPTY_DATETIME) {
            date = moment(flight.ata, inputDateFormat).toDate();
        }
        else if (flight.eta && flight.eta != EMPTY_DATETIME) {
            date = moment(flight.eta, inputDateFormat).toDate();
        }
        else
        */
        if (flight.pta && flight.pta != EMPTY_DATETIME) {
            date = moment(flight.pta, inputDateFormat).toDate();
        } else {
            date = moment(flight.sta, inputDateFormat).toDate();
        }
        return date;
    }

    function getDuration(from, to, inSeconds) {
        var duration = moment.duration(moment(to).diff(from));
        var hours = duration.hours(), mins = duration.minutes(), secs = duration.seconds();

        if (mins > 60) {
            mins -= (hours * 60);
        }

        if (typeof inSeconds !== "undefined" && inSeconds) {
            return hours * 3600 + mins * 60 + secs;
        }

        return (hours < 10 ? "0" + hours : hours) + ":" + (mins < 10 ? "0" + (mins < 0 ? 0 : mins) : mins);
    }

    function unsetInstanceAndInitializeTimeout(sendMessageInstances) {
        if (typeof sendMessageInstances !== "undefined" && sendMessageInstances) {
            instance = false;
            sendInstance = false;
        }

        // Stop autoload
        if (!archivedData) {
            setTimeout(autoLoadMessages, currentInterval);
        }

    }

    setTimeout(autoLoadMessages, currentInterval);

    if (selectedFlightID) {
        if ($.inArray(selectedFlightID, flightIDs) != -1) {
            flightClicked(selectedFlightID);
        }
    }

    /*
    $('.countdown.styled').countdown({
        date: endDate,
        render: function(data) {
            $(this.el).html("<div>" + this.leadingZeros(data.years, 4) + " <span>years</span></div><div>" + this.leadingZeros(data.days, 3) + " <span>days</span></div><div>" + this.leadingZeros(data.hours, 2) + " <span>hrs</span></div><div>" + this.leadingZeros(data.min, 2) + " <span>min</span></div><div>" + this.leadingZeros(data.sec, 2) + " <span>sec</span></div>");
        }
    });
    */
})
;

