<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('messages__cal', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string("status")->nullable();
            $table->boolean("important")->nullable();
            $table->boolean("seen")->nullable();
            $table->boolean("parsed")->nullable();

            $table->unsignedInteger('flight_id')->nullable();
            $table->unsignedInteger('flight_number_id')->nullable();
            $table->integer('email_id')->nullable();
            $table->string("message_id")->nullable();
            $table->integer("udate")->nullable();
            $table->dateTime('received_datetime')->nullable();
            $table->string('from_email')->nullable();
            $table->string('to_email')->nullable();
            $table->text('email_body')->nullable();
            $table->string('email_title')->nullable();;
            $table->text('data')->nullable();
            $table->text("log")->nullable();

            $table->timestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->dateTime('deleted_at')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('messages__cal');
    }
};
