<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsCatering extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__catering', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('flight_id')->nullable();

            $table->integer("std_meals_a")->nullable();
            $table->integer("std_meals_c")->nullable();
            $table->integer("std_meals_w")->nullable();
            $table->integer("std_meals_y")->nullable();

            $table->integer("spcl_meals_a")->nullable();
            $table->integer("spcl_meals_c")->nullable();
            $table->integer("spcl_meals_w")->nullable();
            $table->integer("spcl_meals_y")->nullable();

            $table->integer("meals_a")->nullable();
            $table->integer("meals_c")->nullable();
            $table->integer("meals_w")->nullable();
            $table->integer("meals_y")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights__catering');
    }
}
