<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPaxWToFlightsStations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__stations', function (Blueprint $table) {
            $table->unsignedInteger("pax_w")->nullable()->after("pax_c");
            $table->unsignedInteger("pax_w_bkd")->nullable()->after("pax_c_bkd");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__stations', function (Blueprint $table) {
            $table->dropColumn([
                "pax_w",
                "pax_w_bkd",
            ]);
        });
    }
}
