<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__numbers', function (Blueprint $table) {
            $table->string("departure_airport")->nullable()->change();
            $table->string("arrival_airport")->nullable()->change();
        });

        \App\Models\FlightNumber::where("departure_airport", "")
                                ->update([
                                    "departure_airport" => null
                                ]);

        \App\Models\FlightNumber::where("arrival_airport", "")
                                ->update([
                                    "arrival_airport" => null
                                ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__numbers', function (Blueprint $table) {
        });
    }
};
