<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('structure__departments', function (Blueprint $table) {
            $table->string("name")->nullable()->change();
            $table->integer("has_subdepartment")->nullable()->default(null)->change();
            $table->integer("is_menu")->nullable()->default(null)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('structure__departments', function (Blueprint $table) {
            $table->string("name")->nullable()->change();
            $table->integer("has_subdepartment")->nullable()->default(0)->change();
            $table->integer("is_menu")->nullable()->default(0)->change();
        });
    }
};
