<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeFlightsComDetailsParseCols extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com_details', function (Blueprint $table) {
            $table->dropColumn([
                "parse",
                "parse_result",
            ]);
            $table->text("enc")->nullable()->after("message");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com_details', function (Blueprint $table) {
            $table->boolean("parse")->nullable()->after("message");
            $table->boolean("parse_result")->nullable()->after("message");
            $table->dropColumn("enc");
        });
    }
}
