<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMultiIndexInFlightsNumbers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__numbers', function (Blueprint $table) {
            $table->index(["flight_number", "airline_id", "departure_airport_id", "arrival_airport_id"],
                "flt_no_airline_dep_arr_ap");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__numbers', function (Blueprint $table) {
            $table->dropIndex("flt_no_airline_dep_arr_ap");
        });
    }
}
