<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIndexToFlightsComFlightsStaff extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com_flights_staff', function (Blueprint $table) {
            $table->index("flight_com_id", "flights__com_flights_staff_flight_com_id");
            $table->index("flight_com_details_id", "flights__com_flights_staff_flight_com_details_id");
            $table->index("flight_id", "flights__com_flights_staff_flight_id");
            $table->index("user_id", "flights__com_flights_staff_user_id");
            $table->index("service_id", "flights__com_flights_staff_service_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com_flights_staff', function (Blueprint $table) {
            $table->dropIndex([
                "flights__com_flights_staff_flight_com_id",
                "flights__com_flights_staff_flight_com_details_id",
                "flights__com_flights_staff_flight_id",
                "flights__com_flights_staff_user_id",
                "flights__com_flights_staff_service_id",
            ]);
        });
    }
}
