<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersPreferredOffs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users__preferred_offs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('user_id')->nullable();
            $table->time('1_from')->nullable();
            $table->time('1_to')->nullable();
            $table->time('2_from')->nullable();
            $table->time('2_to')->nullable();
            $table->time('3_from')->nullable();
            $table->time('3_to')->nullable();
            $table->time('4_from')->nullable();
            $table->time('4_to')->nullable();
            $table->time('5_from')->nullable();
            $table->time('5_to')->nullable();
            $table->time('6_from')->nullable();
            $table->time('6_to')->nullable();
            $table->time('0_from')->nullable();
            $table->time('0_to')->nullable();
            $table->unsignedInteger("created_by")->nullable();
            $table->unsignedInteger("updated_by")->nullable();
            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users__preferred_offs');
    }
}
