<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDepartureArrivalDatesToFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->date("departure_date")->nullable()->after("diverted_airport_id");
            $table->date("arrival_date")->nullable()->after("abn");

            $table->index("departure_date", "flights_departure_date_index");
            $table->index("arrival_date", "flights_arrival_date_index");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->dropColumn([
                "departure_date",
                "arrival_date",
            ]);

            $table->dropIndex([
                "flights_departure_date_index",
                "flights_arrival_date_index"
            ]);
        });
    }
}
