<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateIndexInStaffServices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('staff__services', function (Blueprint $table) {
            $table->index(["user_id", "service_id"], "staff__services_user_id_service_id_index");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('staff__services', function (Blueprint $table) {
            $table->dropIndex("staff__services_user_id_service_id_index");
        });
    }
}
