<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFlightIdIndexToFlightsPts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__pts', function (Blueprint $table) {
            $table->index("flight_id", "flights__pts_flight_id_index");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__pts', function (Blueprint $table) {
            $table->dropIndex("flights__pts_flight_id_index");
        });
    }
}
