<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIndecisToAudits extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('audits', function (Blueprint $table) {
            $table->index("auditable_type", "audits_auditable_type_index");
            $table->index("auditable_id", "audits_auditable_id_index");
            $table->index("user_id", "audits_user_id_index");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('audits', function (Blueprint $table) {
            $table->dropIndex([
                "audits_auditable_type_index",
                "audits_auditable_id_index",
                "audits_user_id_index",
            ]);
        });
    }
}
