<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIndecisToFlightsStaff extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__staff', function (Blueprint $table) {
            $table->index("flight_id", "flights__staff_flight_id_index");
            $table->index(["flight_id", "user_id", "service_id"], "flights__staff_flight_id_user_id_service_id_index");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__staff', function (Blueprint $table) {
            $table->dropIndex([
               "flights__staff_flight_id_index",
               "flights__staff_flight_id_user_id_service_id_index",
            ]);
        });
    }
}
