<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIndecisToMessages2018 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('messages__2018', function (Blueprint $table) {
            $table->index("flight_id", "messages__2018_flight_id_index");
            $table->index("message_id", "messages__2018_message_id_index");
            $table->index(["udate", "from_email"], "messages__2018_udate_from_email_index");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('messages__2018', function (Blueprint $table) {
            $table->dropIndex([
                "messages__2018_flight_id_index",
                "messages__2018_message_id_index",
                "messages__2018_udate_from_email_index",
            ]);
        });
    }
}
