<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIndecisToMessagesResult extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('messages__result', function (Blueprint $table) {
            $table->index("message_id", "messages__result_message_id_index");
            $table->index(["udate", "from_email"], "messages__result_udate_from_email_index");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('messages__result', function (Blueprint $table) {
            $table->dropIndex([
                "messages__result_flight_id_index",
                "messages__result_message_id_index",
                "messages__result_udate_from_email_index",
            ]);
        });
    }
}
