<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIndecisToMessagesPsm extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('messages__psm', function (Blueprint $table) {
            $table->index("flight_id", "messages__psm_flight_id_index");
            $table->index("message_id", "messages__psm_message_id_index");
            $table->index(["udate", "from_email"], "messages__psm_udate_from_email_index");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('messages__psm', function (Blueprint $table) {
            $table->dropIndex([
                "messages__psm_flight_id_index",
                "messages__psm_message_id_index",
                "messages__psm_udate_from_email_index",
            ]);
        });
    }
}
