<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersPageViewsArchive extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users__page_views_archive', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->boolean("skip")->nullable();
            $table->string('module')->nullable();
            $table->string('module_url')->nullable();
            $table->string("class_name")->nullable();
            $table->string("class_id")->nullable();
            $table->string('permissions_required')->nullable();
            $table->string('required_user_role')->nullable();
            $table->boolean("access_granted")->nullable();

            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users__page_views_archive');
    }
}
