<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToAircraft extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('aircraft', function (Blueprint $table) {
            $table->string("hex_code")->nullable()->after("mvt_name");
            $table->unsignedInteger("engine_id")->nullable()->after("aircraft_type_id");
            $table->boolean("wide_board")->nullable()->after("engine_id");
            $table->boolean("flexi_config")->nullable()->after("wide_board");
            $table->date("delivery_date")->nullable()->after("flexi_config");
            $table->date('first_flight')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('aircraft', function (Blueprint $table) {
            $table->dropColumn([
                "hex_code",
                "engine_id",
                "delivery_date",
            ]);
            $table->date('first_flight')->change();
        });
    }
}
