<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNewFieldsToFlightsComFlightsPts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com_flights_pts', function (Blueprint $table) {
            $table->time("ckin_open")->nullable()->after("flight_id");
            $table->time("ckin_close")->nullable()->after("ckin_open");
            $table->boolean("all_doors_panels_closed")->nullable()->after("ckin_close");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com_flights_pts', function (Blueprint $table) {
            $table->dropColumn([
                "ckin_open",
                "ckin_close",
                "all_doors_panels_closed",
            ]);
        });
    }
}
