<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTurnaroundToAirlinesServices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('airlines__services', function (Blueprint $table) {
            $table->boolean("turnaround_service")->nullable()->after("include_all_stations");
            $table->integer("turn_staff_req")->nullable()->after("turnaround_service");
            $table->integer("turn_staff_min")->nullable()->after("turn_staff_req");
            $table->integer("turn_report_time")->nullable()->after("turn_staff_min");
            $table->integer("turn_release_time")->nullable()->after("turn_report_time");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('airlines__services', function (Blueprint $table) {
            $table->dropColumn([
                "turnaround_service",
                "turn_staff_req",
                "turn_staff_min",
                "turn_report_time",
                "turn_release_time",
            ]);
        });
    }
}
