<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSodUpdatedAt extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__staff', function (Blueprint $table) {
            $table->dateTime("sod_updated_at")->nullable()->after("service_type");
            $table->unsignedInteger("sod_updated_by")->nullable()->after("sod_updated_at");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__staff', function (Blueprint $table) {
            $table->dropColumn([
                "sod_updated_at",
                "sod_updated_by",
            ]);
        });
    }
}
