<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddReadAndSignToLibrary extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('library', function (Blueprint $table) {
            $table->dateTime("read_and_sign")->nullable()->after("abbr");
            $table->dateTime("read_and_sign_notified_at")->nullable()->after("read_and_sign");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('library', function (Blueprint $table) {
            $table->dropColumn([
                "read_and_sign",
                "read_and_sign_notified_at",
            ]);
        });
    }
}
