<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLibraryViews extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('library_views', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger("library_id")->nullable();
            $table->unsignedInteger("library_sign_id")->nullable();
            $table->unsignedInteger("user_id")->nullable();
            $table->dateTime("viewed_at")->nullable();
            $table->dateTime("downloaded_at")->nullable();
            $table->dateTime("signed_at")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('library_views');
    }
}
