<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRemoveOtherFlightsToFlightsSchedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__schedule', function (Blueprint $table) {
            $table->text("airport_ids")->nullable()->after("airline_id");
            $table->boolean("remove_other_flights")->nullable()->after("airport_ids");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__schedule', function (Blueprint $table) {
            $table->dropColumn([
                "airport_ids",
                "remove_other_flights",
            ]);
        });
    }
}
