<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDocumentToUsersLeaveRequests extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users__leave_requests', function (Blueprint $table) {
            $table->string("doc1")->nullable()->after("exceeded_days");
            $table->string("doc2")->nullable()->after("doc1");
            $table->string("doc3")->nullable()->after("doc2");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users__leave_requests', function (Blueprint $table) {
            $table->dropColumn([
                "doc1",
                "doc2",
                "doc3"
            ]);
        });
    }
}
