<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAcceptedPaxToFlightsPts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__pts', function (Blueprint $table) {
            $table->integer("accepted_pax")->nullable()->after("last_pax_boarded");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__pts', function (Blueprint $table) {
            $table->dropColumn([
                "accepted_pax"
            ]);
        });
    }
}
