<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddBaFieldsToFlightsPts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__pts', function (Blueprint $table) {
            $table->time("gate_open")->nullable()->after("flight_id");
            $table->time("crew_at_gate")->nullable()->after("gate_open");
            $table->time("boarding_start_time")->nullable()->after("crew_at_gate");
            $table->time("first_pax_boarded")->nullable()->after("boarding_start_time");
            $table->time("last_pax_boarded")->nullable()->after("first_pax_boarded");
            $table->time("first_bag_loaded")->nullable()->after("last_pax_boarded");
            $table->time("last_bag_loaded")->nullable()->after("first_bag_loaded");
            $table->time("bag_search_started")->nullable()->after("last_bag_loaded");
            $table->time("bag_search_finished")->nullable()->after("bag_search_started");
            $table->time("fuelling_finished")->nullable()->after("bag_search_finished");
            $table->time("rtg")->nullable()->after("fuelling_finished");

            // FHR
            $table->text("missed_artg")->nullable()->after("lofo_end");
            $table->text("delay")->nullable()->after("missed_artg");
            $table->text("ckn")->nullable()->after("delay");
            $table->text("ramp")->nullable()->after("ckn");
            $table->text("safety")->nullable()->after("ramp");
            $table->text("other")->nullable()->after("safety");
            $table->text("denied_boarding1")->nullable()->after("other");
            $table->text("denied_boarding2")->nullable()->after("denied_boarding1");
            $table->text("denied_boarding3")->nullable()->after("denied_boarding2");
            $table->text("denied_boarding4")->nullable()->after("denied_boarding3");
            $table->text("denied_boarding5")->nullable()->after("denied_boarding4");
            $table->text("denied_boarding6")->nullable()->after("denied_boarding5");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__pts', function (Blueprint $table) {
            $table->dropColumn([
                "gate_open",
                "crew_at_gate",
                "boarding_start_time",
                "first_pax_boarded",
                "last_pax_boarded",
                "first_bag_loaded",
                "last_bag_loaded",
                "bag_search_started",
                "bag_search_finished",
                "fuelling_finished",
                "rtg",

                // FHR
                "missed_artg",
                "delay",
                "ckn",
                "ramp",
                "safety",
                "other",
                "denied_boarding1",
                "denied_boarding2",
                "denied_boarding3",
                "denied_boarding4",
                "denied_boarding5",
                "denied_boarding6",
            ]);
        });
    }
}
