<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStartEndDatesAndDeletedAtToAirlinesServices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('airlines__services', function (Blueprint $table) {
            $table->date("start_date")->nullable()->after("service_timings");
            $table->date("end_date")->nullable()->after("start_date");
            $table->dateTime("deleted_at")->nullable()->after("updated_at");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('airlines__services', function (Blueprint $table) {
            $table->dropColumn([
                "start_date",
                "end_date",
                "deleted_at",
            ]);
        });
    }
}
