<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEffectiveToAirlinesServices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('airlines__services', function (Blueprint $table) {
            $table->time("effective_from")->nullable()->after("service_timings");
            $table->time("effective_to")->nullable()->after("effective_from");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('airlines__services', function (Blueprint $table) {
            $table->dropColumn([
                "effective_from",
                "effective_to",
            ]);
        });
    }
}
