<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCargoPcsToFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->integer("capacity_w")->nullable()->after("capacity_c");
            $table->integer("pax_w_booked")->nullable()->after("pax_c_booked");
            $table->integer("pax_w_actual")->nullable()->after("pax_c_actual");

            $table->integer("cargo_pcs")->nullable()->after("cargo");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->dropColumn([
                "capacity_w",
                "pax_w_booked",
                "pax_w_actual",
                "cargo_pcs",
            ]);
        });
    }
}
