<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToFlightsComFlightsPts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com_flights_pts', function (Blueprint $table) {
            $table->string("lofo_staff")->nullable()->after("mhb_dpr");
            $table->string("lofo_rmks")->nullable()->after("lofo_staff");
            $table->dateTime("lofo_start")->nullable()->after("lofo_rmks");
            $table->dateTime("lofo_end")->nullable()->after("lofo_start");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com_flights_pts', function (Blueprint $table) {
            $table->dropColumn([
                "lofo_staff",
                "lofo_rmks",
                "lofo_start",
                "lofo_end",
            ]);
        });
    }
}
