<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFuelFieldsToFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->integer("taxi")->nullable()->after("tof");
            $table->integer("block")->nullable()->after("taxi");
            $table->integer("trip")->nullable()->after("block");
            $table->string("altn")->nullable()->after("eet");

            $table->integer("dow")->nullable()->after("closed_sales");
            $table->integer("doi")->nullable()->after("dow");
            $table->integer("mtow")->nullable()->after("doi");
            $table->integer("rtow")->nullable()->after("mtow");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->dropColumn([
                "taxi",
                "block",
                "trip",
                "altn",

                "dow",
                "doi",
                "mtow",
                "rtow",
            ]);
        });
    }
}
