<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToFlightsComCheckin extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com_checkin', function (Blueprint $table) {
            $table->string("crew")->nullable()->after("capacity_y");
            $table->string("capt")->nullable()->after("crew");

            $table->integer("dow")->nullable()->after("capt");
            $table->integer("doi")->nullable()->after("dow");
            $table->integer("mtow")->nullable()->after("doi");
            $table->integer("rtow")->nullable()->after("mtow");
            $table->integer("tof")->nullable()->after("rtow");
            $table->integer("taxi")->nullable()->after("tof");
            $table->integer("block")->nullable()->after("taxi");
            $table->integer("trip")->nullable()->after("block");
            $table->time("eet")->nullable()->after("trip");
            $table->string("altn")->nullable()->after("eet");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com_checkin', function (Blueprint $table) {
            $table->dropColumn([
                "crew",
                "capt",

                "dow",
                "doi",
                "mtow",
                "rtow",
                "tof",
                "taxi",
                "block",
                "trip",
                "eet",
                "altn",
            ]);
        });
    }
}
