<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIdAndModelToUsersPageViews extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users__page_views', function (Blueprint $table) {
            $table->string("class_name")->nullable()->after("module_url");
            $table->string("class_id")->nullable()->after("class_name");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users__page_views', function (Blueprint $table) {
            $table->dropColumn([
                "class_name",
                "class_id",
            ]);
        });
    }
}
