<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsSsr extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__ssr', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger("flight_id")->nullable();
            $table->string("ssr", 16)->nullable();
            $table->integer("pax_c")->nullable();
            $table->integer("pax_y")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights__ssr');
    }
}
