<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddBkdCYNotesToFlightsScheduleFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__schedule_flights', function (Blueprint $table) {
            $table->integer("bkd_a")->nullable()->after("cfg_y");
            $table->integer("bkd_c")->nullable()->after("bkd_a");
            $table->integer("bkd_y")->nullable()->after("bkd_c");
            $table->text("notes")->nullable()->after("bkd_y");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__schedule_flights', function (Blueprint $table) {
            $table->dropColumn([
                "bkd_a",
                "bkd_c",
                "bkd_y",
                "notes",
            ]);
        });
    }
}
