<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddMessageToMessages2018 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('messages__2018', function (Blueprint $table) {
            $table->string("message")->nullable()->after("actual_id");
            $table->unique(["message", "actual_id"]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('messages__2018', function (Blueprint $table) {
            $table->dropUnique(["message", "actual_id"]);

            $table->dropColumn([
                "message",
            ]);
        });
    }
}
