<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMessages2018Table extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('messages__2018', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("actual_id")->nullable();
            // MVT, PNL, etc
            $table->string("type")->nullable();

            // PNL, PRL, etc
            $table->integer("part")->nullable();

            $table->string("status")->nullable();
            $table->boolean("important")->nullable();
            $table->boolean("seen")->nullable();
            $table->boolean("parsed")->nullable();

            // MVT
            $table->boolean("skipped")->nullable();

            $table->integer('email_id')->nullable();
            $table->string("message_id")->nullable();
            $table->integer("udate")->nullable();
            $table->unsignedInteger('flight_id')->nullable();
            $table->unsignedInteger("airline_id")->nullable();
            $table->unsignedInteger('flight_number_id')->nullable();

            // MVT, PNL, etc
            $table->integer("pax_c")->nullable();
            $table->integer("pax_y")->nullable();
            $table->integer("pax_inf")->nullable();

            // MVT, PRL
            $table->integer("baggage_pcs")->nullable();
            $table->double("baggage_wt")->nullable();

            $table->timestamp('received_datetime')->nullable();
            $table->string('from_email')->nullable();
            $table->string('to_email')->nullable();
            $table->text('email_body')->nullable();
            $table->string('email_title')->nullable();;
            $table->text('data')->nullable();
            $table->text("log")->nullable();

            $table->boolean("diversion")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('messages__2018');
    }
}
