<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class MakeNullableFieldsInAircraftTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('aircraft__types', function (Blueprint $table) {
            $table->string('name')->nullable()->change();
            $table->string('iata_name')->nullable()->change();
            $table->integer('min_ccm')->nullable()->change();
            $table->integer('policy_ccm')->nullable()->change();
            $table->integer('min_fcm')->nullable()->change();
            $table->integer('policy_fcm')->nullable()->change();
            $table->string('details')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('aircraft__types', function (Blueprint $table) {
            $table->string('name')->change();
            $table->string('iata_name')->change();
            $table->integer('min_ccm')->change();
            $table->integer('policy_ccm')->change();
            $table->integer('min_fcm')->change();
            $table->integer('policy_fcm')->change();
            $table->string('details')->change();
        });
    }
}
