<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeAircraftFields extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('aircraft', function (Blueprint $table) {
            $table->string('msn')->nullable()->change();
            $table->string('line_number')->nullable()->change();
            $table->date('first_flight')->nullable()->change();
            $table->integer('airframe_status')->nullable()->change();
            $table->integer('min_fcm')->nullable()->change();
            $table->integer('min_ccm')->nullable()->change();
            $table->integer('config_c')->nullable()->change();
            $table->integer('config_y')->nullable()->change();
            $table->integer('order')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('aircraft', function (Blueprint $table) {
            $table->string('msn')->change();
            $table->string('line_number')->change();
            $table->date('first_flight')->change();
            $table->integer('airframe_status')->change();
            $table->integer('min_fcm')->change();
            $table->integer('min_ccm')->change();
            $table->integer('config_c')->change();
            $table->integer('config_y')->change();
            $table->integer('order')->change();
        });
    }
}
